/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterSynchronizedProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterProcessingTimeTest {
    @Test
    public void testFireDeadline() throws Exception {
        Assert.assertEquals((Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)AfterProcessingTime.pastFirstElementInPane().getWatermarkThatGuaranteesFiring((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(10L))));
    }

    @Test
    public void testContinuation() throws Exception {
        AfterProcessingTime firstElementPlus1 = AfterProcessingTime.pastFirstElementInPane().plusDelayOf(Duration.standardHours((long)1L));
        Assert.assertEquals((Object)AfterSynchronizedProcessingTime.ofFirstElement(), (Object)firstElementPlus1.getContinuationTrigger());
    }

    @Test
    public void testCompatibilityIdentical() throws Exception {
        AfterProcessingTime t1 = AfterProcessingTime.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)1L));
        AfterProcessingTime t2 = AfterProcessingTime.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)1L));
        Assert.assertTrue((boolean)t1.isCompatible((Trigger)t2));
    }

    @Test
    public void testToString() {
        AfterProcessingTime trigger = AfterProcessingTime.pastFirstElementInPane();
        Assert.assertEquals((Object)"AfterProcessingTime.pastFirstElementInPane()", (Object)trigger.toString());
    }

    @Test
    public void testWithDelayToString() {
        AfterProcessingTime trigger = AfterProcessingTime.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)5L));
        Assert.assertEquals((Object)"AfterProcessingTime.pastFirstElementInPane().plusDelayOf(5 minutes)", (Object)trigger.toString());
    }

    @Test
    public void testBuiltUpToString() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withLateFirings((Trigger.OnceTrigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(Duration.standardMinutes((long)10L)));
        String expected = "AfterWatermark.pastEndOfWindow().withLateFirings(AfterProcessingTime.pastFirstElementInPane().plusDelayOf(10 minutes))";
        Assert.assertEquals((Object)expected, (Object)trigger.toString());
    }
}

