/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.transforms.windowing.AfterEach;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.StubTrigger;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterEachTest {
    @Test
    public void testFireDeadline() throws Exception {
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        Assert.assertEquals((Object)new Instant(9L), (Object)AfterEach.inOrder((Trigger[])new Trigger[]{AfterWatermark.pastEndOfWindow(), AfterPane.elementCountAtLeast((int)4)}).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
        Assert.assertEquals((Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)AfterEach.inOrder((Trigger[])new Trigger[]{AfterPane.elementCountAtLeast((int)2), AfterWatermark.pastEndOfWindow()}).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
    }

    @Test
    public void testContinuation() throws Exception {
        AfterProcessingTime trigger1 = AfterProcessingTime.pastFirstElementInPane();
        AfterWatermark.FromEndOfWindow trigger2 = AfterWatermark.pastEndOfWindow();
        AfterEach afterEach = AfterEach.inOrder((Trigger[])new Trigger[]{trigger1, trigger2});
        Assert.assertEquals((Object)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{trigger1.getContinuationTrigger(), trigger2.getContinuationTrigger()})), (Object)afterEach.getContinuationTrigger());
    }

    @Test
    public void testToString() {
        AfterEach trigger = AfterEach.inOrder((Trigger[])new Trigger[]{StubTrigger.named("t1"), StubTrigger.named("t2"), StubTrigger.named("t3")});
        Assert.assertEquals((Object)"AfterEach.inOrder(t1, t2, t3)", (Object)trigger.toString());
    }
}

