/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.transforms.windowing.AfterAll;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.StubTrigger;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterAllTest {
    @Test
    public void testFireDeadline() throws Exception {
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        Assert.assertEquals((Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)AfterAll.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterWatermark.pastEndOfWindow(), AfterPane.elementCountAtLeast((int)1)}).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
    }

    @Test
    public void testContinuation() throws Exception {
        AfterProcessingTime trigger1 = AfterProcessingTime.pastFirstElementInPane();
        AfterWatermark.FromEndOfWindow trigger2 = AfterWatermark.pastEndOfWindow();
        AfterAll afterAll = AfterAll.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{trigger1, trigger2});
        Assert.assertEquals((Object)AfterAll.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{trigger1.getContinuationTrigger(), trigger2.getContinuationTrigger()}), (Object)afterAll.getContinuationTrigger());
    }

    @Test
    public void testToString() {
        AfterAll trigger = AfterAll.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{StubTrigger.named("t1"), StubTrigger.named("t2")});
        Assert.assertEquals((Object)"AfterAll.of(t1, t2)", (Object)trigger.toString());
    }
}

