/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OffsetRangeTrackerTest {
    @Rule
    public final ExpectedException expected = ExpectedException.none();

    @Test
    public void testTryClaim() throws Exception {
        OffsetRange range = new OffsetRange(100L, 200L);
        OffsetRangeTracker tracker = new OffsetRangeTracker(range);
        Assert.assertEquals((Object)range, (Object)tracker.currentRestriction());
        Assert.assertTrue((boolean)tracker.tryClaim((Object)100L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)150L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)199L));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)200L));
    }

    @Test
    public void testCheckpointUnstarted() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        this.expected.expect(IllegalStateException.class);
        tracker.checkpoint();
    }

    @Test
    public void testCheckpointOnlyFailedClaim() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)250L));
        this.expected.expect(IllegalStateException.class);
        OffsetRange checkpoint = tracker.checkpoint();
    }

    @Test
    public void testCheckpointJustStarted() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)100L));
        OffsetRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)new OffsetRange(100L, 101L), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)new OffsetRange(101L, 200L), (Object)checkpoint);
    }

    @Test
    public void testCheckpointRegular() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)105L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)110L));
        OffsetRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)new OffsetRange(100L, 111L), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)new OffsetRange(111L, 200L), (Object)checkpoint);
    }

    @Test
    public void testCheckpointClaimedLast() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)105L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)110L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)199L));
        OffsetRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)new OffsetRange(100L, 200L), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)new OffsetRange(200L, 200L), (Object)checkpoint);
    }

    @Test
    public void testCheckpointAfterFailedClaim() throws Exception {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)105L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)110L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)160L));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)240L));
        OffsetRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)new OffsetRange(100L, 161L), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)new OffsetRange(161L, 200L), (Object)checkpoint);
    }

    @Test
    public void testNonMonotonicClaim() throws Exception {
        this.expected.expectMessage("Trying to claim offset 103 while last attempted was 110");
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)105L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)110L));
        tracker.tryClaim((Object)103L);
    }

    @Test
    public void testClaimBeforeStartOfRange() throws Exception {
        this.expected.expectMessage("Trying to claim offset 90 before start of the range [100, 200)");
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        tracker.tryClaim((Object)90L);
    }

    @Test
    public void testCheckDoneAfterTryClaimPastEndOfRange() {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)150L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)175L));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)220L));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneAfterTryClaimAtEndOfRange() {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)150L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)175L));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)200L));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneAfterTryClaimRightBeforeEndOfRange() {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)150L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)175L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)199L));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneWhenNotDone() {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)150L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)175L));
        this.expected.expectMessage("Last attempted offset was 175 in range [100, 200), claiming work in [176, 200) was not attempted");
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneWhenExplicitlyMarkedDone() {
        OffsetRangeTracker tracker = new OffsetRangeTracker(new OffsetRange(100L, 200L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)150L));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)175L));
        tracker.markDone();
        tracker.checkDone();
    }
}

