/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.transforms.splittabledofn.ByteKeyRangeTracker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteKeyRangeTrackerTest {
    @Rule
    public final ExpectedException expected = ExpectedException.none();

    @Test
    public void testTryClaim() throws Exception {
        ByteKeyRange range = ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192}));
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)range);
        Assert.assertEquals((Object)range, (Object)tracker.currentRestriction());
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{16})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{16, 0})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{16, 0, 0})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{153})));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{192})));
    }

    @Test
    public void testCheckpointUnstarted() throws Exception {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        this.expected.expect(IllegalStateException.class);
        tracker.checkpoint();
    }

    @Test
    public void testCheckpointOnlyFailedClaim() throws Exception {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{208})));
        this.expected.expect(IllegalStateException.class);
        tracker.checkpoint();
    }

    @Test
    public void testCheckpointJustStarted() throws Exception {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{16})));
        ByteKeyRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{17})), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{17}), (ByteKey)ByteKey.of((int[])new int[]{192})), (Object)checkpoint);
    }

    @Test
    public void testCheckpointRegular() throws Exception {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        ByteKeyRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{145})), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{145}), (ByteKey)ByteKey.of((int[])new int[]{192})), (Object)checkpoint);
    }

    @Test
    public void testCheckpointClaimedLast() throws Exception {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{191})));
        ByteKeyRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{192}), (ByteKey)ByteKey.of((int[])new int[]{192})), (Object)checkpoint);
    }

    @Test
    public void testCheckpointAfterFailedClaim() throws Exception {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{160})));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{208})));
        ByteKeyRange checkpoint = tracker.checkpoint();
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{161})), (Object)tracker.currentRestriction());
        Assert.assertEquals((Object)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{161}), (ByteKey)ByteKey.of((int[])new int[]{192})), (Object)checkpoint);
    }

    @Test
    public void testNonMonotonicClaim() throws Exception {
        this.expected.expectMessage("Trying to claim key [70] while last attempted was [90]");
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        tracker.tryClaim((Object)ByteKey.of((int[])new int[]{112}));
    }

    @Test
    public void testClaimBeforeStartOfRange() throws Exception {
        this.expected.expectMessage("Trying to claim key [05] before start of the range ByteKeyRange{startKey=[10], endKey=[c0]}");
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        tracker.tryClaim((Object)ByteKey.of((int[])new int[]{5}));
    }

    @Test
    public void testCheckDoneAfterTryClaimPastEndOfRange() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{208})));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneAfterTryClaimAtEndOfRange() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        Assert.assertFalse((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{192})));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneAfterTryClaimRightBeforeEndOfRange() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{191})));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneWhenNotDone() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        this.expected.expectMessage("Last attempted key was [90] in range ByteKeyRange{startKey=[10], endKey=[c0]}, claiming work in [[91], [c0]) was not attempted");
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneWhenExplicitlyMarkedDone() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{80})));
        Assert.assertTrue((boolean)tracker.tryClaim((Object)ByteKey.of((int[])new int[]{144})));
        tracker.markDone();
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneUnstarted() {
        ByteKeyRangeTracker tracker = ByteKeyRangeTracker.of((ByteKeyRange)ByteKeyRange.of((ByteKey)ByteKey.of((int[])new int[]{16}), (ByteKey)ByteKey.of((int[])new int[]{192})));
        this.expected.expect(IllegalStateException.class);
        tracker.checkDone();
    }

    @Test
    public void testNextByteKey() {
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.EMPTY), (Object)ByteKey.of((int[])new int[]{0}));
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.of((int[])new int[]{0})), (Object)ByteKey.of((int[])new int[]{1}));
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.of((int[])new int[]{159})), (Object)ByteKey.of((int[])new int[]{160}));
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.of((int[])new int[]{255})), (Object)ByteKey.of((int[])new int[]{1, 0}));
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.of((int[])new int[]{16, 16})), (Object)ByteKey.of((int[])new int[]{16, 17}));
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.of((int[])new int[]{0, 255})), (Object)ByteKey.of((int[])new int[]{1, 0}));
        Assert.assertEquals((Object)ByteKeyRangeTracker.next((ByteKey)ByteKey.of((int[])new int[]{255, 255})), (Object)ByteKey.of((int[])new int[]{1, 0, 0}));
    }
}

