/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect.testhelper;

import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.junit.Assert;
import org.mockito.Mockito;

public class DoFnInvokersTestHelper {
    private static final String TIMER_ID = "test-timer-id";

    public static DoFn<String, String> newStaticPackagePrivateDoFn() {
        return new StaticPackagePrivateDoFn();
    }

    public static void verifyStaticPackagePrivateDoFn(DoFn<String, String> fn, DoFn.ProcessContext context) {
        ((StaticPackagePrivateDoFn)((Object)Mockito.verify((Object)((Object)((StaticPackagePrivateDoFn)fn))))).process(context);
    }

    public DoFn<String, String> newInnerPackagePrivateDoFn() {
        return new InnerPackagePrivateDoFn();
    }

    public static void verifyInnerPackagePrivateDoFn(DoFn<String, String> fn, DoFn.ProcessContext context) {
        ((InnerPackagePrivateDoFn)((Object)Mockito.verify((Object)((Object)((InnerPackagePrivateDoFn)fn))))).process(context);
    }

    public static DoFn<String, String> newStaticPrivateDoFn() {
        return new StaticPrivateDoFn();
    }

    public static void verifyStaticPrivateDoFn(DoFn<String, String> fn, DoFn.ProcessContext context) {
        ((StaticPrivateDoFn)((Object)Mockito.verify((Object)((Object)((StaticPrivateDoFn)fn))))).process(context);
    }

    public DoFn<String, String> newInnerPrivateDoFn() {
        return new InnerPrivateDoFn();
    }

    public static void verifyInnerPrivateDoFn(DoFn<String, String> fn, DoFn.ProcessContext context) {
        ((InnerPrivateDoFn)((Object)Mockito.verify((Object)((Object)((InnerPrivateDoFn)fn))))).process(context);
    }

    public DoFn<String, String> newInnerAnonymousDoFn() {
        return new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }
        };
    }

    public static void verifyInnerAnonymousDoFn(DoFn<String, String> fn, DoFn.ProcessContext context) throws Exception {
        DoFn verifier = (DoFn)Mockito.verify(fn);
        verifier.getClass().getMethod("process", DoFn.ProcessContext.class).invoke((Object)verifier, context);
    }

    public static DoFn<String, String> newStaticAnonymousDoFn() {
        return new DoFn<String, String>(){
            private DoFn.ProcessContext invokedContext;

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
                Assert.assertNull((String)"Should have been invoked just once", (Object)this.invokedContext);
                this.invokedContext = c;
            }

            public void verify(DoFn.ProcessContext context) {
                Assert.assertEquals((Object)context, (Object)this.invokedContext);
            }
        };
    }

    public static void verifyStaticAnonymousDoFnInvoked(DoFn<String, String> fn, DoFn.ProcessContext context) throws Exception {
        fn.getClass().getMethod("verify", DoFn.ProcessContext.class).invoke(fn, context);
    }

    public static DoFn<String, String> newStaticPackagePrivateDoFnWithTimers() {
        return new StaticPackagePrivateDoFnWithTimers();
    }

    public static void verifyStaticPackagePrivateDoFnWithTimers(DoFn<String, String> fn, BoundedWindow window) {
        ((StaticPackagePrivateDoFnWithTimers)((Object)Mockito.verify((Object)((Object)((StaticPackagePrivateDoFnWithTimers)fn))))).onTimer(window);
    }

    public DoFn<String, String> newInnerPackagePrivateDoFnWithTimers() {
        return new InnerPackagePrivateDoFnWithTimers();
    }

    public static void verifyInnerPackagePrivateDoFnWithTimers(DoFn<String, String> fn, BoundedWindow window) {
        ((InnerPackagePrivateDoFnWithTimers)((Object)Mockito.verify((Object)((Object)((InnerPackagePrivateDoFnWithTimers)fn))))).onTimer(window);
    }

    public static DoFn<String, String> newStaticPrivateDoFnWithTimers() {
        return new StaticPrivateDoFnWithTimers();
    }

    public static void verifyStaticPrivateDoFnWithTimers(DoFn<String, String> fn, BoundedWindow window) {
        ((StaticPrivateDoFnWithTimers)((Object)Mockito.verify((Object)((Object)((StaticPrivateDoFnWithTimers)fn))))).onTimer(window);
    }

    public DoFn<String, String> newInnerPrivateDoFnWithTimers() {
        return new InnerPrivateDoFnWithTimers();
    }

    public static void verifyInnerPrivateDoFnWithTimers(DoFn<String, String> fn, BoundedWindow window) {
        ((InnerPrivateDoFnWithTimers)((Object)Mockito.verify((Object)((Object)((InnerPrivateDoFnWithTimers)fn))))).onTimer(window);
    }

    public DoFn<String, String> newInnerAnonymousDoFnWithTimers() {
        return new DoFn<String, String>(){
            @DoFn.TimerId(value="test-timer-id")
            private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

            @DoFn.OnTimer(value="test-timer-id")
            public void onTimer(BoundedWindow w) {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }
        };
    }

    public static void verifyInnerAnonymousDoFnWithTimers(DoFn<String, String> fn, BoundedWindow window) throws Exception {
        DoFn verifier = (DoFn)Mockito.verify(fn);
        verifier.getClass().getMethod("onTimer", BoundedWindow.class).invoke((Object)verifier, window);
    }

    public static DoFn<String, String> newStaticAnonymousDoFnWithTimers() {
        return new DoFn<String, String>(){
            private BoundedWindow invokedWindow;
            @DoFn.TimerId(value="test-timer-id")
            private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }

            @DoFn.OnTimer(value="test-timer-id")
            public void onTimer(BoundedWindow window) {
                Assert.assertNull((String)"Should have been invoked just once", (Object)this.invokedWindow);
                this.invokedWindow = window;
            }

            public void verify(BoundedWindow window) {
                Assert.assertEquals((Object)window, (Object)this.invokedWindow);
            }
        };
    }

    public static void verifyStaticAnonymousDoFnWithTimersInvoked(DoFn<String, String> fn, BoundedWindow window) throws Exception {
        fn.getClass().getMethod("verify", BoundedWindow.class).invoke(fn, window);
    }

    class InnerPackagePrivateDoFnWithTimers
    extends DoFn<String, String> {
        @DoFn.TimerId(value="test-timer-id")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        InnerPackagePrivateDoFnWithTimers() {
        }

        @DoFn.OnTimer(value="test-timer-id")
        public void onTimer(BoundedWindow w) {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    static class StaticPackagePrivateDoFnWithTimers
    extends DoFn<String, String> {
        @DoFn.TimerId(value="test-timer-id")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        StaticPackagePrivateDoFnWithTimers() {
        }

        @DoFn.OnTimer(value="test-timer-id")
        public void onTimer(BoundedWindow w) {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    private class InnerPrivateDoFnWithTimers
    extends DoFn<String, String> {
        @DoFn.TimerId(value="test-timer-id")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        private InnerPrivateDoFnWithTimers() {
        }

        @DoFn.OnTimer(value="test-timer-id")
        public void onTimer(BoundedWindow w) {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    private static class StaticPrivateDoFnWithTimers
    extends DoFn<String, String> {
        @DoFn.TimerId(value="test-timer-id")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        private StaticPrivateDoFnWithTimers() {
        }

        @DoFn.OnTimer(value="test-timer-id")
        public void onTimer(BoundedWindow w) {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    class InnerPackagePrivateDoFn
    extends DoFn<String, String> {
        InnerPackagePrivateDoFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    static class StaticPackagePrivateDoFn
    extends DoFn<String, String> {
        StaticPackagePrivateDoFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    private class InnerPrivateDoFn
    extends DoFn<String, String> {
        private InnerPrivateDoFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    private static class StaticPrivateDoFn
    extends DoFn<String, String> {
        private StaticPrivateDoFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }
}

