/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvoker;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class OnTimerInvokersTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private BoundedWindow mockWindow;
    @Mock
    private DoFnInvoker.ArgumentProvider<String, String> mockArgumentProvider;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockArgumentProvider.window()).thenReturn((Object)this.mockWindow);
    }

    private void invokeOnTimer(DoFn<String, String> fn, String timerId) {
        OnTimerInvokers.forTimer(fn, (String)timerId).invokeOnTimer(this.mockArgumentProvider);
    }

    @Test
    public void testOnTimerHelloWord() throws Exception {
        String timerId = "my-timer-id";
        class SimpleTimerDoFn
        extends DoFn<String, String> {
            public String status = "not yet";
            @DoFn.TimerId(value="my-timer-id")
            private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

            SimpleTimerDoFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }

            @DoFn.OnTimer(value="my-timer-id")
            public void onMyTimer() {
                this.status = "OK now";
            }
        }
        SimpleTimerDoFn fn = new SimpleTimerDoFn();
        this.invokeOnTimer(fn, "my-timer-id");
        Assert.assertThat((Object)fn.status, (Matcher)Matchers.equalTo((Object)"OK now"));
    }

    @Test
    public void testOnTimerWithWindow() throws Exception {
        WindowedTimerDoFn fn = new WindowedTimerDoFn();
        this.invokeOnTimer(fn, "my-timer-id");
        Assert.assertThat((Object)fn.window, (Matcher)Matchers.theInstance((Object)this.mockWindow));
    }

    @Test
    public void testStableName() {
        OnTimerInvoker invoker = OnTimerInvokers.forTimer((DoFn)new StableNameTestDoFn(), (String)"timer-id.with specialChars{}");
        Assert.assertThat((Object)invoker.getClass().getName(), (Matcher)Matchers.equalTo((Object)String.format("%s$%s$%s$%s", StableNameTestDoFn.class.getName(), OnTimerInvoker.class.getSimpleName(), "timeridwithspecialChars", "dGltZXItaWQud2l0aCBzcGVjaWFsQ2hhcnN7fQ")));
    }

    static class StableNameTestDoFn
    extends DoFn<Void, Void> {
        private static final String TIMER_ID = "timer-id.with specialChars{}";
        @DoFn.TimerId(value="timer-id.with specialChars{}")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        StableNameTestDoFn() {
        }

        @DoFn.ProcessElement
        public void process() {
        }

        @DoFn.OnTimer(value="timer-id.with specialChars{}")
        public void onMyTimer() {
        }
    }

    private static class WindowedTimerDoFn
    extends DoFn<String, String> {
        public static final String TIMER_ID = "my-timer-id";
        public BoundedWindow window = null;
        @DoFn.TimerId(value="my-timer-id")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        private WindowedTimerDoFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }

        @DoFn.OnTimer(value="my-timer-id")
        public void onMyTimer(BoundedWindow window) {
            this.window = window;
        }
    }
}

