/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import java.lang.reflect.Method;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Predicates;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.reflect.DoFnSignaturesTestUtils;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DoFnSignaturesSplittableDoFnTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testReturnsProcessContinuation() throws Exception {
        DoFnSignature.ProcessElementMethod signature = DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private DoFn.ProcessContinuation method(DoFn.ProcessContext context) {
                return null;
            }
        });
        Assert.assertTrue((boolean)signature.hasReturnValue());
    }

    @Test
    public void testHasRestrictionTracker() throws Exception {
        DoFnSignature.ProcessElementMethod signature = DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }
        });
        Assert.assertTrue((boolean)signature.isSplittable());
        Assert.assertTrue((boolean)signature.extraParameters().stream().anyMatch(Predicates.instanceOf(DoFnSignature.Parameter.RestrictionTrackerParameter.class)::apply));
        Assert.assertEquals(SomeRestrictionTracker.class, (Object)signature.trackerT().getRawType());
    }

    @Test
    public void testSplittableProcessElementMustNotHaveOtherParams() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Illegal parameter");
        this.thrown.expectMessage("BoundedWindow");
        DoFnSignature.ProcessElementMethod signature = DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(DoFn.ProcessContext context, SomeRestrictionTracker tracker, BoundedWindow window) {
            }
        });
    }

    @Test
    public void testInfersBoundednessFromAnnotation() throws Exception {
        class BaseSplittableFn
        extends DoFn<Integer, String> {
            BaseSplittableFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }
        }
        Assert.assertEquals((Object)PCollection.IsBounded.BOUNDED, (Object)DoFnSignatures.getSignature(BaseSplittableFn.class).isBoundedPerElement());
        @DoFn.BoundedPerElement
        class BoundedSplittableFn
        extends BaseSplittableFn {
            BoundedSplittableFn() {
            }
        }
        Assert.assertEquals((Object)PCollection.IsBounded.BOUNDED, (Object)DoFnSignatures.getSignature(BoundedSplittableFn.class).isBoundedPerElement());
        @DoFn.UnboundedPerElement
        class UnboundedSplittableFn
        extends BaseSplittableFn {
            UnboundedSplittableFn() {
            }
        }
        Assert.assertEquals((Object)PCollection.IsBounded.UNBOUNDED, (Object)DoFnSignatures.getSignature(UnboundedSplittableFn.class).isBoundedPerElement());
    }

    @Test
    public void testSplittableBoundednessInferredFromReturnValue() throws Exception {
        Assert.assertEquals((Object)PCollection.IsBounded.BOUNDED, (Object)DoFnSignatures.getSignature(BaseFnWithoutContinuation.class).isBoundedPerElement());
        Assert.assertEquals((Object)PCollection.IsBounded.UNBOUNDED, (Object)DoFnSignatures.getSignature(BaseFnWithContinuation.class).isBoundedPerElement());
    }

    @Test
    public void testSplittableRespectsBoundednessAnnotation() throws Exception {
        @DoFn.BoundedPerElement
        class BoundedFnWithContinuation
        extends BaseFnWithContinuation {
            BoundedFnWithContinuation() {
            }
        }
        Assert.assertEquals((Object)PCollection.IsBounded.BOUNDED, (Object)DoFnSignatures.getSignature(BoundedFnWithContinuation.class).isBoundedPerElement());
        @DoFn.UnboundedPerElement
        class UnboundedFnWithContinuation
        extends BaseFnWithContinuation {
            UnboundedFnWithContinuation() {
            }
        }
        Assert.assertEquals((Object)PCollection.IsBounded.UNBOUNDED, (Object)DoFnSignatures.getSignature(UnboundedFnWithContinuation.class).isBoundedPerElement());
    }

    @Test
    public void testUnsplittableIsBounded() throws Exception {
        class UnsplittableFn
        extends DoFn<Integer, String> {
            UnsplittableFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context) {
            }
        }
        Assert.assertEquals((Object)PCollection.IsBounded.BOUNDED, (Object)DoFnSignatures.getSignature(UnsplittableFn.class).isBoundedPerElement());
    }

    @Test
    public void testUnsplittableButDeclaresBounded() throws Exception {
        this.thrown.expectMessage("Non-splittable, but annotated as @Bounded");
        @DoFn.BoundedPerElement
        class SomeFn
        extends DoFn<Integer, String> {
            SomeFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context) {
            }
        }
        DoFnSignatures.getSignature(SomeFn.class);
    }

    @Test
    public void testUnsplittableButDeclaresUnbounded() throws Exception {
        this.thrown.expectMessage("Non-splittable, but annotated as @Unbounded");
        @DoFn.UnboundedPerElement
        class SomeFn
        extends DoFn<Integer, String> {
            SomeFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context) {
            }
        }
        DoFnSignatures.getSignature(SomeFn.class);
    }

    @Test
    public void testSplittableWithAllFunctions() throws Exception {
        class GoodSplittableDoFn
        extends DoFn<Integer, String> {
            GoodSplittableDoFn() {
            }

            @DoFn.ProcessElement
            public DoFn.ProcessContinuation processElement(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
                return null;
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }

            @DoFn.SplitRestriction
            public void splitRestriction(Integer element, SomeRestriction restriction, DoFn.OutputReceiver<SomeRestriction> receiver) {
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }

            @DoFn.GetRestrictionCoder
            public SomeRestrictionCoder getRestrictionCoder() {
                return null;
            }
        }
        DoFnSignature signature = DoFnSignatures.getSignature(GoodSplittableDoFn.class);
        Assert.assertEquals(SomeRestrictionTracker.class, (Object)signature.processElement().trackerT().getRawType());
        Assert.assertTrue((boolean)signature.processElement().isSplittable());
        Assert.assertTrue((boolean)signature.processElement().hasReturnValue());
        Assert.assertEquals(SomeRestriction.class, (Object)signature.getInitialRestriction().restrictionT().getRawType());
        Assert.assertEquals(SomeRestriction.class, (Object)signature.splitRestriction().restrictionT().getRawType());
        Assert.assertEquals(SomeRestrictionTracker.class, (Object)signature.newTracker().trackerT().getRawType());
        Assert.assertEquals(SomeRestriction.class, (Object)signature.newTracker().restrictionT().getRawType());
        Assert.assertEquals(SomeRestrictionCoder.class, (Object)signature.getRestrictionCoder().coderT().getRawType());
    }

    @Test
    public void testSplittableWithAllFunctionsGeneric() throws Exception {
        class GoodGenericSplittableDoFn<RestrictionT, TrackerT, CoderT>
        extends DoFn<Integer, String> {
            GoodGenericSplittableDoFn() {
            }

            @DoFn.ProcessElement
            public DoFn.ProcessContinuation processElement(DoFn.ProcessContext context, TrackerT tracker) {
                return null;
            }

            @DoFn.GetInitialRestriction
            public RestrictionT getInitialRestriction(Integer element) {
                return null;
            }

            @DoFn.SplitRestriction
            public void splitRestriction(Integer element, RestrictionT restriction, DoFn.OutputReceiver<RestrictionT> receiver) {
            }

            @DoFn.NewTracker
            public TrackerT newTracker(RestrictionT restriction) {
                return null;
            }

            @DoFn.GetRestrictionCoder
            public CoderT getRestrictionCoder() {
                return null;
            }
        }
        DoFnSignature signature = DoFnSignatures.getSignature(((Object)new GoodGenericSplittableDoFn<SomeRestriction, SomeRestrictionTracker, SomeRestrictionCoder>(){
            {
            }
        }).getClass());
        Assert.assertEquals(SomeRestrictionTracker.class, (Object)signature.processElement().trackerT().getRawType());
        Assert.assertTrue((boolean)signature.processElement().isSplittable());
        Assert.assertTrue((boolean)signature.processElement().hasReturnValue());
        Assert.assertEquals(SomeRestriction.class, (Object)signature.getInitialRestriction().restrictionT().getRawType());
        Assert.assertEquals(SomeRestriction.class, (Object)signature.splitRestriction().restrictionT().getRawType());
        Assert.assertEquals(SomeRestrictionTracker.class, (Object)signature.newTracker().trackerT().getRawType());
        Assert.assertEquals(SomeRestriction.class, (Object)signature.newTracker().restrictionT().getRawType());
        Assert.assertEquals(SomeRestrictionCoder.class, (Object)signature.getRestrictionCoder().coderT().getRawType());
    }

    @Test
    public void testSplittableMissingRequiredMethods() throws Exception {
        this.thrown.expectMessage("Splittable, but does not define the following required methods: [@GetInitialRestriction, @NewTracker]");
        class BadFn
        extends DoFn<Integer, String> {
            BadFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }
        }
        DoFnSignatures.getSignature(BadFn.class);
    }

    @Test
    public void testHasDefaultTracker() throws Exception {
        class Fn
        extends DoFn<Integer, String> {
            Fn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c, SomeDefaultTracker tracker) {
            }

            @DoFn.GetInitialRestriction
            public RestrictionWithDefaultTracker getInitialRestriction(Integer element) {
                return null;
            }
        }
        DoFnSignature signature = DoFnSignatures.getSignature(Fn.class);
        Assert.assertEquals(SomeDefaultTracker.class, (Object)signature.processElement().trackerT().getRawType());
    }

    @Test
    public void testRestrictionHasDefaultTrackerProcessUsesWrongTracker() throws Exception {
        this.thrown.expectMessage("Has tracker type SomeRestrictionTracker, but the DoFn's tracker type was inferred as ");
        this.thrown.expectMessage("SomeDefaultTracker");
        this.thrown.expectMessage("from restriction type RestrictionWithDefaultTracker of @GetInitialRestriction method getInitialRestriction(Integer)");
        class Fn
        extends DoFn<Integer, String> {
            Fn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c, SomeRestrictionTracker tracker) {
            }

            @DoFn.GetInitialRestriction
            public RestrictionWithDefaultTracker getInitialRestriction(Integer element) {
                return null;
            }
        }
        DoFnSignatures.getSignature(Fn.class);
    }

    @Test
    public void testNewTrackerReturnsWrongType() throws Exception {
        this.thrown.expectMessage("Returns void, but must return a subtype of RestrictionTracker<SomeRestriction, ?>");
        class BadFn
        extends DoFn<Integer, String> {
            BadFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }

            @DoFn.NewTracker
            public void newTracker(SomeRestriction restriction) {
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }
        }
        DoFnSignatures.getSignature(BadFn.class);
    }

    @Test
    public void testGetInitialRestrictionMismatchesNewTracker() throws Exception {
        this.thrown.expectMessage("getInitialRestriction(Integer): Uses restriction type String, but @NewTracker method");
        this.thrown.expectMessage("newTracker(SomeRestriction) uses restriction type SomeRestriction");
        class BadFn
        extends DoFn<Integer, String> {
            BadFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }

            @DoFn.GetInitialRestriction
            public String getInitialRestriction(Integer element) {
                return null;
            }
        }
        DoFnSignatures.getSignature(BadFn.class);
    }

    @Test
    public void testGetRestrictionCoderReturnsWrongType() throws Exception {
        this.thrown.expectMessage("getRestrictionCoder() returns KvCoder which is not a subtype of Coder<SomeRestriction>");
        class BadFn
        extends DoFn<Integer, String> {
            BadFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }

            @DoFn.GetRestrictionCoder
            public KvCoder getRestrictionCoder() {
                return null;
            }
        }
        DoFnSignatures.getSignature(BadFn.class);
    }

    @Test
    public void testSplitRestrictionReturnsWrongType() throws Exception {
        this.thrown.expectMessage("Third argument must be DoFn.OutputReceiver<SomeRestriction>, but is DoFn.OutputReceiver<String>");
        DoFnSignatures.analyzeSplitRestrictionMethod((DoFnSignatures.ErrorReporter)DoFnSignaturesTestUtils.errors(), (TypeDescriptor)TypeDescriptor.of(DoFnSignaturesTestUtils.FakeDoFn.class), (Method)new DoFnSignaturesTestUtils.AnonymousMethod(){

            void method(Integer element, SomeRestriction restriction, DoFn.OutputReceiver<String> receiver) {
            }
        }.getMethod(), (TypeDescriptor)TypeDescriptor.of(Integer.class));
    }

    @Test
    public void testSplitRestrictionWrongElementArgument() throws Exception {
        this.thrown.expectMessage("First argument must be the element type Integer");
        DoFnSignatures.analyzeSplitRestrictionMethod((DoFnSignatures.ErrorReporter)DoFnSignaturesTestUtils.errors(), (TypeDescriptor)TypeDescriptor.of(DoFnSignaturesTestUtils.FakeDoFn.class), (Method)new DoFnSignaturesTestUtils.AnonymousMethod(){

            void method(String element, SomeRestriction restriction, DoFn.OutputReceiver<SomeRestriction> receiver) {
            }
        }.getMethod(), (TypeDescriptor)TypeDescriptor.of(Integer.class));
    }

    @Test
    public void testSplitRestrictionWrongNumArguments() throws Exception {
        this.thrown.expectMessage("Must have exactly 3 arguments");
        DoFnSignatures.analyzeSplitRestrictionMethod((DoFnSignatures.ErrorReporter)DoFnSignaturesTestUtils.errors(), (TypeDescriptor)TypeDescriptor.of(DoFnSignaturesTestUtils.FakeDoFn.class), (Method)new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(Integer element, SomeRestriction restriction, DoFn.OutputReceiver<SomeRestriction> receiver, Object extra) {
            }
        }.getMethod(), (TypeDescriptor)TypeDescriptor.of(Integer.class));
    }

    @Test
    public void testSplitRestrictionConsistentButWrongType() throws Exception {
        this.thrown.expectMessage("getInitialRestriction(Integer): Uses restriction type SomeRestriction, but @SplitRestriction method ");
        this.thrown.expectMessage("splitRestriction(Integer, OtherRestriction, OutputReceiver) uses restriction type OtherRestriction");
        class BadFn
        extends DoFn<Integer, String> {
            BadFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }

            @DoFn.SplitRestriction
            public void splitRestriction(Integer element, 1OtherRestriction restriction, DoFn.OutputReceiver<1OtherRestriction> receiver) {
            }
        }
        DoFnSignatures.getSignature(BadFn.class);
    }

    @Test
    public void testUnsplittableMustNotDefineExtraMethods() throws Exception {
        this.thrown.expectMessage("Non-splittable, but defines methods: [@GetInitialRestriction, @SplitRestriction, @NewTracker, @GetRestrictionCoder]");
        class BadFn
        extends DoFn<Integer, String> {
            BadFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) {
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }

            @DoFn.SplitRestriction
            public void splitRestriction(Integer element, SomeRestriction restriction, DoFn.OutputReceiver<SomeRestriction> receiver) {
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }

            @DoFn.GetRestrictionCoder
            public SomeRestrictionCoder getRestrictionCoder() {
                return null;
            }
        }
        DoFnSignatures.getSignature(BadFn.class);
    }

    @Test
    public void testNewTrackerWrongNumArguments() throws Exception {
        this.thrown.expectMessage("Must have a single argument");
        DoFnSignatures.analyzeNewTrackerMethod((DoFnSignatures.ErrorReporter)DoFnSignaturesTestUtils.errors(), (TypeDescriptor)TypeDescriptor.of(DoFnSignaturesTestUtils.FakeDoFn.class), (Method)new DoFnSignaturesTestUtils.AnonymousMethod(){

            private SomeRestrictionTracker method(SomeRestriction restriction, Object extra) {
                return null;
            }
        }.getMethod());
    }

    @Test
    public void testNewTrackerInconsistent() throws Exception {
        this.thrown.expectMessage("Returns SomeRestrictionTracker, but must return a subtype of RestrictionTracker<String, ?>");
        DoFnSignatures.analyzeNewTrackerMethod((DoFnSignatures.ErrorReporter)DoFnSignaturesTestUtils.errors(), (TypeDescriptor)TypeDescriptor.of(DoFnSignaturesTestUtils.FakeDoFn.class), (Method)new DoFnSignaturesTestUtils.AnonymousMethod(){

            private SomeRestrictionTracker method(String restriction) {
                return null;
            }
        }.getMethod());
    }

    static abstract class RestrictionWithDefaultTracker
    implements HasDefaultTracker<RestrictionWithDefaultTracker, SomeDefaultTracker> {
        RestrictionWithDefaultTracker() {
        }
    }

    static abstract class SomeDefaultTracker
    extends RestrictionTracker<RestrictionWithDefaultTracker, Void> {
        SomeDefaultTracker() {
        }
    }

    private static class BaseFnWithContinuation
    extends DoFn<Integer, String> {
        private BaseFnWithContinuation() {
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
            return null;
        }

        @DoFn.GetInitialRestriction
        public SomeRestriction getInitialRestriction(Integer element) {
            return null;
        }
    }

    private static class BaseFnWithoutContinuation
    extends DoFn<Integer, String> {
        private BaseFnWithoutContinuation() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context, SomeRestrictionTracker tracker) {
        }

        @DoFn.GetInitialRestriction
        public SomeRestriction getInitialRestriction(Integer element) {
            return null;
        }
    }

    private static abstract class SomeRestrictionCoder
    extends StructuredCoder<SomeRestriction> {
        private SomeRestrictionCoder() {
        }
    }

    private static abstract class SomeRestrictionTracker
    extends RestrictionTracker<SomeRestriction, Void> {
        private SomeRestrictionTracker() {
        }
    }

    private static abstract class SomeRestriction
    implements HasDefaultTracker<SomeRestriction, SomeRestrictionTracker> {
        private SomeRestriction() {
        }
    }
}

