/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import java.util.List;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.reflect.DoFnSignaturesTestUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DoFnSignaturesProcessElementTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBadExtraProcessContextType() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Integer is not a valid context parameter. Should be one of [BoundedWindow, RestrictionTracker<?, ?>]");
        DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(DoFn.ProcessContext c, Integer n) {
            }
        });
    }

    @Test
    public void testBadReturnType() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Must return void or ProcessContinuation");
        DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private int method(DoFn.ProcessContext context) {
                return 0;
            }
        });
    }

    @Test
    public void testGoodConcreteTypes() throws Exception {
        DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(DoFn.ProcessContext c) {
            }
        });
    }

    @Test
    public void testBadGenericsTwoArgs() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("DoFn<Integer, Integer>.ProcessContext");
        this.thrown.expectMessage("must have type");
        this.thrown.expectMessage("DoFn<Integer, String>.ProcessContext");
        DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(DoFn.ProcessContext c) {
            }
        });
    }

    @Test
    public void testBadGenericWildCards() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("DoFn<Integer, ? super Integer>.ProcessContext");
        this.thrown.expectMessage("must have type");
        this.thrown.expectMessage("DoFn<Integer, String>.ProcessContext");
        DoFnSignaturesTestUtils.analyzeProcessElementMethod(new DoFnSignaturesTestUtils.AnonymousMethod(){

            private void method(DoFn.ProcessContext c) {
            }
        });
    }

    @Test
    public void testBadTypeVariables() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("DoFn<InputT, InputT>.ProcessContext");
        this.thrown.expectMessage("must have type");
        this.thrown.expectMessage("DoFn<InputT, OutputT>.ProcessContext");
        DoFnSignatures.getSignature(BadTypeVariables.class);
    }

    @Test
    public void testNoProcessElement() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("No method annotated with @ProcessElement found");
        this.thrown.expectMessage(this.getClass().getName() + "$");
        DoFnSignatures.getSignature(new DoFn<String, String>(){}.getClass());
    }

    @Test
    public void testMultipleProcessElement() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Found multiple methods annotated with @ProcessElement");
        this.thrown.expectMessage("foo()");
        this.thrown.expectMessage("bar()");
        this.thrown.expectMessage(this.getClass().getName() + "$");
        DoFnSignatures.getSignature(new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void foo() {
            }

            @DoFn.ProcessElement
            public void bar() {
            }
        }.getClass());
    }

    @Test
    public void testPrivateProcessElement() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("process()");
        this.thrown.expectMessage("Must be public");
        this.thrown.expectMessage(this.getClass().getName() + "$");
        DoFnSignatures.getSignature(new DoFn<String, String>(){

            @DoFn.ProcessElement
            private void process() {
            }
        }.getClass());
    }

    @Test
    public void testGoodTypeVariables() throws Exception {
        DoFnSignatures.getSignature(GoodTypeVariables.class);
    }

    @Test
    public void testIdentityFnApplied() throws Exception {
        DoFnSignatures.getSignature(((Object)new IdentityFn<String>(){}).getClass());
    }

    private static class IdentityListFn<T>
    extends IdentityFn<List<T>> {
        private IdentityListFn() {
        }
    }

    private static class IdentityFn<T>
    extends DoFn<T, T> {
        private IdentityFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(c.element());
        }
    }

    private static class GoodTypeVariables<InputT, OutputT>
    extends DoFn<InputT, OutputT> {
        private GoodTypeVariables() {
        }

        @DoFn.ProcessElement
        public void goodTypeVariables(DoFn.ProcessContext c) {
        }
    }

    static class BadTypeVariables<InputT, OutputT>
    extends DoFn<InputT, OutputT> {
        BadTypeVariables() {
        }

        @DoFn.ProcessElement
        public void badTypeVariables(DoFn.ProcessContext c) {
        }
    }
}

