/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.testhelper.DoFnInvokersTestHelper;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.AdditionalAnswers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class DoFnInvokersTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    private DoFn.StartBundleContext mockStartBundleContext;
    @Mock
    private DoFn.FinishBundleContext mockFinishBundleContext;
    @Mock
    private DoFn.ProcessContext mockProcessContext;
    private String mockElement;
    private Instant mockTimestamp;
    @Mock
    private DoFn.OutputReceiver<String> mockOutputReceiver;
    @Mock
    private DoFn.MultiOutputReceiver mockMultiOutputReceiver;
    @Mock
    private IntervalWindow mockWindow;
    @Mock
    private DoFnInvoker.ArgumentProvider<String, String> mockArgumentProvider;
    private static final String TIMER_ID = "test-timer-id";

    @Before
    public void setUp() {
        this.mockElement = new String("element");
        this.mockTimestamp = new Instant(0L);
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockArgumentProvider.window()).thenReturn((Object)this.mockWindow);
        Mockito.when((Object)((String)this.mockArgumentProvider.element((DoFn)Matchers.any()))).thenReturn((Object)this.mockElement);
        Mockito.when((Object)this.mockArgumentProvider.timestamp((DoFn)Matchers.any())).thenReturn((Object)this.mockTimestamp);
        Mockito.when((Object)this.mockArgumentProvider.outputReceiver((DoFn)Matchers.any())).thenReturn(this.mockOutputReceiver);
        Mockito.when((Object)this.mockArgumentProvider.taggedOutputReceiver((DoFn)Matchers.any())).thenReturn((Object)this.mockMultiOutputReceiver);
        Mockito.when((Object)this.mockArgumentProvider.startBundleContext((DoFn)Matchers.any())).thenReturn((Object)this.mockStartBundleContext);
        Mockito.when((Object)this.mockArgumentProvider.finishBundleContext((DoFn)Matchers.any())).thenReturn((Object)this.mockFinishBundleContext);
        Mockito.when((Object)this.mockArgumentProvider.processContext((DoFn)Matchers.any())).thenReturn((Object)this.mockProcessContext);
    }

    private DoFn.ProcessContinuation invokeProcessElement(DoFn<String, String> fn) {
        return DoFnInvokers.invokerFor(fn).invokeProcessElement(this.mockArgumentProvider);
    }

    private void invokeOnTimer(String timerId, DoFn<String, String> fn) {
        DoFnInvokers.invokerFor(fn).invokeOnTimer(timerId, this.mockArgumentProvider);
    }

    @Test
    public void testDoFnInvokersReused() throws Exception {
        IdentityParent fn1 = new IdentityParent();
        IdentityParent fn2 = new IdentityParent();
        Assert.assertSame((String)"Invoker classes should only be generated once for each type", DoFnInvokers.invokerFor((DoFn)fn1).getClass(), DoFnInvokers.invokerFor((DoFn)fn2).getClass());
    }

    @Test
    public void testDoFnWithNoExtraContext() throws Exception {
        class MockFn
        extends DoFn<String, String> {
            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
            }
        }
        MockFn mockFn = (MockFn)((Object)Mockito.mock(MockFn.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(mockFn));
        ((MockFn)((Object)Mockito.verify((Object)((Object)mockFn)))).processElement(this.mockProcessContext);
    }

    @Test
    public void testDoFnWithProcessElementInterface() throws Exception {
        IdentityUsingInterfaceWithProcessElement fn = (IdentityUsingInterfaceWithProcessElement)Mockito.mock(IdentityUsingInterfaceWithProcessElement.class);
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((IdentityUsingInterfaceWithProcessElement)Mockito.verify((Object)fn)).processElement(this.mockProcessContext);
    }

    @Test
    public void testDoFnWithMethodInSuperclass() throws Exception {
        IdentityChildWithoutOverride fn = (IdentityChildWithoutOverride)((Object)Mockito.mock(IdentityChildWithoutOverride.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((IdentityChildWithoutOverride)((Object)Mockito.verify((Object)((Object)fn)))).process(this.mockProcessContext);
    }

    @Test
    public void testDoFnWithMethodInSubclass() throws Exception {
        IdentityChildWithOverride fn = (IdentityChildWithOverride)((Object)Mockito.mock(IdentityChildWithOverride.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((IdentityChildWithOverride)((Object)Mockito.verify((Object)((Object)fn)))).process(this.mockProcessContext);
    }

    @Test
    public void testDoFnWithWindow() throws Exception {
        class MockFn
        extends DoFn<String, String> {
            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, IntervalWindow w) throws Exception {
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).processElement(this.mockProcessContext, this.mockWindow);
    }

    @Test
    public void testDoFnWithAllParameters() throws Exception {
        class MockFn
        extends DoFn<String, String> {
            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, @DoFn.Element String element, @DoFn.Timestamp Instant timestamp, IntervalWindow w, DoFn.OutputReceiver<String> receiver, DoFn.MultiOutputReceiver multiReceiver) throws Exception {
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).processElement(this.mockProcessContext, this.mockElement, this.mockTimestamp, this.mockWindow, this.mockOutputReceiver, this.mockMultiOutputReceiver);
    }

    @Test
    public void testDoFnWithState() throws Exception {
        ValueState mockState = (ValueState)Mockito.mock(ValueState.class);
        String stateId = "my-state-id-here";
        Mockito.when((Object)this.mockArgumentProvider.state("my-state-id-here")).thenReturn((Object)mockState);
        class MockFn
        extends DoFn<String, String> {
            @DoFn.StateId(value="my-state-id-here")
            private final StateSpec<ValueState<Integer>> spec = StateSpecs.value((Coder)VarIntCoder.of());

            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, @DoFn.StateId(value="my-state-id-here") ValueState<Integer> valueState) throws Exception {
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).processElement(this.mockProcessContext, (ValueState<Integer>)mockState);
    }

    @Test
    public void testDoFnWithTimer() throws Exception {
        Timer mockTimer = (Timer)Mockito.mock(Timer.class);
        String timerId = "my-timer-id-here";
        Mockito.when((Object)this.mockArgumentProvider.timer("my-timer-id-here")).thenReturn((Object)mockTimer);
        class MockFn
        extends DoFn<String, String> {
            @DoFn.TimerId(value="my-timer-id-here")
            private final TimerSpec spec = TimerSpecs.timer((TimeDomain)TimeDomain.EVENT_TIME);

            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, @DoFn.TimerId(value="my-timer-id-here") Timer timer) throws Exception {
            }

            @DoFn.OnTimer(value="my-timer-id-here")
            public void onTimer() {
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).processElement(this.mockProcessContext, mockTimer);
    }

    @Test
    public void testDoFnWithReturn() throws Exception {
        class MockFn
        extends DoFn<String, String> {
            MockFn() {
            }

            @DoFn.ProcessElement
            public DoFn.ProcessContinuation processElement(DoFn.ProcessContext c, SomeRestrictionTracker tracker) throws Exception {
                return null;
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(String element) {
                return null;
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        Mockito.when((Object)fn.processElement(this.mockProcessContext, null)).thenReturn((Object)DoFn.ProcessContinuation.resume());
        Assert.assertEquals((Object)DoFn.ProcessContinuation.resume(), (Object)this.invokeProcessElement(fn));
    }

    @Test
    public void testDoFnWithStartBundleSetupTeardown() throws Exception {
        class MockFn
        extends DoFn<String, String> {
            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext c) {
            }

            @DoFn.FinishBundle
            public void finishBundle(DoFn.FinishBundleContext c) {
            }

            @DoFn.Setup
            public void before() {
            }

            @DoFn.Teardown
            public void after() {
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)fn);
        invoker.invokeSetup();
        invoker.invokeStartBundle(this.mockStartBundleContext);
        invoker.invokeFinishBundle(this.mockFinishBundleContext);
        invoker.invokeTeardown();
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).before();
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).startBundle(this.mockStartBundleContext);
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).finishBundle(this.mockFinishBundleContext);
        ((MockFn)((Object)Mockito.verify((Object)((Object)fn)))).after();
    }

    @Test
    public void testSplittableDoFnWithAllMethods() throws Exception {
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)fn);
        final SomeRestrictionTracker tracker = (SomeRestrictionTracker)((Object)Mockito.mock(SomeRestrictionTracker.class));
        SomeRestrictionCoder coder = (SomeRestrictionCoder)((Object)Mockito.mock(SomeRestrictionCoder.class));
        SomeRestriction restriction = new SomeRestriction();
        final SomeRestriction part1 = new SomeRestriction();
        final SomeRestriction part2 = new SomeRestriction();
        final SomeRestriction part3 = new SomeRestriction();
        Mockito.when((Object)((Object)fn.getRestrictionCoder())).thenReturn((Object)coder);
        Mockito.when((Object)fn.getInitialRestriction("blah")).thenReturn((Object)restriction);
        ((MockFn)((Object)Mockito.doAnswer((Answer)AdditionalAnswers.delegatesTo((Object)((Object)new MockFn(){

            @Override
            @DoFn.SplitRestriction
            public void splitRestriction(String element, SomeRestriction restriction, DoFn.OutputReceiver<SomeRestriction> receiver) {
                receiver.output((Object)part1);
                receiver.output((Object)part2);
                receiver.output((Object)part3);
            }
        }))).when((Object)fn))).splitRestriction((String)Matchers.eq((Object)"blah"), (SomeRestriction)Matchers.same((Object)restriction), (DoFn.OutputReceiver<SomeRestriction>)((DoFn.OutputReceiver)Mockito.any()));
        Mockito.when((Object)((Object)fn.newTracker(restriction))).thenReturn((Object)tracker);
        Mockito.when((Object)fn.processElement(this.mockProcessContext, tracker)).thenReturn((Object)DoFn.ProcessContinuation.resume());
        Assert.assertEquals((Object)((Object)coder), (Object)invoker.invokeGetRestrictionCoder(CoderRegistry.createDefault()));
        Assert.assertEquals((Object)restriction, (Object)invoker.invokeGetInitialRestriction((Object)"blah"));
        final ArrayList outputs = new ArrayList();
        invoker.invokeSplitRestriction((Object)"blah", (Object)restriction, (DoFn.OutputReceiver)new DoFn.OutputReceiver<SomeRestriction>(){

            public void output(SomeRestriction output) {
                outputs.add(output);
            }

            public void outputWithTimestamp(SomeRestriction output, Instant timestamp) {
                outputs.add(output);
            }
        });
        Assert.assertEquals(Arrays.asList(part1, part2, part3), outputs);
        Assert.assertEquals((Object)((Object)tracker), (Object)invoker.invokeNewTracker((Object)restriction));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.resume(), (Object)invoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)new DoFnInvoker.FakeArgumentProvider<String, String>(){

            public DoFn.ProcessContext processContext(DoFn<String, String> fn) {
                return DoFnInvokersTest.this.mockProcessContext;
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return tracker;
            }
        }));
    }

    @Test
    public void testSplittableDoFnDefaultMethods() throws Exception {
        class MockFn
        extends DoFn<String, String> {
            MockFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, DefaultTracker tracker) {
            }

            @DoFn.GetInitialRestriction
            public RestrictionWithDefaultTracker getInitialRestriction(String element) {
                return null;
            }
        }
        MockFn fn = (MockFn)((Object)Mockito.mock(MockFn.class));
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)fn);
        CoderRegistry coderRegistry = CoderRegistry.createDefault();
        coderRegistry.registerCoderProvider(CoderProviders.fromStaticMethods(RestrictionWithDefaultTracker.class, CoderForDefaultTracker.class));
        Assert.assertThat((Object)invoker.invokeGetRestrictionCoder(coderRegistry), (Matcher)CoreMatchers.instanceOf(CoderForDefaultTracker.class));
        invoker.invokeSplitRestriction((Object)"blah", (Object)"foo", (DoFn.OutputReceiver)new DoFn.OutputReceiver<String>(){
            private boolean invoked;

            public void output(String output) {
                Assert.assertFalse((boolean)this.invoked);
                this.invoked = true;
                Assert.assertEquals((Object)"foo", (Object)output);
            }

            public void outputWithTimestamp(String output, Instant instant) {
                Assert.assertFalse((boolean)this.invoked);
                this.invoked = true;
                Assert.assertEquals((Object)"foo", (Object)output);
            }
        });
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)invoker.invokeProcessElement(this.mockArgumentProvider));
        Assert.assertThat((Object)invoker.invokeNewTracker((Object)new RestrictionWithDefaultTracker()), (Matcher)CoreMatchers.instanceOf(DefaultTracker.class));
    }

    @Test
    public void testLocalPrivateDoFnWithTimers() throws Exception {
        PrivateDoFnWithTimers fn = (PrivateDoFnWithTimers)((Object)Mockito.mock(PrivateDoFnWithTimers.class));
        this.invokeOnTimer(TIMER_ID, fn);
        ((PrivateDoFnWithTimers)((Object)Mockito.verify((Object)((Object)fn)))).onTimer((BoundedWindow)this.mockWindow);
    }

    @Test
    public void testStaticPackagePrivateDoFnWithTimers() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(DoFnInvokersTestHelper.newStaticPackagePrivateDoFnWithTimers().getClass());
        this.invokeOnTimer(TIMER_ID, (DoFn<String, String>)fn);
        DoFnInvokersTestHelper.verifyStaticPackagePrivateDoFnWithTimers((DoFn<String, String>)fn, (BoundedWindow)this.mockWindow);
    }

    @Test
    public void testInnerPackagePrivateDoFnWithTimers() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(new DoFnInvokersTestHelper().newInnerPackagePrivateDoFnWithTimers().getClass());
        this.invokeOnTimer(TIMER_ID, (DoFn<String, String>)fn);
        DoFnInvokersTestHelper.verifyInnerPackagePrivateDoFnWithTimers((DoFn<String, String>)fn, (BoundedWindow)this.mockWindow);
    }

    @Test
    public void testStaticPrivateDoFnWithTimers() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(DoFnInvokersTestHelper.newStaticPrivateDoFnWithTimers().getClass());
        this.invokeOnTimer(TIMER_ID, (DoFn<String, String>)fn);
        DoFnInvokersTestHelper.verifyStaticPrivateDoFnWithTimers((DoFn<String, String>)fn, (BoundedWindow)this.mockWindow);
    }

    @Test
    public void testInnerPrivateDoFnWithTimers() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(new DoFnInvokersTestHelper().newInnerPrivateDoFnWithTimers().getClass());
        this.invokeOnTimer(TIMER_ID, (DoFn<String, String>)fn);
        DoFnInvokersTestHelper.verifyInnerPrivateDoFnWithTimers((DoFn<String, String>)fn, (BoundedWindow)this.mockWindow);
    }

    @Test
    public void testAnonymousInnerDoFnWithTimers() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(new DoFnInvokersTestHelper().newInnerAnonymousDoFnWithTimers().getClass());
        this.invokeOnTimer(TIMER_ID, (DoFn<String, String>)fn);
        DoFnInvokersTestHelper.verifyInnerAnonymousDoFnWithTimers((DoFn<String, String>)fn, (BoundedWindow)this.mockWindow);
    }

    @Test
    public void testStaticAnonymousDoFnWithTimersInOtherPackage() throws Exception {
        DoFn<String, String> fn = DoFnInvokersTestHelper.newStaticAnonymousDoFnWithTimers();
        this.invokeOnTimer(TIMER_ID, fn);
        DoFnInvokersTestHelper.verifyStaticAnonymousDoFnWithTimersInvoked(fn, (BoundedWindow)this.mockWindow);
    }

    @Test
    public void testLocalPrivateDoFnClass() throws Exception {
        PrivateDoFnClass fn = (PrivateDoFnClass)((Object)Mockito.mock(PrivateDoFnClass.class));
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement(fn));
        ((PrivateDoFnClass)((Object)Mockito.verify((Object)((Object)fn)))).processThis(this.mockProcessContext);
    }

    @Test
    public void testStaticPackagePrivateDoFnClass() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(DoFnInvokersTestHelper.newStaticPackagePrivateDoFn().getClass());
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement((DoFn<String, String>)fn));
        DoFnInvokersTestHelper.verifyStaticPackagePrivateDoFn((DoFn<String, String>)fn, this.mockProcessContext);
    }

    @Test
    public void testInnerPackagePrivateDoFnClass() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(new DoFnInvokersTestHelper().newInnerPackagePrivateDoFn().getClass());
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement((DoFn<String, String>)fn));
        DoFnInvokersTestHelper.verifyInnerPackagePrivateDoFn((DoFn<String, String>)fn, this.mockProcessContext);
    }

    @Test
    public void testStaticPrivateDoFnClass() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(DoFnInvokersTestHelper.newStaticPrivateDoFn().getClass());
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement((DoFn<String, String>)fn));
        DoFnInvokersTestHelper.verifyStaticPrivateDoFn((DoFn<String, String>)fn, this.mockProcessContext);
    }

    @Test
    public void testInnerPrivateDoFnClass() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(new DoFnInvokersTestHelper().newInnerPrivateDoFn().getClass());
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement((DoFn<String, String>)fn));
        DoFnInvokersTestHelper.verifyInnerPrivateDoFn((DoFn<String, String>)fn, this.mockProcessContext);
    }

    @Test
    public void testAnonymousInnerDoFn() throws Exception {
        DoFn fn = (DoFn)Mockito.mock(new DoFnInvokersTestHelper().newInnerAnonymousDoFn().getClass());
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)this.invokeProcessElement((DoFn<String, String>)fn));
        DoFnInvokersTestHelper.verifyInnerAnonymousDoFn((DoFn<String, String>)fn, this.mockProcessContext);
    }

    @Test
    public void testStaticAnonymousDoFnInOtherPackage() throws Exception {
        DoFn<String, String> fn = DoFnInvokersTestHelper.newStaticAnonymousDoFn();
        this.invokeProcessElement(fn);
        DoFnInvokersTestHelper.verifyStaticAnonymousDoFnInvoked(fn, this.mockProcessContext);
    }

    @Test
    public void testProcessElementException() throws Exception {
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                throw new IllegalArgumentException("bogus");
            }
        });
        this.thrown.expect(UserCodeException.class);
        this.thrown.expectMessage("bogus");
        invoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)new DoFnInvoker.FakeArgumentProvider<Integer, Integer>(){

            public DoFn.ProcessContext processContext(DoFn<Integer, Integer> fn) {
                return null;
            }
        });
    }

    @Test
    public void testProcessElementExceptionWithReturn() throws Exception {
        this.thrown.expect(UserCodeException.class);
        this.thrown.expectMessage("bogus");
        DoFnInvokers.invokerFor((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public DoFn.ProcessContinuation processElement(DoFn.ProcessContext c, SomeRestrictionTracker tracker) {
                throw new IllegalArgumentException("bogus");
            }

            @DoFn.GetInitialRestriction
            public SomeRestriction getInitialRestriction(Integer element) {
                return null;
            }

            @DoFn.NewTracker
            public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
                return null;
            }
        }).invokeProcessElement((DoFnInvoker.ArgumentProvider)new DoFnInvoker.FakeArgumentProvider<Integer, Integer>(){

            public DoFn.ProcessContext processContext(DoFn<Integer, Integer> doFn) {
                return null;
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return null;
            }
        });
    }

    @Test
    public void testStartBundleException() throws Exception {
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext c) {
                throw new IllegalArgumentException("bogus");
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
            }
        });
        this.thrown.expect(UserCodeException.class);
        this.thrown.expectMessage("bogus");
        invoker.invokeStartBundle(null);
    }

    @Test
    public void testFinishBundleException() throws Exception {
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.FinishBundle
            public void finishBundle(DoFn.FinishBundleContext c) {
                throw new IllegalArgumentException("bogus");
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
            }
        });
        this.thrown.expect(UserCodeException.class);
        this.thrown.expectMessage("bogus");
        invoker.invokeFinishBundle(null);
    }

    @Test
    public void testOnTimerHelloWord() throws Exception {
        String timerId = "my-timer-id";
        class SimpleTimerDoFn
        extends DoFn<String, String> {
            public String status = "not yet";
            @DoFn.TimerId(value="my-timer-id")
            private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

            SimpleTimerDoFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }

            @DoFn.OnTimer(value="my-timer-id")
            public void onMyTimer() {
                this.status = "OK now";
            }
        }
        SimpleTimerDoFn fn = new SimpleTimerDoFn();
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)fn);
        invoker.invokeOnTimer("my-timer-id", this.mockArgumentProvider);
        Assert.assertThat((Object)fn.status, (Matcher)org.hamcrest.Matchers.equalTo((Object)"OK now"));
    }

    @Test
    public void testOnTimerWithWindow() throws Exception {
        String timerId = "my-timer-id";
        IntervalWindow testWindow = new IntervalWindow(new Instant(0L), new Instant(15L));
        Mockito.when((Object)this.mockArgumentProvider.window()).thenReturn((Object)testWindow);
        class SimpleTimerDoFn
        extends DoFn<String, String> {
            public IntervalWindow window = null;
            @DoFn.TimerId(value="my-timer-id")
            private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

            SimpleTimerDoFn() {
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
            }

            @DoFn.OnTimer(value="my-timer-id")
            public void onMyTimer(IntervalWindow w) {
                this.window = w;
            }
        }
        SimpleTimerDoFn fn = new SimpleTimerDoFn();
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)fn);
        invoker.invokeOnTimer("my-timer-id", this.mockArgumentProvider);
        Assert.assertThat((Object)fn.window, (Matcher)org.hamcrest.Matchers.equalTo((Object)testWindow));
    }

    @Test
    public void testStableName() {
        DoFnInvoker invoker = DoFnInvokers.invokerFor((DoFn)new StableNameTestDoFn());
        Assert.assertThat((Object)invoker.getClass().getName(), (Matcher)org.hamcrest.Matchers.equalTo((Object)String.format("%s$%s", StableNameTestDoFn.class.getName(), DoFnInvoker.class.getSimpleName())));
    }

    static class StableNameTestDoFn
    extends DoFn<Void, Void> {
        StableNameTestDoFn() {
        }

        @DoFn.ProcessElement
        public void process() {
        }
    }

    private static class PrivateDoFnClass
    extends DoFn<String, String> {
        private PrivateDoFnClass() {
        }

        @DoFn.ProcessElement
        public void processThis(DoFn.ProcessContext c) {
        }
    }

    private static class PrivateDoFnWithTimers
    extends DoFn<String, String> {
        @DoFn.TimerId(value="test-timer-id")
        private final TimerSpec myTimer = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);

        private PrivateDoFnWithTimers() {
        }

        @DoFn.ProcessElement
        public void processThis(DoFn.ProcessContext c) {
        }

        @DoFn.OnTimer(value="test-timer-id")
        public void onTimer(BoundedWindow w) {
        }
    }

    private static class CoderForDefaultTracker
    extends AtomicCoder<RestrictionWithDefaultTracker> {
        private CoderForDefaultTracker() {
        }

        public static CoderForDefaultTracker of() {
            return new CoderForDefaultTracker();
        }

        public void encode(RestrictionWithDefaultTracker value, OutputStream outStream) {
        }

        public RestrictionWithDefaultTracker decode(InputStream inStream) {
            return null;
        }
    }

    private static class DefaultTracker
    extends RestrictionTracker<RestrictionWithDefaultTracker, Void> {
        private DefaultTracker() {
        }

        protected boolean tryClaimImpl(Void position) {
            throw new UnsupportedOperationException();
        }

        public RestrictionWithDefaultTracker currentRestriction() {
            throw new UnsupportedOperationException();
        }

        public RestrictionWithDefaultTracker checkpoint() {
            throw new UnsupportedOperationException();
        }

        public void checkDone() throws IllegalStateException {
        }
    }

    private static class RestrictionWithDefaultTracker
    implements HasDefaultTracker<RestrictionWithDefaultTracker, DefaultTracker> {
        private RestrictionWithDefaultTracker() {
        }

        public DefaultTracker newTracker() {
            return new DefaultTracker();
        }
    }

    public static class MockFn
    extends DoFn<String, String> {
        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(DoFn.ProcessContext c, SomeRestrictionTracker tracker) {
            return null;
        }

        @DoFn.GetInitialRestriction
        public SomeRestriction getInitialRestriction(String element) {
            return null;
        }

        @DoFn.SplitRestriction
        public void splitRestriction(String element, SomeRestriction restriction, DoFn.OutputReceiver<SomeRestriction> receiver) {
        }

        @DoFn.NewTracker
        public SomeRestrictionTracker newTracker(SomeRestriction restriction) {
            return null;
        }

        @DoFn.GetRestrictionCoder
        public SomeRestrictionCoder getRestrictionCoder() {
            return null;
        }
    }

    private static class SomeRestrictionCoder
    extends AtomicCoder<SomeRestriction> {
        private SomeRestrictionCoder() {
        }

        public static SomeRestrictionCoder of() {
            return new SomeRestrictionCoder();
        }

        public void encode(SomeRestriction value, OutputStream outStream) {
        }

        public SomeRestriction decode(InputStream inStream) {
            return null;
        }
    }

    private static abstract class SomeRestrictionTracker
    extends RestrictionTracker<SomeRestriction, Void> {
        private SomeRestrictionTracker() {
        }
    }

    private static class SomeRestriction {
        private SomeRestriction() {
        }
    }

    private class IdentityChildWithOverride
    extends IdentityParent {
        private IdentityChildWithOverride() {
        }

        @Override
        public void process(DoFn.ProcessContext c) {
            super.process(c);
        }
    }

    private class IdentityChildWithoutOverride
    extends IdentityParent {
        private IdentityChildWithoutOverride() {
        }
    }

    private static class IdentityParent
    extends DoFn<String, String> {
        private IdentityParent() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
        }
    }

    private static class IdentityUsingInterfaceWithProcessElement
    extends DoFn<String, String>
    implements LayersOfInterfaces {
        private IdentityUsingInterfaceWithProcessElement() {
        }

        @Override
        public void processElement(DoFn.ProcessContext c) {
        }
    }

    static interface LayersOfInterfaces
    extends InterfaceWithProcessElement {
    }

    static interface InterfaceWithProcessElement {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext var1);
    }
}

