/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.util.ArrayList;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.util.common.Reiterable;
import org.apache.beam.sdk.util.common.Reiterator;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoGbkResultTest {
    @Test
    public void testLazyResults() {
        this.runLazyResult(0);
        this.runLazyResult(1);
        this.runLazyResult(3);
        this.runLazyResult(10);
    }

    public void runLazyResult(int cacheSize) {
        int valueLen = 7;
        TestUnionValues values = new TestUnionValues(0, 1, 0, 3, 0, 3, 3);
        CoGbkResult result = new CoGbkResult(this.createSchema(5), (Iterable)((Object)values), cacheSize);
        Assert.assertThat((Object)values.maxPos(), (Matcher)Matchers.equalTo((Object)Math.min(cacheSize, valueLen)));
        Assert.assertThat((Object)result.getAll(new TupleTag("tag0")), (Matcher)Matchers.contains((Object[])new Integer[]{0, 2, 4}));
        Assert.assertThat((Object)values.maxPos(), (Matcher)Matchers.equalTo((Object)valueLen));
        Assert.assertThat((Object)result.getAll(new TupleTag("tag3")), (Matcher)Matchers.contains((Object[])new Integer[]{3, 5, 6}));
        Assert.assertThat((Object)result.getAll(new TupleTag("tag2")), (Matcher)Matchers.emptyIterable());
        Assert.assertThat((Object)((Integer)result.getOnly(new TupleTag("tag1"))), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)result.getAll(new TupleTag("tag0")), (Matcher)Matchers.contains((Object[])new Integer[]{0, 2, 4}));
    }

    private CoGbkResultSchema createSchema(int size) {
        ArrayList<TupleTag> tags = new ArrayList<TupleTag>();
        for (int i = 0; i < size; ++i) {
            tags.add(new TupleTag("tag" + i));
        }
        return new CoGbkResultSchema(TupleTagList.of(tags));
    }

    private static class TestUnionValues
    implements Reiterable<RawUnionValue> {
        final int[] tags;
        int maxPos = 0;

        public TestUnionValues(int ... tags) {
            this.tags = tags;
        }

        public int maxPos() {
            return this.maxPos;
        }

        public Reiterator<RawUnionValue> iterator() {
            return this.iterator(0);
        }

        public Reiterator<RawUnionValue> iterator(final int start) {
            return new Reiterator<RawUnionValue>(){
                int pos;
                {
                    this.pos = start;
                }

                public boolean hasNext() {
                    return this.pos < tags.length;
                }

                public RawUnionValue next() {
                    maxPos = Math.max(this.pos + 1, maxPos);
                    return new RawUnionValue(tags[this.pos], (Object)this.pos++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Reiterator<RawUnionValue> copy() {
                    return this.iterator(this.pos);
                }
            };
        }
    }
}

