/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoGbkResultCoderTest {
    private static final CoGbkResultSchema TEST_SCHEMA = new CoGbkResultSchema(TupleTagList.of((TupleTag)new TupleTag()).and(new TupleTag()));
    private static final UnionCoder TEST_UNION_CODER = UnionCoder.of(ImmutableList.of(StringUtf8Coder.of(), VarIntCoder.of()));
    private static final UnionCoder COMPATIBLE_UNION_CODER = UnionCoder.of(ImmutableList.of(StringUtf8Coder.of(), BigEndianIntegerCoder.of()));
    private static final CoGbkResultSchema INCOMPATIBLE_SCHEMA = new CoGbkResultSchema(TupleTagList.of((TupleTag)new TupleTag()).and(new TupleTag()));
    private static final UnionCoder INCOMPATIBLE_UNION_CODER = UnionCoder.of(ImmutableList.of(StringUtf8Coder.of(), DoubleCoder.of()));
    private static final CoGbkResult.CoGbkResultCoder TEST_CODER = CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)TEST_SCHEMA, (UnionCoder)TEST_UNION_CODER);
    private static final CoGbkResult.CoGbkResultCoder COMPATIBLE_TEST_CODER = CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)TEST_SCHEMA, (UnionCoder)COMPATIBLE_UNION_CODER);
    private static final CoGbkResult.CoGbkResultCoder INCOMPATIBLE_TEST_CODER = CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)INCOMPATIBLE_SCHEMA, (UnionCoder)INCOMPATIBLE_UNION_CODER);

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)TEST_CODER.equals(new Object()));
        Assert.assertFalse((boolean)TEST_CODER.equals((Object)COMPATIBLE_TEST_CODER));
        Assert.assertFalse((boolean)TEST_CODER.equals((Object)INCOMPATIBLE_TEST_CODER));
    }

    @Test
    public void testCoderIsSerialiable() {
        CoderProperties.coderSerializable((Coder)TEST_CODER);
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)CoGbkResultSchema.of(ImmutableList.of(new TupleTag())), (UnionCoder)UnionCoder.of(ImmutableList.of(GlobalWindow.Coder.INSTANCE))));
    }
}

