/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import com.google.common.testing.EqualsTester;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMultimap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayDataTest_Foo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DisplayDataTest
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private static final DateTimeFormatter ISO_FORMATTER = ISODateTimeFormat.dateTime();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testTypicalUsage() {
        final HasDisplayData subComponent1 = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"ExpectedAnswer", (Integer)42));
            }
        };
        final HasDisplayData subComponent2 = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"Location", (String)"Seattle")).add(DisplayData.item((String)"Forecast", (String)"Rain"));
            }
        };
        PTransform<PCollection<String>, PCollection<String>> transform = new PTransform<PCollection<String>, PCollection<String>>(){
            final Instant defaultStartTime;
            Instant startTime;
            {
                this.startTime = this.defaultStartTime = new Instant(0L);
            }

            public PCollection<String> expand(PCollection<String> begin) {
                throw new IllegalArgumentException("Should never be applied");
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p1", subComponent1).include("p2", subComponent2).add(DisplayData.item((String)"minSproggles", (Integer)200).withLabel("Minimum Required Sproggles")).add(DisplayData.item((String)"fireLasers", (Boolean)true)).addIfNotDefault(DisplayData.item((String)"startTime", (Instant)this.startTime), (Object)this.defaultStartTime).add(DisplayData.item((String)"timeBomb", (Instant)Instant.now().plus((ReadableDuration)Duration.standardDays((long)1L)))).add(DisplayData.item((String)"filterLogic", subComponent1.getClass())).add(DisplayData.item((String)"serviceUrl", (String)"google.com/fizzbang").withLinkUrl("http://www.google.com/fizzbang"));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)transform);
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.empty()));
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.everyItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey((org.hamcrest.Matcher<String>)Matchers.not((org.hamcrest.Matcher)Matchers.isEmptyOrNullString())), DisplayDataMatchers.hasNamespace(Matchers.isOneOf((Object[])new Class[]{transform.getClass(), subComponent1.getClass(), subComponent2.getClass()})), DisplayDataMatchers.hasType((org.hamcrest.Matcher<DisplayData.Type>)Matchers.notNullValue(DisplayData.Type.class)), DisplayDataMatchers.hasValue(Matchers.not((org.hamcrest.Matcher)Matchers.isEmptyOrNullString())))));
    }

    @Test
    public void testDefaultInstance() {
        DisplayData none = DisplayData.none();
        Assert.assertThat((Object)none.items(), (org.hamcrest.Matcher)Matchers.empty());
    }

    @Test
    public void testCanBuildDisplayData() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", "bar"));
    }

    @Test
    public void testStaticValueProviderDate() {
        final Instant value = Instant.now();
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)value)));
            }
        });
        DisplayData.Item item = (DisplayData.Item)data.items().toArray()[0];
        org.hamcrest.Matcher matchesAllOf = Matchers.allOf(DisplayDataMatchers.hasKey("foo"), DisplayDataMatchers.hasType(DisplayData.Type.TIMESTAMP), DisplayDataMatchers.hasValue(ISO_FORMATTER.print((ReadableInstant)value)));
        Assert.assertThat((Object)item, (org.hamcrest.Matcher)matchesAllOf);
    }

    @Test
    public void testStaticValueProviderString() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"bar")));
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", "bar"));
    }

    @Test
    public void testStaticValueProviderInt() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)1)));
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", 1L));
    }

    @Test
    public void testInaccessibleValueProvider() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (ValueProvider)new ValueProvider<String>(){

                    public boolean isAccessible() {
                        return false;
                    }

                    public String get() {
                        return "bar";
                    }

                    public String toString() {
                        return "toString";
                    }
                }));
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", "toString"));
    }

    @Test
    public void testAsMap() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        });
        Map map = data.asMap();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("foo", "bar"));
        Assert.assertEquals(map.values(), (Object)data.items());
    }

    @Test
    public void testItemProperties() {
        final Instant value = Instant.now();
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"now", (Instant)value).withLabel("the current instant").withLinkUrl("http://time.gov").withNamespace(DisplayDataTest.class));
            }
        });
        DisplayData.Item item = (DisplayData.Item)data.items().toArray()[0];
        org.hamcrest.Matcher matchesAllOf = Matchers.allOf((org.hamcrest.Matcher[])new org.hamcrest.Matcher[]{DisplayDataMatchers.hasNamespace(DisplayDataTest.class), DisplayDataMatchers.hasKey("now"), DisplayDataMatchers.hasType(DisplayData.Type.TIMESTAMP), DisplayDataMatchers.hasValue(ISO_FORMATTER.print((ReadableInstant)value)), DisplayDataTest.hasShortValue(Matchers.nullValue(String.class)), DisplayDataMatchers.hasLabel("the current instant"), DisplayDataTest.hasUrl((org.hamcrest.Matcher<String>)Matchers.is((Object)"http://time.gov"))});
        Assert.assertThat((Object)item, (org.hamcrest.Matcher)matchesAllOf);
    }

    @Test
    public void testUnspecifiedOptionalProperties() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        });
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem((org.hamcrest.Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasLabel((org.hamcrest.Matcher<String>)Matchers.nullValue(String.class)), DisplayDataTest.hasUrl((org.hamcrest.Matcher<String>)Matchers.nullValue(String.class)))));
    }

    @Test
    public void testAddIfNotDefault() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.addIfNotDefault(DisplayData.item((String)"defaultString", (String)"foo"), (Object)"foo").addIfNotDefault(DisplayData.item((String)"notDefaultString", (String)"foo"), (Object)"notFoo").addIfNotDefault(DisplayData.item((String)"defaultInteger", (Integer)1), (Object)1).addIfNotDefault(DisplayData.item((String)"notDefaultInteger", (Integer)1), (Object)2).addIfNotDefault(DisplayData.item((String)"defaultDouble", (Double)123.4), (Object)123.4).addIfNotDefault(DisplayData.item((String)"notDefaultDouble", (Double)123.4), (Object)234.5).addIfNotDefault(DisplayData.item((String)"defaultBoolean", (Boolean)true), (Object)true).addIfNotDefault(DisplayData.item((String)"notDefaultBoolean", (Boolean)true), (Object)false).addIfNotDefault(DisplayData.item((String)"defaultInstant", (Instant)new Instant(0L)), (Object)new Instant(0L)).addIfNotDefault(DisplayData.item((String)"notDefaultInstant", (Instant)new Instant(0L)), (Object)Instant.now()).addIfNotDefault(DisplayData.item((String)"defaultDuration", (Duration)Duration.ZERO), (Object)Duration.ZERO).addIfNotDefault(DisplayData.item((String)"notDefaultDuration", (Duration)Duration.millis((long)1234L)), (Object)Duration.ZERO).addIfNotDefault(DisplayData.item((String)"defaultClass", DisplayDataTest.class), DisplayDataTest.class).addIfNotDefault(DisplayData.item((String)"notDefaultClass", DisplayDataTest.class), null);
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)7));
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.everyItem(DisplayDataMatchers.hasKey((org.hamcrest.Matcher<String>)Matchers.startsWith((String)"notDefault"))));
    }

    @Test
    public void testInterpolatedTypeDefaults() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.addIfNotDefault(DisplayData.item((String)"integer", (Integer)123), (Object)123).addIfNotDefault(DisplayData.item((String)"Integer", (Integer)123), (Object)123).addIfNotDefault(DisplayData.item((String)"long", (Long)123L), (Object)123L).addIfNotDefault(DisplayData.item((String)"Long", (Long)123L), (Object)123L).addIfNotDefault(DisplayData.item((String)"float", (Float)Float.valueOf(1.23f)), (Object)Float.valueOf(1.23f)).addIfNotDefault(DisplayData.item((String)"Float", (Float)Float.valueOf(1.23f)), (Object)Float.valueOf(1.23f)).addIfNotDefault(DisplayData.item((String)"double", (Double)1.23), (Object)1.23).addIfNotDefault(DisplayData.item((String)"Double", (Double)1.23), (Object)1.23).addIfNotDefault(DisplayData.item((String)"boolean", (Boolean)true), (Object)true).addIfNotDefault(DisplayData.item((String)"Boolean", (Boolean)Boolean.TRUE), (Object)Boolean.TRUE);
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.empty());
    }

    @Test
    public void testAddIfNotNull() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.addIfNotNull(DisplayData.item((String)"nullString", (String)null)).addIfNotNull(DisplayData.item((String)"nullVPString", (ValueProvider)null)).addIfNotNull(DisplayData.item((String)"nullierVPString", (ValueProvider)ValueProvider.StaticValueProvider.of(null))).addIfNotNull(DisplayData.item((String)"notNullString", (String)"foo")).addIfNotNull(DisplayData.item((String)"nullLong", (Long)null)).addIfNotNull(DisplayData.item((String)"notNullLong", (Long)1234L)).addIfNotNull(DisplayData.item((String)"nullDouble", (Double)null)).addIfNotNull(DisplayData.item((String)"notNullDouble", (Double)123.4)).addIfNotNull(DisplayData.item((String)"nullBoolean", (Boolean)null)).addIfNotNull(DisplayData.item((String)"notNullBoolean", (Boolean)true)).addIfNotNull(DisplayData.item((String)"nullInstant", (Instant)null)).addIfNotNull(DisplayData.item((String)"notNullInstant", (Instant)Instant.now())).addIfNotNull(DisplayData.item((String)"nullDuration", (Duration)null)).addIfNotNull(DisplayData.item((String)"notNullDuration", (Duration)Duration.ZERO)).addIfNotNull(DisplayData.item((String)"nullClass", (Class)null)).addIfNotNull(DisplayData.item((String)"notNullClass", DisplayDataTest.class));
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)7));
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.everyItem(DisplayDataMatchers.hasKey((org.hamcrest.Matcher<String>)Matchers.startsWith((String)"notNull"))));
    }

    @Test
    public void testModifyingConditionalItemIsSafe() {
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.addIfNotNull(DisplayData.item((String)"nullItem", (Class)null).withLinkUrl("http://abc").withNamespace(DisplayDataTest.class).withLabel("Null item should be safe"));
            }
        };
        DisplayData.from((HasDisplayData)component);
    }

    @Test
    public void testRootPath() {
        DisplayData.Path root = DisplayData.Path.root();
        Assert.assertThat((Object)root.getComponents(), (org.hamcrest.Matcher)Matchers.empty());
    }

    @Test
    public void testExtendPath() {
        DisplayData.Path a = DisplayData.Path.root().extend("a");
        Assert.assertThat((Object)a.getComponents(), (org.hamcrest.Matcher)Matchers.hasItems((Object[])new String[]{"a"}));
        DisplayData.Path b = a.extend("b");
        Assert.assertThat((Object)b.getComponents(), (org.hamcrest.Matcher)Matchers.hasItems((Object[])new String[]{"a", "b"}));
    }

    @Test
    public void testExtendNullPathValidation() {
        DisplayData.Path root = DisplayData.Path.root();
        this.thrown.expect(NullPointerException.class);
        root.extend(null);
    }

    @Test
    public void testExtendEmptyPathValidation() {
        DisplayData.Path root = DisplayData.Path.root();
        this.thrown.expect(IllegalArgumentException.class);
        root.extend("");
    }

    @Test
    public void testAbsolute() {
        DisplayData.Path path = DisplayData.Path.absolute((String)"a", (String[])new String[]{"b", "c"});
        Assert.assertThat((Object)path.getComponents(), (org.hamcrest.Matcher)Matchers.hasItems((Object[])new String[]{"a", "b", "c"}));
    }

    @Test
    public void testAbsoluteValidationNullFirstPath() {
        this.thrown.expect(NullPointerException.class);
        DisplayData.Path.absolute(null, (String[])new String[]{"foo", "bar"});
    }

    @Test
    public void testAbsoluteValidationEmptyFirstPath() {
        this.thrown.expect(IllegalArgumentException.class);
        DisplayData.Path.absolute((String)"", (String[])new String[]{"foo", "bar"});
    }

    @Test
    public void testAbsoluteValidationNullSubsequentPath() {
        this.thrown.expect(NullPointerException.class);
        DisplayData.Path.absolute((String)"a", (String[])new String[]{"b", null, "c"});
    }

    @Test
    public void testAbsoluteValidationEmptySubsequentPath() {
        this.thrown.expect(IllegalArgumentException.class);
        DisplayData.Path.absolute((String)"a", (String[])new String[]{"b", "", "c"});
    }

    @Test
    public void testPathToString() {
        Assert.assertEquals((String)"root string", (Object)"[]", (Object)DisplayData.Path.root().toString());
        Assert.assertEquals((String)"single component", (Object)"[a]", (Object)DisplayData.Path.absolute((String)"a", (String[])new String[0]).toString());
        Assert.assertEquals((String)"hierarchy", (Object)"[a/b/c]", (Object)DisplayData.Path.absolute((String)"a", (String[])new String[]{"b", "c"}).toString());
    }

    @Test
    public void testPathEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{DisplayData.Path.root(), DisplayData.Path.root()}).addEqualityGroup(new Object[]{DisplayData.Path.root().extend("a"), DisplayData.Path.absolute((String)"a", (String[])new String[0])}).addEqualityGroup(new Object[]{DisplayData.Path.root().extend("a").extend("b"), DisplayData.Path.absolute((String)"a", (String[])new String[]{"b"})}).testEquals();
    }

    @Test
    public void testIncludes() {
        final HasDisplayData subComponent = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p", subComponent);
            }
        });
        Assert.assertThat((Object)data, DisplayDataMatchers.includesDisplayDataFor("p", subComponent));
    }

    @Test
    public void testIncludeSameComponentAtDifferentPaths() {
        final HasDisplayData subComponent1 = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        final HasDisplayData subComponent2 = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo2", (String)"bar2"));
            }
        };
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p1", subComponent1).include("p2", subComponent2);
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)component);
        Assert.assertThat((Object)data, DisplayDataMatchers.includesDisplayDataFor("p1", subComponent1));
        Assert.assertThat((Object)data, DisplayDataMatchers.includesDisplayDataFor("p2", subComponent2));
    }

    @Test
    public void testIncludesComponentsAtSamePath() {
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p", (HasDisplayData)new NoopDisplayData()).include("p", (HasDisplayData)new NoopDisplayData());
            }
        };
        this.thrown.expectCause(Matchers.isA(IllegalArgumentException.class));
        DisplayData.from((HasDisplayData)component);
    }

    @Test
    public void testNullNamespaceOverride() {
        this.thrown.expectCause(Matchers.isA(NullPointerException.class));
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar").withNamespace(null));
            }
        });
    }

    @Test
    public void testIdentifierEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{DisplayData.Identifier.of((DisplayData.Path)DisplayData.Path.absolute((String)"a", (String[])new String[0]), DisplayDataTest.class, (String)"1"), DisplayData.Identifier.of((DisplayData.Path)DisplayData.Path.absolute((String)"a", (String[])new String[0]), DisplayDataTest.class, (String)"1")}).addEqualityGroup(new Object[]{DisplayData.Identifier.of((DisplayData.Path)DisplayData.Path.absolute((String)"b", (String[])new String[0]), DisplayDataTest.class, (String)"1")}).addEqualityGroup(new Object[]{DisplayData.Identifier.of((DisplayData.Path)DisplayData.Path.absolute((String)"a", (String[])new String[0]), Object.class, (String)"1")}).addEqualityGroup(new Object[]{DisplayData.Identifier.of((DisplayData.Path)DisplayData.Path.absolute((String)"a", (String[])new String[0]), DisplayDataTest.class, (String)"2")}).testEquals();
    }

    @Test
    public void testItemEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{DisplayData.item((String)"foo", (String)"bar"), DisplayData.item((String)"foo", (String)"bar")}).addEqualityGroup(new Object[]{DisplayData.item((String)"foo", (String)"barz")}).testEquals();
    }

    @Test
    public void testDisplayDataEquality() {
        HasDisplayData component1 = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        HasDisplayData component2 = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        DisplayData component1DisplayData1 = DisplayData.from((HasDisplayData)component1);
        DisplayData component1DisplayData2 = DisplayData.from((HasDisplayData)component1);
        DisplayData component2DisplayData = DisplayData.from((HasDisplayData)component2);
        new EqualsTester().addEqualityGroup(new Object[]{component1DisplayData1, component1DisplayData2}).addEqualityGroup(new Object[]{component2DisplayData}).testEquals();
    }

    @Test
    public void testAcceptsKeysWithDifferentNamespaces() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar")).include("p", new HasDisplayData(){

                    public void populateDisplayData(DisplayData.Builder builder) {
                        builder.add(DisplayData.item((String)"foo", (String)"bar"));
                    }
                });
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testDuplicateKeyThrowsException() {
        this.thrown.expectCause(Matchers.isA(IllegalArgumentException.class));
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar")).add(DisplayData.item((String)"foo", (String)"baz"));
            }
        });
    }

    @Test
    public void testDuplicateKeyWithNamespaceOverrideDoesntThrow() {
        DisplayData displayData = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar")).add(DisplayData.item((String)"foo", (String)"baz").withNamespace(DisplayDataTest.class));
            }
        });
        Assert.assertThat((Object)displayData.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testToString() {
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)component);
        Assert.assertEquals((Object)String.format("[]%s:foo=bar", component.getClass().getName()), (Object)data.toString());
    }

    @Test
    public void testHandlesIncludeCycles() {
        final IncludeSubComponent componentA = new IncludeSubComponent(){

            @Override
            String getId() {
                return "componentA";
            }
        };
        IncludeSubComponent componentB = new IncludeSubComponent(){

            @Override
            String getId() {
                return "componentB";
            }
        };
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p", (HasDisplayData)componentA);
            }
        };
        componentA.subComponent = componentB;
        componentB.subComponent = componentA;
        DisplayData data = DisplayData.from((HasDisplayData)component);
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testHandlesIncludeCyclesDifferentInstances() {
        DelegatingDisplayData component = new DelegatingDisplayData(new DelegatingDisplayData(new NoopDisplayData()));
        DisplayData data = DisplayData.from((HasDisplayData)component);
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testIncludesSubcomponentsWithObjectEquality() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p1", (HasDisplayData)new EqualsEverything("foo1", "bar1")).include("p2", (HasDisplayData)new EqualsEverything("foo2", "bar2"));
            }
        });
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testDelegate() {
        final HasDisplayData subcomponent = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"subCompKey", (String)"foo"));
            }
        };
        final HasDisplayData wrapped = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"wrappedKey", (String)"bar")).include("p", subcomponent);
            }
        };
        HasDisplayData wrapper = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.delegate(wrapped);
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)wrapper);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem((org.hamcrest.Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey("wrappedKey"), DisplayDataMatchers.hasNamespace(wrapped.getClass()), DisplayDataMatchers.hasPath(new String[0]))));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem((org.hamcrest.Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey("subCompKey"), DisplayDataMatchers.hasNamespace(subcomponent.getClass()), DisplayDataMatchers.hasPath("p"))));
    }

    @Test
    public void testTypeMappings() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"string", (String)"foobar")).add(DisplayData.item((String)"integer", (Integer)123)).add(DisplayData.item((String)"float", (Double)2.34)).add(DisplayData.item((String)"boolean", (Boolean)true)).add(DisplayData.item((String)"java_class", DisplayDataTest.class)).add(DisplayData.item((String)"timestamp", (Instant)Instant.now())).add(DisplayData.item((String)"duration", (Duration)Duration.standardHours((long)1L)));
            }
        });
        Collection items = data.items();
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("string"), DisplayDataMatchers.hasType(DisplayData.Type.STRING))));
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("integer"), DisplayDataMatchers.hasType(DisplayData.Type.INTEGER))));
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("float"), DisplayDataMatchers.hasType(DisplayData.Type.FLOAT))));
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("boolean"), DisplayDataMatchers.hasType(DisplayData.Type.BOOLEAN))));
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("java_class"), DisplayDataMatchers.hasType(DisplayData.Type.JAVA_CLASS))));
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("timestamp"), DisplayDataMatchers.hasType(DisplayData.Type.TIMESTAMP))));
        Assert.assertThat((Object)items, (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("duration"), DisplayDataMatchers.hasType(DisplayData.Type.DURATION))));
    }

    @Test
    public void testExplicitItemType() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"integer", (DisplayData.Type)DisplayData.Type.INTEGER, (Object)1234L)).add(DisplayData.item((String)"string", (DisplayData.Type)DisplayData.Type.STRING, (Object)"foobar"));
            }
        });
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("integer", 1234L));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("string", "foobar"));
    }

    @Test
    public void testFormatIncompatibleTypes() {
        ImmutableMap<DisplayData.Type, Integer> invalidPairs = ImmutableMap.builder().put(DisplayData.Type.STRING, 1234).put(DisplayData.Type.INTEGER, (Integer)((Object)"string value")).put(DisplayData.Type.FLOAT, (Integer)((Object)"string value")).put(DisplayData.Type.BOOLEAN, (Integer)((Object)"string value")).put(DisplayData.Type.TIMESTAMP, (Integer)((Object)"string value")).put(DisplayData.Type.DURATION, (Integer)((Object)"string value")).put(DisplayData.Type.JAVA_CLASS, (Integer)((Object)"string value")).build();
        for (Map.Entry pair : invalidPairs.entrySet()) {
            try {
                DisplayData.Type type = (DisplayData.Type)pair.getKey();
                Object invalidValue = pair.getValue();
                type.format(invalidValue);
                Assert.fail((String)String.format("Expected exception not thrown for invalid %s value: %s", type, invalidValue));
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Test
    public void testFormatCompatibleTypes() {
        ImmutableMultimap<DisplayData.Type, Integer> validPairs = ImmutableMultimap.builder().put(DisplayData.Type.INTEGER, 1234).put(DisplayData.Type.INTEGER, (Integer)1234L).put(DisplayData.Type.FLOAT, (Integer)((Object)Float.valueOf(123.4f))).put(DisplayData.Type.FLOAT, (Integer)123.4).put(DisplayData.Type.FLOAT, 1234).put(DisplayData.Type.FLOAT, (Integer)1234L).build();
        for (Map.Entry pair : validPairs.entries()) {
            DisplayData.Type type = (DisplayData.Type)pair.getKey();
            Object value = pair.getValue();
            try {
                type.format(value);
            }
            catch (ClassCastException e) {
                throw new AssertionError(String.format("Failed to format %s for DisplayData.%s", value.getClass().getSimpleName(), type), e);
            }
        }
    }

    @Test
    public void testInvalidExplicitItemType() {
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"integer", (DisplayData.Type)DisplayData.Type.INTEGER, (Object)"foobar"));
            }
        };
        this.thrown.expectCause(Matchers.isA(ClassCastException.class));
        DisplayData.from((HasDisplayData)component);
    }

    @Test
    public void testKnownTypeInference() {
        Assert.assertEquals((Object)DisplayData.Type.INTEGER, (Object)DisplayData.inferType((Object)1234));
        Assert.assertEquals((Object)DisplayData.Type.INTEGER, (Object)DisplayData.inferType((Object)1234L));
        Assert.assertEquals((Object)DisplayData.Type.FLOAT, (Object)DisplayData.inferType((Object)12.3));
        Assert.assertEquals((Object)DisplayData.Type.FLOAT, (Object)DisplayData.inferType((Object)Float.valueOf(12.3f)));
        Assert.assertEquals((Object)DisplayData.Type.BOOLEAN, (Object)DisplayData.inferType((Object)true));
        Assert.assertEquals((Object)DisplayData.Type.TIMESTAMP, (Object)DisplayData.inferType((Object)Instant.now()));
        Assert.assertEquals((Object)DisplayData.Type.DURATION, (Object)DisplayData.inferType((Object)Duration.millis((long)1234L)));
        Assert.assertEquals((Object)DisplayData.Type.JAVA_CLASS, (Object)DisplayData.inferType(DisplayDataTest.class));
        Assert.assertEquals((Object)DisplayData.Type.STRING, (Object)DisplayData.inferType((Object)"hello world"));
        Assert.assertEquals(null, (Object)DisplayData.inferType(null));
        Assert.assertEquals(null, (Object)DisplayData.inferType((Object)new Object(){}));
    }

    @Test
    public void testStringFormatting() throws IOException {
        final Instant now = Instant.now();
        final Duration oneHour = Duration.standardHours((long)1L);
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"string", (String)"foobar")).add(DisplayData.item((String)"integer", (Integer)123)).add(DisplayData.item((String)"float", (Double)2.34)).add(DisplayData.item((String)"boolean", (Boolean)true)).add(DisplayData.item((String)"java_class", DisplayDataTest.class)).add(DisplayData.item((String)"timestamp", (Instant)now)).add(DisplayData.item((String)"duration", (Duration)oneHour));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)component);
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("string", "foobar"));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("integer", 123L));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("float", 2.34));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("boolean", true));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("java_class", DisplayDataTest.class));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("timestamp", now));
        Assert.assertThat((Object)data, DisplayDataMatchers.hasDisplayItem("duration", oneHour));
    }

    @Test
    public void testContextProperlyReset() {
        final HasDisplayData subComponent = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p", subComponent).add(DisplayData.item((String)"alpha", (String)"bravo"));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)component);
        Assert.assertThat((Object)data.items(), (org.hamcrest.Matcher)Matchers.hasItem((org.hamcrest.Matcher)Matchers.allOf(DisplayDataMatchers.hasKey("alpha"), DisplayDataMatchers.hasNamespace(component.getClass()))));
    }

    @Test
    public void testFromNull() {
        this.thrown.expect(NullPointerException.class);
        DisplayData.from(null);
    }

    @Test
    public void testIncludeNull() {
        this.thrown.expectCause(Matchers.isA(NullPointerException.class));
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p", null);
            }
        });
    }

    @Test
    public void testIncludeNullPath() {
        this.thrown.expectCause(Matchers.isA(NullPointerException.class));
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include(null, (HasDisplayData)new NoopDisplayData());
            }
        });
    }

    @Test
    public void testIncludeEmptyPath() {
        this.thrown.expectCause(Matchers.isA(IllegalArgumentException.class));
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("", (HasDisplayData)new NoopDisplayData());
            }
        });
    }

    @Test
    public void testNullKey() {
        this.thrown.expectCause(Matchers.isA(NullPointerException.class));
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item(null, (String)"foo"));
            }
        });
    }

    @Test
    public void testRejectsNullValues() {
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                try {
                    builder.add(DisplayData.item((String)"key", (String)null));
                    throw new RuntimeException("Should throw on null string value");
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        builder.add(DisplayData.item((String)"key", (Class)null));
                        throw new RuntimeException("Should throw on null class value");
                    }
                    catch (NullPointerException nullPointerException2) {
                        try {
                            builder.add(DisplayData.item((String)"key", (Duration)null));
                            throw new RuntimeException("Should throw on null duration value");
                        }
                        catch (NullPointerException nullPointerException3) {
                            try {
                                builder.add(DisplayData.item((String)"key", (Instant)null));
                                throw new RuntimeException("Should throw on null instant value");
                            }
                            catch (NullPointerException nullPointerException4) {
                                return;
                            }
                        }
                    }
                }
            }
        });
    }

    @Test
    public void testAcceptsNullOptionalValues() {
        DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"key", (String)"value").withLabel(null).withLinkUrl(null));
            }
        });
    }

    @Test
    public void testJsonSerialization() throws IOException {
        String stringValue = "foobar";
        int intValue = 1234;
        double floatValue = 123.4;
        boolean boolValue = true;
        int durationMillis = 1234;
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"string", (String)"foobar")).add(DisplayData.item((String)"long", (Integer)1234)).add(DisplayData.item((String)"double", (Double)123.4)).add(DisplayData.item((String)"boolean", (Boolean)true)).add(DisplayData.item((String)"instant", (Instant)new Instant(0L))).add(DisplayData.item((String)"duration", (Duration)Duration.millis((long)1234L))).add(DisplayData.item((String)"class", DisplayDataTest.class).withLinkUrl("http://abc").withLabel("baz"));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)component);
        JsonNode json = MAPPER.readTree(MAPPER.writeValueAsBytes((Object)data));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "STRING", "string", this.quoted("foobar")));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "INTEGER", "long", 1234));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "FLOAT", "double", 123.4));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "BOOLEAN", "boolean", true));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "DURATION", "duration", 1234));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "TIMESTAMP", "instant", this.quoted("1970-01-01T00:00:00.000Z")));
        Assert.assertThat((Object)json, this.hasExpectedJson(component, "JAVA_CLASS", "class", this.quoted(DisplayDataTest.class.getName()), this.quoted("DisplayDataTest"), "baz", "http://abc"));
    }

    @Test
    public void testJsonSerializationAnonymousClassNamespace() throws IOException {
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        };
        DisplayData data = DisplayData.from((HasDisplayData)component);
        JsonNode json = MAPPER.readTree(MAPPER.writeValueAsBytes((Object)data));
        String namespace = ((JsonNode)json.elements().next()).get("namespace").asText();
        final Pattern anonClassRegex = Pattern.compile(Pattern.quote(DisplayDataTest.class.getName()) + "\\$\\d+$");
        Assert.assertThat((Object)namespace, (org.hamcrest.Matcher)new CustomTypeSafeMatcher<String>("anonymous class regex: " + anonClassRegex){

            protected boolean matchesSafely(String item) {
                Matcher m = anonClassRegex.matcher(item);
                return m.matches();
            }
        });
    }

    @Test
    public void testCanSerializeItemSpecReference() {
        DisplayData.ItemSpec spec = DisplayData.item((String)"clazz", DisplayDataTest.class);
        SerializableUtils.ensureSerializable((Serializable)new HoldsItemSpecReference(spec));
    }

    @Test
    public void testSerializable() {
        DisplayData data = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        });
        DisplayData serData = (DisplayData)SerializableUtils.clone((Serializable)data);
        Assert.assertEquals((Object)data, (Object)serData);
    }

    @Test
    public void testCanRecoverFromBuildException() {
        final HasDisplayData safeComponent = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"a", (String)"a"));
            }
        };
        final HasDisplayData failingComponent = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                throw new RuntimeException("oh noes!");
            }
        };
        DisplayData displayData = DisplayData.from((HasDisplayData)new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"b", (String)"b")).add(DisplayData.item((String)"c", (String)"c"));
                try {
                    builder.include("p", failingComponent);
                    Assert.fail((String)"Expected exception not thrown");
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                builder.include("p", safeComponent).add(DisplayData.item((String)"d", (String)"d"));
            }
        });
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("a"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("b"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("c"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("d"));
    }

    @Test
    public void testExceptionMessage() {
        final RuntimeException cause = new RuntimeException("oh noes!");
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                throw cause;
            }
        };
        this.thrown.expectMessage(component.getClass().getName());
        this.thrown.expectCause(Matchers.is((Object)cause));
        DisplayData.from((HasDisplayData)component);
    }

    @Test
    public void testExceptionsNotWrappedRecursively() {
        final RuntimeException cause = new RuntimeException("oh noes!");
        HasDisplayData component = new HasDisplayData(){

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.include("p", new HasDisplayData(){

                    public void populateDisplayData(DisplayData.Builder builder) {
                        throw cause;
                    }
                });
            }
        };
        this.thrown.expectCause(Matchers.is((Object)cause));
        DisplayData.from((HasDisplayData)component);
    }

    @Test
    public void testAutoValue() {
        DisplayData data = DisplayData.from((HasDisplayData)new AutoValue_DisplayDataTest_Foo());
        DisplayData.Item item = (DisplayData.Item)Iterables.getOnlyElement(data.asMap().values());
        Assert.assertEquals(Foo.class, (Object)item.getNamespace());
    }

    private String quoted(Object obj) {
        return String.format("\"%s\"", obj);
    }

    private org.hamcrest.Matcher<Iterable<? super JsonNode>> hasExpectedJson(HasDisplayData component, String type, String key, Object value) throws IOException {
        return this.hasExpectedJson(component, type, key, value, null, null, null);
    }

    private org.hamcrest.Matcher<Iterable<? super JsonNode>> hasExpectedJson(HasDisplayData component, String type, String key, Object value, Object shortValue, String label, String linkUrl) throws IOException {
        Class<?> nsClass = component.getClass();
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(String.format("\"namespace\":\"%s\",", nsClass.getName()));
        builder.append(String.format("\"type\":\"%s\",", type));
        builder.append(String.format("\"key\":\"%s\",", key));
        builder.append(String.format("\"value\":%s", value));
        if (shortValue != null) {
            builder.append(String.format(",\"shortValue\":%s", shortValue));
        }
        if (label != null) {
            builder.append(String.format(",\"label\":\"%s\"", label));
        }
        if (linkUrl != null) {
            builder.append(String.format(",\"linkUrl\":\"%s\"", linkUrl));
        }
        builder.append("}");
        JsonNode jsonNode = MAPPER.readTree(builder.toString());
        return Matchers.hasItem((Object)jsonNode);
    }

    private static org.hamcrest.Matcher<DisplayData.Item> hasUrl(org.hamcrest.Matcher<String> urlMatcher) {
        return new FeatureMatcher<DisplayData.Item, String>(urlMatcher, "display item with url", "URL"){

            protected String featureValueOf(DisplayData.Item actual) {
                return actual.getLinkUrl();
            }
        };
    }

    private static <T> org.hamcrest.Matcher<DisplayData.Item> hasShortValue(org.hamcrest.Matcher<T> valueStringMatcher) {
        return new FeatureMatcher<DisplayData.Item, T>(valueStringMatcher, "display item with short value", "short value"){

            protected T featureValueOf(DisplayData.Item actual) {
                Object shortValue = actual.getShortValue();
                return shortValue;
            }
        };
    }

    private static class NoopDisplayData
    implements HasDisplayData {
        private NoopDisplayData() {
        }

        public void populateDisplayData(DisplayData.Builder builder) {
        }
    }

    @AutoValue
    static abstract class Foo
    implements HasDisplayData {
        Foo() {
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"someKey", (String)"someValue"));
        }
    }

    private static class HoldsItemSpecReference
    implements Serializable {
        private final DisplayData.ItemSpec<?> spec;

        public HoldsItemSpecReference(DisplayData.ItemSpec<?> spec) {
            this.spec = spec;
        }
    }

    static abstract class IncludeSubComponent
    implements HasDisplayData {
        HasDisplayData subComponent;

        IncludeSubComponent() {
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"id", (String)this.getId())).include(this.getId(), this.subComponent);
        }

        abstract String getId();
    }

    private static class EqualsEverything
    implements HasDisplayData {
        private final String value;
        private final String key;

        EqualsEverything(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)this.key, (String)this.value));
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return true;
        }
    }

    private static class DelegatingDisplayData
    implements HasDisplayData {
        private final HasDisplayData subComponent;

        public DelegatingDisplayData(HasDisplayData subComponent) {
            this.subComponent = subComponent;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"subComponent", this.subComponent.getClass())).include("p", this.subComponent);
        }
    }
}

