/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DisplayDataMatchersTest {
    @Test
    public void testHasDisplayItem() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem();
        Assert.assertFalse((boolean)matcher.matches((Object)DisplayData.none()));
        Assert.assertThat((Object)this.createDisplayDataWithItem("foo", "bar"), matcher);
    }

    @Test
    public void testHasDisplayItemDescription() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem();
        StringDescription desc = new StringDescription();
        StringDescription mismatchDesc = new StringDescription();
        matcher.describeTo((Description)desc);
        matcher.describeMismatch((Object)DisplayData.none(), (Description)mismatchDesc);
        Assert.assertEquals((Object)"DisplayData not an empty collection", (Object)desc.toString());
        Assert.assertEquals((Object)"DisplayData was <[]>", (Object)mismatchDesc.toString());
    }

    @Test
    public void testHasKey() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem("foo");
        Assert.assertFalse((boolean)matcher.matches((Object)this.createDisplayDataWithItem("fooz", "bar")));
        Assert.assertThat((Object)this.createDisplayDataWithItem("foo", "bar"), matcher);
    }

    @Test
    public void testHasType() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasType(DisplayData.Type.JAVA_CLASS));
        DisplayData data = DisplayData.from((HasDisplayData)new PTransform<PCollection<String>, PCollection<String>>(){

            public PCollection<String> expand(PCollection<String> input) {
                throw new IllegalArgumentException("Should never be applied");
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", DisplayDataMatchersTest.class));
            }
        });
        Assert.assertFalse((boolean)matcher.matches((Object)this.createDisplayDataWithItem("fooz", "bar")));
        Assert.assertThat((Object)data, matcher);
    }

    @Test
    public void testHasValue() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasValue("bar"));
        Assert.assertFalse((boolean)matcher.matches((Object)this.createDisplayDataWithItem("foo", "baz")));
        Assert.assertThat((Object)this.createDisplayDataWithItem("foo", "bar"), matcher);
    }

    @Test
    public void testHasPath() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasPath("a", "b"));
        HasDisplayData subComponent = builder -> builder.include("b", builder1 -> builder1.add(DisplayData.item((String)"foo", (String)"bar")));
        Assert.assertFalse((boolean)matcher.matches((Object)DisplayData.from((HasDisplayData)subComponent)));
        Assert.assertThat((Object)DisplayData.from(builder -> builder.include("a", subComponent)), matcher);
    }

    @Test
    public void testHasNamespace() {
        Matcher<DisplayData> matcher = DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasNamespace(SampleTransform.class));
        Assert.assertFalse((boolean)matcher.matches((Object)DisplayData.from((HasDisplayData)new PTransform<PCollection<String>, PCollection<String>>(){

            public PCollection<String> expand(PCollection<String> input) {
                throw new IllegalArgumentException("Should never be applied");
            }
        })));
        Assert.assertThat((Object)this.createDisplayDataWithItem("foo", "bar"), matcher);
    }

    @Test
    public void testIncludes() {
        HasDisplayData subComponent = builder -> builder.add(DisplayData.item((String)"foo", (String)"bar"));
        HasDisplayData hasSubcomponent = builder -> builder.include("p", subComponent);
        HasDisplayData wrongPath = builder -> builder.include("q", subComponent);
        HasDisplayData deeplyNested = builder -> builder.include("p", builder1 -> builder1.include("p", subComponent));
        HasDisplayData sameDisplayItemDifferentComponent = builder -> builder.add(DisplayData.item((String)"foo", (String)"bar"));
        Matcher<DisplayData> matcher = DisplayDataMatchers.includesDisplayDataFor("p", subComponent);
        Assert.assertFalse((String)"should not match sub-component at different path", (boolean)matcher.matches((Object)DisplayData.from((HasDisplayData)wrongPath)));
        Assert.assertFalse((String)"should not match deeply nested sub-component", (boolean)matcher.matches((Object)DisplayData.from((HasDisplayData)deeplyNested)));
        Assert.assertFalse((String)"should not match identical display data from different component", (boolean)matcher.matches((Object)DisplayData.from((HasDisplayData)sameDisplayItemDifferentComponent)));
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)hasSubcomponent), matcher);
    }

    private DisplayData createDisplayDataWithItem(String key, String value) {
        return DisplayData.from((HasDisplayData)new SampleTransform(key, value));
    }

    static class SampleTransform
    extends PTransform<PCollection<String>, PCollection<String>> {
        private final String key;
        private final String value;

        SampleTransform(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public PCollection<String> expand(PCollection<String> input) {
            throw new IllegalArgumentException("Should never be applied");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)this.key, (String)this.value));
        }
    }
}

