/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class DisplayDataMatchers {
    private DisplayDataMatchers() {
    }

    public static Matcher<DisplayData> hasDisplayItem() {
        return new FeatureMatcher<DisplayData, Collection<DisplayData.Item>>(Matchers.not((Matcher)Matchers.empty()), "DisplayData", "DisplayData"){

            protected Collection<DisplayData.Item> featureValueOf(DisplayData actual) {
                return actual.items();
            }
        };
    }

    public static Matcher<DisplayData> hasDisplayItem(String key) {
        return DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasKey(key));
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, String value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.STRING, value);
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, Boolean value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.BOOLEAN, value);
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, Duration value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.DURATION, value);
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, double value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.FLOAT, value);
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, long value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.INTEGER, value);
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, Class<?> value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.JAVA_CLASS, value);
    }

    public static Matcher<DisplayData> hasDisplayItem(String key, Instant value) {
        return DisplayDataMatchers.hasDisplayItem(key, DisplayData.Type.TIMESTAMP, value);
    }

    private static Matcher<DisplayData> hasDisplayItem(String key, DisplayData.Type type, Object value) {
        DisplayData.FormattedItemValue formattedValue = type.format(value);
        return DisplayDataMatchers.hasDisplayItem((Matcher<DisplayData.Item>)Matchers.allOf(DisplayDataMatchers.hasKey(key), DisplayDataMatchers.hasType(type), DisplayDataMatchers.hasValue(formattedValue.getLongValue())));
    }

    public static Matcher<DisplayData> hasDisplayItem(Matcher<DisplayData.Item> itemMatcher) {
        return new HasDisplayDataItemMatcher(itemMatcher);
    }

    public static Matcher<DisplayData> includesDisplayDataFor(final String path, final HasDisplayData subComponent) {
        return new CustomTypeSafeMatcher<DisplayData>("includes subcomponent"){

            protected boolean matchesSafely(DisplayData displayData) {
                DisplayData subComponentData = this.subComponentData(path);
                if (subComponentData.items().isEmpty()) {
                    throw new UnsupportedOperationException("subComponent contains no display data; cannot verify whether it is included");
                }
                DisplayDataComparison comparison = this.checkSubset(displayData, subComponentData, path);
                return comparison.missingItems.isEmpty();
            }

            protected void describeMismatchSafely(DisplayData displayData, Description mismatchDescription) {
                DisplayData subComponentDisplayData = this.subComponentData(path);
                DisplayDataComparison comparison = this.checkSubset(displayData, subComponentDisplayData, path);
                mismatchDescription.appendText("did not include:\n").appendValue(comparison.missingItems).appendText("\nNon-matching items:\n").appendValue(comparison.unmatchedItems);
            }

            private DisplayData subComponentData(String path2) {
                return DisplayData.from(builder -> builder.include(path2, subComponent));
            }

            private DisplayDataComparison checkSubset(DisplayData displayData, DisplayData included, String path2) {
                DisplayDataComparison comparison = new DisplayDataComparison(displayData.items());
                for (DisplayData.Item item : included.items()) {
                    DisplayData.Item matchedItem = (DisplayData.Item)displayData.asMap().get(DisplayData.Identifier.of((DisplayData.Path)DisplayData.Path.absolute((String)path2, (String[])new String[0]), (Class)item.getNamespace(), (String)item.getKey()));
                    if (matchedItem != null) {
                        comparison.matched(matchedItem);
                        continue;
                    }
                    comparison.missing(item);
                }
                return comparison;
            }

            class DisplayDataComparison {
                Collection<DisplayData.Item> missingItems = Sets.newHashSet();
                Collection<DisplayData.Item> unmatchedItems;

                DisplayDataComparison(Collection<DisplayData.Item> superset) {
                    this.unmatchedItems = Sets.newHashSet(superset);
                }

                void matched(DisplayData.Item supersetItem) {
                    this.unmatchedItems.remove(supersetItem);
                }

                void missing(DisplayData.Item subsetItem) {
                    this.missingItems.add(subsetItem);
                }
            }
        };
    }

    public static Matcher<DisplayData.Item> hasKey(String key) {
        return DisplayDataMatchers.hasKey((Matcher<String>)Matchers.is((Object)key));
    }

    public static Matcher<DisplayData.Item> hasKey(Matcher<String> keyMatcher) {
        return new FeatureMatcher<DisplayData.Item, String>(keyMatcher, "with key", "key"){

            protected String featureValueOf(DisplayData.Item actual) {
                return actual.getKey();
            }
        };
    }

    public static Matcher<DisplayData.Item> hasPath(String ... paths) {
        DisplayData.Path path = paths.length == 0 ? DisplayData.Path.root() : DisplayData.Path.absolute((String)paths[0], (String[])Arrays.copyOfRange(paths, 1, paths.length));
        return new FeatureMatcher<DisplayData.Item, DisplayData.Path>(Matchers.is((Object)path), " with namespace", "namespace"){

            protected DisplayData.Path featureValueOf(DisplayData.Item actual) {
                return actual.getPath();
            }
        };
    }

    public static Matcher<DisplayData.Item> hasNamespace(Class<?> namespace) {
        return DisplayDataMatchers.hasNamespace(Matchers.is(namespace));
    }

    public static Matcher<DisplayData.Item> hasNamespace(Matcher<Class<?>> namespaceMatcher) {
        return new FeatureMatcher<DisplayData.Item, Class<?>>(namespaceMatcher, " with namespace", "namespace"){

            protected Class<?> featureValueOf(DisplayData.Item actual) {
                return actual.getNamespace();
            }
        };
    }

    public static Matcher<DisplayData.Item> hasType(DisplayData.Type type) {
        return DisplayDataMatchers.hasType((Matcher<DisplayData.Type>)Matchers.is((Object)type));
    }

    public static Matcher<DisplayData.Item> hasType(Matcher<DisplayData.Type> typeMatcher) {
        return new FeatureMatcher<DisplayData.Item, DisplayData.Type>(typeMatcher, "with type", "type"){

            protected DisplayData.Type featureValueOf(DisplayData.Item actual) {
                return actual.getType();
            }
        };
    }

    public static Matcher<DisplayData.Item> hasValue(Object value) {
        return DisplayDataMatchers.hasValue(Matchers.is((Object)value));
    }

    public static <T> Matcher<DisplayData.Item> hasValue(Matcher<T> valueMatcher) {
        return new FeatureMatcher<DisplayData.Item, T>(valueMatcher, "with value", "value"){

            protected T featureValueOf(DisplayData.Item actual) {
                Object value = actual.getValue();
                return value;
            }
        };
    }

    public static Matcher<DisplayData.Item> hasLabel(String label) {
        return DisplayDataMatchers.hasLabel((Matcher<String>)Matchers.is((Object)label));
    }

    public static Matcher<DisplayData.Item> hasLabel(Matcher<String> labelMatcher) {
        return new FeatureMatcher<DisplayData.Item, String>(labelMatcher, "display item with label", "label"){

            protected String featureValueOf(DisplayData.Item actual) {
                return actual.getLabel();
            }
        };
    }

    private static class HasDisplayDataItemMatcher
    extends TypeSafeDiagnosingMatcher<DisplayData> {
        private final Matcher<DisplayData.Item> itemMatcher;

        private HasDisplayDataItemMatcher(Matcher<DisplayData.Item> itemMatcher) {
            this.itemMatcher = itemMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("display data with item: ");
            this.itemMatcher.describeTo(description);
        }

        protected boolean matchesSafely(DisplayData data, Description mismatchDescription) {
            Collection items = data.items();
            boolean isMatch = Matchers.hasItem(this.itemMatcher).matches((Object)items);
            if (!isMatch) {
                mismatchDescription.appendText("found " + items.size() + " non-matching item(s):\n");
                mismatchDescription.appendValue((Object)data);
            }
            return isMatch;
        }
    }
}

