/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import java.io.Serializable;
import java.util.Set;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DisplayDataEvaluatorTest
implements Serializable {
    @Test
    public void testCompositeTransform() {
        PTransform<PCollection<String>, POutput> myTransform = new PTransform<PCollection<String>, POutput>(){

            public PCollection<String> expand(PCollection<String> input) {
                return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                    @DoFn.ProcessElement
                    public void processElement(DoFn.ProcessContext c) throws Exception {
                        c.output((Object)((String)c.element()));
                    }

                    public void populateDisplayData(DisplayData.Builder builder) {
                        builder.add(DisplayData.item((String)"primitiveKey", (String)"primitiveValue"));
                    }
                }));
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"compositeKey", (String)"compositeValue"));
            }
        };
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        Set<DisplayData> displayData = evaluator.displayDataForPrimitiveTransforms(myTransform);
        Assert.assertThat(displayData, (Matcher)Matchers.not((Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("compositeKey", "compositeValue"))));
        Assert.assertThat(displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("primitiveKey", "primitiveValue")));
    }

    @Test
    public void testPrimitiveTransform() {
        ParDo.SingleOutput myTransform = ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar"));
            }
        });
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        Set<DisplayData> displayData = evaluator.displayDataForPrimitiveTransforms(myTransform);
        Assert.assertThat(displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("foo")));
    }

    @Test
    public void testSourceTransform() {
        TextIO.Read myTransform = TextIO.read().from("foo.*");
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        Set<DisplayData> displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform<? super PBegin, ? extends POutput>)myTransform);
        Assert.assertThat(displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("filePattern", "foo.*")));
    }
}

