/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import java.util.Objects;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;

public class DisplayDataEvaluator {
    private final PipelineOptions options;

    public static DisplayDataEvaluator create() {
        return DisplayDataEvaluator.create(DisplayDataEvaluator.getDefaultOptions());
    }

    public static DisplayDataEvaluator create(PipelineOptions pipelineOptions) {
        return new DisplayDataEvaluator(pipelineOptions);
    }

    public static PipelineOptions getDefaultOptions() {
        return TestPipeline.testingPipelineOptions();
    }

    private DisplayDataEvaluator(PipelineOptions options) {
        this.options = options;
    }

    public <InputT> Set<DisplayData> displayDataForPrimitiveTransforms(PTransform<? super PCollection<InputT>, ? extends POutput> root) {
        return this.displayDataForPrimitiveTransforms(root, null);
    }

    public <InputT> Set<DisplayData> displayDataForPrimitiveTransforms(PTransform<? super PCollection<InputT>, ? extends POutput> root, Coder<InputT> inputCoder) {
        Create.Values input = inputCoder != null ? Create.empty(inputCoder) : Create.empty((Coder)VoidCoder.of());
        Pipeline pipeline = Pipeline.create((PipelineOptions)this.options);
        ((PCollection)pipeline.apply("Input", (PTransform)input)).apply("Transform", root);
        return DisplayDataEvaluator.displayDataForPipeline(pipeline, root);
    }

    public Set<DisplayData> displayDataForPrimitiveSourceTransforms(PTransform<? super PBegin, ? extends POutput> root) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)this.options);
        pipeline.apply("SourceTransform", root);
        return DisplayDataEvaluator.displayDataForPipeline(pipeline, root);
    }

    private static Set<DisplayData> displayDataForPipeline(Pipeline pipeline, PTransform<?, ?> root) {
        PrimitiveDisplayDataPTransformVisitor visitor = new PrimitiveDisplayDataPTransformVisitor(root);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.getPrimitivesDisplayData();
    }

    private static class PrimitiveDisplayDataPTransformVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private final PTransform<?, ?> root;
        private final Set<DisplayData> displayData;
        private boolean inCompositeRoot = false;

        PrimitiveDisplayDataPTransformVisitor(PTransform<?, ?> root) {
            this.root = root;
            this.displayData = Sets.newHashSet();
        }

        Set<DisplayData> getPrimitivesDisplayData() {
            return this.displayData;
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (Objects.equals(this.root, node.getTransform())) {
                this.inCompositeRoot = true;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void leaveCompositeTransform(TransformHierarchy.Node node) {
            if (Objects.equals(this.root, node.getTransform())) {
                this.inCompositeRoot = false;
            }
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            if (this.inCompositeRoot || Objects.equals(this.root, node.getTransform())) {
                this.displayData.add(DisplayData.from((HasDisplayData)node.getTransform()));
            }
        }
    }
}

