/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WithKeysTest {
    private static final String[] COLLECTION = new String[]{"a", "aa", "b", "bb", "bbb"};
    private static final List<KV<Integer, String>> WITH_KEYS = Arrays.asList(KV.of((Object)1, (Object)"a"), KV.of((Object)2, (Object)"aa"), KV.of((Object)1, (Object)"b"), KV.of((Object)2, (Object)"bb"), KV.of((Object)3, (Object)"bbb"));
    private static final List<KV<Integer, String>> WITH_CONST_KEYS = Arrays.asList(KV.of((Object)100, (Object)"a"), KV.of((Object)100, (Object)"aa"), KV.of((Object)100, (Object)"b"), KV.of((Object)100, (Object)"bb"), KV.of((Object)100, (Object)"bbb"));
    private static final List<KV<Void, String>> WITH_CONST_NULL_KEYS = Arrays.asList(KV.of((Object)null, (Object)"a"), KV.of((Object)null, (Object)"aa"), KV.of((Object)null, (Object)"b"), KV.of((Object)null, (Object)"bb"), KV.of((Object)null, (Object)"bbb"));
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testExtractKeys() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)WithKeys.of((SerializableFunction)new LengthAsKey()));
        PAssert.that((PCollection)output).containsInAnyOrder(WITH_KEYS);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testConstantKeys() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)WithKeys.of((Object)100));
        PAssert.that((PCollection)output).containsInAnyOrder(WITH_CONST_KEYS);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testConstantVoidKeys() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)WithKeys.of((Object)null));
        PAssert.that((PCollection)output).containsInAnyOrder(WITH_CONST_NULL_KEYS);
        this.p.run();
    }

    @Test
    public void testWithKeysGetName() {
        Assert.assertEquals((Object)"WithKeys", (Object)WithKeys.of((Object)100).getName());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWithKeysWithUnneededWithKeyTypeSucceeds() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)WithKeys.of((SerializableFunction)new LengthAsKey()).withKeyType(TypeDescriptor.of(Integer.class)));
        PAssert.that((PCollection)output).containsInAnyOrder(WITH_KEYS);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void withLambdaAndTypeDescriptorShouldSucceed() {
        PCollection values = (PCollection)this.p.apply((PTransform)Create.of((Object)"1234", (Object[])new String[]{"3210", "0", "-12"}));
        PCollection kvs = (PCollection)values.apply((PTransform)WithKeys.of(Integer::valueOf).withKeyType(TypeDescriptor.of(Integer.class)));
        PAssert.that((PCollection)kvs).containsInAnyOrder((Object[])new KV[]{KV.of((Object)1234, (Object)"1234"), KV.of((Object)0, (Object)"0"), KV.of((Object)-12, (Object)"-12"), KV.of((Object)3210, (Object)"3210")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void withLambdaAndNoTypeDescriptorShouldThrow() {
        PCollection values = (PCollection)this.p.apply((PTransform)Create.of((Object)"1234", (Object[])new String[]{"3210", "0", "-12"}));
        values.apply("ApplyKeysWithWithKeys", (PTransform)WithKeys.of(Integer::valueOf));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to return a default Coder for ApplyKeysWithWithKeys");
        this.p.run();
    }

    public static class LengthAsKey
    implements SerializableFunction<String, Integer> {
        public Integer apply(String value) {
            return value.length();
        }
    }
}

