/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.InvalidWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ViewTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testSingletonSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("Create47", (PTransform)Create.of((Object)47, (Object[])new Integer[0]))).apply((PTransform)View.asSingleton());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("Create123", (PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((Integer)c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{47, 47, 47});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedSingletonSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("Create47", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)47, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)48, (Instant)new Instant(11L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asSingleton());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("Create123", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)1, (Instant)new Instant(4L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)2, (Instant)new Instant(8L)), TimestampedValue.of((Object)3, (Instant)new Instant(12L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((Integer)c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{47, 47, 48});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testEmptySingletonSideInput() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyIntegers", (PTransform)Create.empty((Coder)VarIntCoder.of()))).apply((PTransform)View.asSingleton());
        ((PCollection)this.pipeline.apply("Create123", (PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((Integer)c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectCause(Matchers.isA(NoSuchElementException.class));
        this.thrown.expectMessage("Empty");
        this.thrown.expectMessage("PCollection");
        this.thrown.expectMessage("singleton");
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testNonSingletonSideInput() throws Exception {
        PCollection oneTwoThree = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        final PCollectionView view = (PCollectionView)oneTwoThree.apply((PTransform)View.asSingleton());
        oneTwoThree.apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((Integer)c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectCause(Matchers.isA(IllegalArgumentException.class));
        this.thrown.expectMessage("PCollection");
        this.thrown.expectMessage("more than one");
        this.thrown.expectMessage("singleton");
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testListSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)11, (Object[])new Integer[]{13, 17, 23}))).apply((PTransform)View.asList());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)29, (Object[])new Integer[]{31}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Preconditions.checkArgument(((List)c.sideInput(view)).size() == 4);
                Preconditions.checkArgument(((Integer)((List)c.sideInput(view)).get(0)).equals(((List)c.sideInput(view)).get(0)));
                for (Integer i : (List)c.sideInput(view)) {
                    c.output((Object)i);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{11, 13, 17, 23, 11, 13, 17, 23});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedListSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)11, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)13, (Instant)new Instant(1L)), TimestampedValue.of((Object)17, (Instant)new Instant(1L)), TimestampedValue.of((Object)23, (Instant)new Instant(1L)), TimestampedValue.of((Object)31, (Instant)new Instant(11L)), TimestampedValue.of((Object)33, (Instant)new Instant(11L)), TimestampedValue.of((Object)37, (Instant)new Instant(11L)), TimestampedValue.of((Object)43, (Instant)new Instant(11L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asList());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)29, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)35, (Instant)new Instant(11L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Preconditions.checkArgument(((List)c.sideInput(view)).size() == 4);
                Preconditions.checkArgument(((Integer)((List)c.sideInput(view)).get(0)).equals(((List)c.sideInput(view)).get(0)));
                for (Integer i : (List)c.sideInput(view)) {
                    c.output((Object)i);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{11, 13, 17, 23, 31, 33, 37, 43});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyListSideInput() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyView", (PTransform)Create.empty((Coder)VarIntCoder.of()))).apply((PTransform)View.asList());
        PCollection results = (PCollection)((PCollection)this.pipeline.apply("Create1", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertTrue((boolean)((List)c.sideInput(view)).isEmpty());
                Assert.assertFalse((boolean)((List)c.sideInput(view)).iterator().hasNext());
                c.output((Object)1);
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new Integer[]{1});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testListSideInputIsImmutable() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)11, (Object[])new Integer[0]))).apply((PTransform)View.asList());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)29, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                try {
                    ((List)c.sideInput(view)).clear();
                    Assert.fail((String)"Expected UnsupportedOperationException on clear()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((List)c.sideInput(view)).add(4);
                    Assert.fail((String)"Expected UnsupportedOperationException on add()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((List)c.sideInput(view)).addAll(new ArrayList());
                    Assert.fail((String)"Expected UnsupportedOperationException on addAll()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((List)c.sideInput(view)).remove(0);
                    Assert.fail((String)"Expected UnsupportedOperationException on remove()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                for (Integer i : (List)c.sideInput(view)) {
                    c.output((Object)i);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{11});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testIterableSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)11, (Object[])new Integer[]{13, 17, 23}))).apply((PTransform)View.asIterable());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)29, (Object[])new Integer[]{31}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Integer i : (Iterable)c.sideInput(view)) {
                    c.output((Object)i);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{11, 13, 17, 23, 11, 13, 17, 23});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedIterableSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)11, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)13, (Instant)new Instant(1L)), TimestampedValue.of((Object)17, (Instant)new Instant(1L)), TimestampedValue.of((Object)23, (Instant)new Instant(1L)), TimestampedValue.of((Object)31, (Instant)new Instant(11L)), TimestampedValue.of((Object)33, (Instant)new Instant(11L)), TimestampedValue.of((Object)37, (Instant)new Instant(11L)), TimestampedValue.of((Object)43, (Instant)new Instant(11L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asIterable());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)29, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)35, (Instant)new Instant(11L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Integer i : (Iterable)c.sideInput(view)) {
                    c.output((Object)i);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{11, 13, 17, 23, 31, 33, 37, 43});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyIterableSideInput() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyView", (PTransform)Create.empty((Coder)VarIntCoder.of()))).apply((PTransform)View.asIterable());
        PCollection results = (PCollection)((PCollection)this.pipeline.apply("Create1", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertFalse((boolean)((Iterable)c.sideInput(view)).iterator().hasNext());
                c.output((Object)1);
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new Integer[]{1});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testIterableSideInputIsImmutable() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)11, (Object[])new Integer[0]))).apply((PTransform)View.asIterable());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)29, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Iterator iterator = ((Iterable)c.sideInput(view)).iterator();
                while (iterator.hasNext()) {
                    try {
                        iterator.remove();
                        Assert.fail((String)"Expected UnsupportedOperationException on remove()");
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    c.output((Object)((Integer)iterator.next()));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{11});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMultimapSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"a", (Object)2), KV.of((Object)"b", (Object)3)}))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Integer v : (Iterable)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1))) {
                    c.output((Object)KV.of((Object)((String)c.element()), (Object)v));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"apple", (Object)2), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMultimapAsEntrySetSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"a", (Object)2), KV.of((Object)"b", (Object)3)}))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)2, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).size());
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).entrySet().size());
                for (Map.Entry entry : ((Map)c.sideInput(view)).entrySet()) {
                    for (Integer value : (Iterable)entry.getValue()) {
                        c.output((Object)KV.of((Object)((String)entry.getKey()), (Object)value));
                    }
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)2), KV.of((Object)"b", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMultimapSideInputWithNonDeterministicKeyCoder() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"a", (Object)2), KV.of((Object)"b", (Object)3)}).withCoder((Coder)KvCoder.of((Coder)new NonDeterministicStringCoder(), (Coder)VarIntCoder.of())))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Integer v : (Iterable)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1))) {
                    c.output((Object)KV.of((Object)((String)c.element()), (Object)v));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"apple", (Object)2), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedMultimapSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)2), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)3), (Instant)new Instant(14L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"apple", (Instant)new Instant(5L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"banana", (Instant)new Instant(13L)), TimestampedValue.of((Object)"blackberry", (Instant)new Instant(16L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Integer v : (Iterable)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1))) {
                    c.output((Object)KV.of((Object)((String)c.element()), (Object)v));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"apple", (Object)2), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedMultimapAsEntrySetSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)2), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)3), (Instant)new Instant(14L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)1, (Instant)new Instant(5L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)1, (Instant)new Instant(16L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).size());
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).entrySet().size());
                for (Map.Entry entry : ((Map)c.sideInput(view)).entrySet()) {
                    for (Integer value : (Iterable)entry.getValue()) {
                        c.output((Object)KV.of((Object)((String)entry.getKey()), (Object)value));
                    }
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)2), KV.of((Object)"b", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedMultimapSideInputWithNonDeterministicKeyCoder() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)2), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)3), (Instant)new Instant(14L))}).withCoder((Coder)KvCoder.of((Coder)new NonDeterministicStringCoder(), (Coder)VarIntCoder.of())))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"apple", (Instant)new Instant(5L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"banana", (Instant)new Instant(13L)), TimestampedValue.of((Object)"blackberry", (Instant)new Instant(16L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Integer v : (Iterable)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1))) {
                    c.output((Object)KV.of((Object)((String)c.element()), (Object)v));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"apple", (Object)2), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyMultimapSideInput() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyView", (PTransform)Create.empty((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of())))).apply((PTransform)View.asMultimap());
        PCollection results = (PCollection)((PCollection)this.pipeline.apply("Create1", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).isEmpty());
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).entrySet().isEmpty());
                Assert.assertFalse((boolean)((Map)c.sideInput(view)).entrySet().iterator().hasNext());
                c.output((Object)((Integer)c.element()));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new Integer[]{1});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyMultimapSideInputWithNonDeterministicKeyCoder() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyView", (PTransform)Create.empty((Coder)KvCoder.of((Coder)new NonDeterministicStringCoder(), (Coder)VarIntCoder.of())))).apply((PTransform)View.asMultimap());
        PCollection results = (PCollection)((PCollection)this.pipeline.apply("Create1", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).isEmpty());
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).entrySet().isEmpty());
                Assert.assertFalse((boolean)((Map)c.sideInput(view)).entrySet().iterator().hasNext());
                c.output((Object)((Integer)c.element()));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new Integer[]{1});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMultimapSideInputIsImmutable() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[0]))).apply((PTransform)View.asMultimap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                try {
                    ((Map)c.sideInput(view)).clear();
                    Assert.fail((String)"Expected UnsupportedOperationException on clear()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((Map)c.sideInput(view)).put("c", ImmutableList.of(Integer.valueOf(3)));
                    Assert.fail((String)"Expected UnsupportedOperationException on put()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((Map)c.sideInput(view)).remove("c");
                    Assert.fail((String)"Expected UnsupportedOperationException on remove()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((Map)c.sideInput(view)).putAll(new HashMap());
                    Assert.fail((String)"Expected UnsupportedOperationException on putAll()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                for (Integer v : (Iterable)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1))) {
                    c.output((Object)KV.of((Object)((String)c.element()), (Object)v));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMapSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)3)}))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMapAsEntrySetSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)3)}))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)2, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).size());
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).entrySet().size());
                for (Map.Entry entry : ((Map)c.sideInput(view)).entrySet()) {
                    c.output((Object)KV.of((Object)((String)entry.getKey()), (Object)((Integer)entry.getValue())));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)1), KV.of((Object)"b", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMapSideInputWithNonDeterministicKeyCoder() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)3)}).withCoder((Coder)KvCoder.of((Coder)new NonDeterministicStringCoder(), (Coder)VarIntCoder.of())))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedMapSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"b", (Object)2), (Instant)new Instant(4L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)3), (Instant)new Instant(18L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"apple", (Instant)new Instant(5L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"banana", (Instant)new Instant(4L)), TimestampedValue.of((Object)"blackberry", (Instant)new Instant(16L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"banana", (Object)2), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedMapAsEntrySetSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"b", (Object)2), (Instant)new Instant(4L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)3), (Instant)new Instant(18L))}))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)2, (Instant)new Instant(5L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)1, (Instant)new Instant(16L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).size());
                Assert.assertEquals((long)((Integer)c.element()).intValue(), (long)((Map)c.sideInput(view)).entrySet().size());
                for (Map.Entry entry : ((Map)c.sideInput(view)).entrySet()) {
                    c.output((Object)KV.of((Object)((String)entry.getKey()), (Object)((Integer)entry.getValue())));
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)1), KV.of((Object)"b", (Object)2), KV.of((Object)"b", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedMapSideInputWithNonDeterministicKeyCoder() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"b", (Object)2), (Instant)new Instant(4L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)3), (Instant)new Instant(18L))}).withCoder((Coder)KvCoder.of((Coder)new NonDeterministicStringCoder(), (Coder)VarIntCoder.of())))).apply("SideWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"apple", (Instant)new Instant(5L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"banana", (Instant)new Instant(4L)), TimestampedValue.of((Object)"blackberry", (Instant)new Instant(16L))}))).apply("MainWindowInto", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"banana", (Object)2), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyMapSideInput() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyView", (PTransform)Create.empty((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of())))).apply((PTransform)View.asMap());
        PCollection results = (PCollection)((PCollection)this.pipeline.apply("Create1", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).isEmpty());
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).entrySet().isEmpty());
                Assert.assertFalse((boolean)((Map)c.sideInput(view)).entrySet().iterator().hasNext());
                c.output((Object)((Integer)c.element()));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new Integer[]{1});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyMapSideInputWithNonDeterministicKeyCoder() throws Exception {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptyView", (PTransform)Create.empty((Coder)KvCoder.of((Coder)new NonDeterministicStringCoder(), (Coder)VarIntCoder.of())))).apply((PTransform)View.asMap());
        PCollection results = (PCollection)((PCollection)this.pipeline.apply("Create1", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).isEmpty());
                Assert.assertTrue((boolean)((Map)c.sideInput(view)).entrySet().isEmpty());
                Assert.assertFalse((boolean)((Map)c.sideInput(view)).entrySet().iterator().hasNext());
                c.output((Object)((Integer)c.element()));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new Integer[]{1});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapSideInputWithNullValuesCatchesDuplicates() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)null), (Object[])new KV[]{KV.of((Object)"a", (Object)null)}).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)NullableCoder.of((Coder)VarIntCoder.of()))))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Duplicate values for a")));
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMapSideInputIsImmutable() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[0]))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[0]))).apply("OutputSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                try {
                    ((Map)c.sideInput(view)).clear();
                    Assert.fail((String)"Expected UnsupportedOperationException on clear()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((Map)c.sideInput(view)).put("c", 3);
                    Assert.fail((String)"Expected UnsupportedOperationException on put()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((Map)c.sideInput(view)).remove("c");
                    Assert.fail((String)"Expected UnsupportedOperationException on remove()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    ((Map)c.sideInput(view)).putAll(new HashMap());
                    Assert.fail((String)"Expected UnsupportedOperationException on putAll()");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)1)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCombinedMapSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"a", (Object)20), KV.of((Object)"b", (Object)3)}))).apply("SumIntegers", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)Sum.ofIntegers()))).apply((PTransform)View.asMap());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"apple", (Object[])new String[]{"banana", "blackberry"}))).apply("Output", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((Integer)((Map)c.sideInput(view)).get(((String)c.element()).substring(0, 1)))));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"apple", (Object)21), KV.of((Object)"banana", (Object)3), KV.of((Object)"blackberry", (Object)3)});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedSideInputFixedToFixed() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)1, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)2, (Instant)new Instant(11L)), TimestampedValue.of((Object)3, (Instant)new Instant(13L))}))).apply("WindowSideInput", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)Sum.integersGlobally().withoutDefaults())).apply((PTransform)View.asSingleton());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"A", (Instant)new Instant(4L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"B", (Instant)new Instant(15L)), TimestampedValue.of((Object)"C", (Instant)new Instant(7L))}))).apply("WindowMainInput", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputMainAndSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((String)c.element() + c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"A1", "B5", "C1"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedSideInputFixedToGlobal() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)1, (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)2, (Instant)new Instant(11L)), TimestampedValue.of((Object)3, (Instant)new Instant(13L))}))).apply("WindowSideInput", (PTransform)Window.into((WindowFn)new GlobalWindows()))).apply((PTransform)Sum.integersGlobally())).apply((PTransform)View.asSingleton());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"A", (Instant)new Instant(4L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"B", (Instant)new Instant(15L)), TimestampedValue.of((Object)"C", (Instant)new Instant(7L))}))).apply("WindowMainInput", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputMainAndSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((String)c.element() + c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"A6", "B6", "C6"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testWindowedSideInputFixedToFixedWithDefault() {
        final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)2, (Instant)new Instant(11L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)3, (Instant)new Instant(13L))}))).apply("WindowSideInput", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply((PTransform)Sum.integersGlobally().asSingletonView());
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"A", (Instant)new Instant(4L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"B", (Instant)new Instant(15L)), TimestampedValue.of((Object)"C", (Instant)new Instant(7L))}))).apply("WindowMainInput", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)10L))))).apply("OutputMainAndSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((String)c.element() + c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"A0", "B5", "C0"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testSideInputWithNullDefault() {
        final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.of((Object)null, (Object[])new Void[0]).withCoder((Coder)VoidCoder.of()))).apply((PTransform)Combine.globally((SerializableFunction & Serializable)input -> null).asSingletonView());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.of((Object)"", (Object[])new String[0]))).apply("OutputMainAndSideInputs", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((String)c.element() + c.sideInput(view)));
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"null"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testSideInputWithNestedIterables() {
        final PCollectionView view1 = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateVoid1", (PTransform)Create.of((Object)null, (Object[])new Void[0]).withCoder((Coder)VoidCoder.of()))).apply("OutputOneInteger", (PTransform)ParDo.of((DoFn)new DoFn<Void, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)17);
            }
        }))).apply("View1", (PTransform)View.asIterable());
        final PCollectionView view2 = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateVoid2", (PTransform)Create.of((Object)null, (Object[])new Void[0]).withCoder((Coder)VoidCoder.of()))).apply("OutputSideInput", (PTransform)ParDo.of((DoFn)new DoFn<Void, Iterable<Integer>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)((Iterable)c.sideInput(view1)));
            }
        }).withSideInputs(new PCollectionView[]{view1}))).apply("View2", (PTransform)View.asIterable());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateVoid3", (PTransform)Create.of((Object)null, (Object[])new Void[0]).withCoder((Coder)VoidCoder.of()))).apply("ReadIterableSideInput", (PTransform)ParDo.of((DoFn)new DoFn<Void, Integer>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (Iterable input : (Iterable)c.sideInput(view2)) {
                    for (Integer i : input) {
                        c.output((Object)i);
                    }
                }
            }
        }).withSideInputs(new PCollectionView[]{view2}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{17});
        this.pipeline.run();
    }

    @Test
    public void testViewGetName() {
        Assert.assertEquals((Object)"View.AsSingleton", (Object)View.asSingleton().getName());
        Assert.assertEquals((Object)"View.AsIterable", (Object)View.asIterable().getName());
        Assert.assertEquals((Object)"View.AsMap", (Object)View.asMap().getName());
        Assert.assertEquals((Object)"View.AsMultimap", (Object)View.asMultimap().getName());
    }

    private void testViewUnbounded(Pipeline pipeline, PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>> view) {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to create a side-input view from input");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"non-bounded PCollection")));
        ((PCollection)pipeline.apply((PTransform)new PTransform<PBegin, PCollection<KV<String, Integer>>>(){

            public PCollection<KV<String, Integer>> expand(PBegin input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of()));
            }
        })).apply(view);
    }

    private void testViewNonmerging(Pipeline pipeline, PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>> view) {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to create a side-input view from input");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Consumed by GroupByKey")));
        ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"hello", (Object)5), (Object[])new KV[0]))).apply((PTransform)Window.into((WindowFn)new InvalidWindows("Consumed by GroupByKey", (WindowFn)FixedWindows.of((Duration)Duration.standardHours((long)1L)))))).apply(view);
    }

    @Test
    public void testViewUnboundedAsSingletonDirect() {
        this.testViewUnbounded((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewUnboundedAsIterableDirect() {
        this.testViewUnbounded((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewUnboundedAsListDirect() {
        this.testViewUnbounded((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewUnboundedAsMapDirect() {
        this.testViewUnbounded((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewUnboundedAsMultimapDirect() {
        this.testViewUnbounded((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }

    @Test
    public void testViewNonmergingAsSingletonDirect() {
        this.testViewNonmerging((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewNonmergingAsIterableDirect() {
        this.testViewNonmerging((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewNonmergingAsListDirect() {
        this.testViewNonmerging((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewNonmergingAsMapDirect() {
        this.testViewNonmerging((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewNonmergingAsMultimapDirect() {
        this.testViewNonmerging((Pipeline)this.pipeline, (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }

    private static class NonDeterministicStringCoder
    extends AtomicCoder<String> {
        private NonDeterministicStringCoder() {
        }

        public void encode(String value, OutputStream outStream) throws CoderException, IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        public void encode(String value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            StringUtf8Coder.of().encode(value, outStream, context);
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        public String decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            return StringUtf8Coder.of().decode(inStream, context);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            throw new Coder.NonDeterministicException((Coder)this, "Test coder is not deterministic on purpose.");
        }
    }
}

