/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TopTest {
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    static final String[] COLLECTION = new String[]{"a", "bb", "c", "c", "z"};
    static final String[] EMPTY_COLLECTION = new String[0];
    static final KV<String, Integer>[] TABLE = new KV[]{KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)2), KV.of((Object)"a", (Object)3), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)10), KV.of((Object)"b", (Object)10), KV.of((Object)"b", (Object)100)};
    static final KV<String, Integer>[] EMPTY_TABLE = new KV[0];

    public PCollection<KV<String, Integer>> createInputTable(Pipeline p) {
        return (PCollection)p.apply("CreateInputTable", (PTransform)Create.of(Arrays.asList(TABLE)).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
    }

    public PCollection<KV<String, Integer>> createEmptyInputTable(Pipeline p) {
        return (PCollection)p.apply("CreateEmptyInputTable", (PTransform)Create.of(Arrays.asList(EMPTY_TABLE)).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testTop() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection top1 = (PCollection)input.apply((PTransform)Top.of((int)1, (Comparator)new OrderByLength()));
        PCollection top2 = (PCollection)input.apply((PTransform)Top.largest((int)2));
        PCollection top3 = (PCollection)input.apply((PTransform)Top.smallest((int)3));
        PCollection<KV<String, Integer>> inputTable = this.createInputTable((Pipeline)this.p);
        PCollection largestPerKey = (PCollection)inputTable.apply((PTransform)Top.largestPerKey((int)2));
        PCollection smallestPerKey = (PCollection)inputTable.apply(Top.smallestPerKey((int)2));
        PAssert.thatSingletonIterable((PCollection)top1).containsInAnyOrder(Arrays.asList("bb"));
        PAssert.thatSingletonIterable((PCollection)top2).containsInAnyOrder((Object[])new String[]{"z", "c"});
        PAssert.thatSingletonIterable((PCollection)top3).containsInAnyOrder((Object[])new String[]{"a", "bb", "c"});
        PAssert.that((PCollection)largestPerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", Arrays.asList(3, 2)), KV.of((Object)"b", Arrays.asList(100, 10))});
        PAssert.that((PCollection)smallestPerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", Arrays.asList(1, 2)), KV.of((Object)"b", Arrays.asList(1, 10))});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testTopEmpty() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(EMPTY_COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection top1 = (PCollection)input.apply((PTransform)Top.of((int)1, (Comparator)new OrderByLength()));
        PCollection top2 = (PCollection)input.apply((PTransform)Top.largest((int)2));
        PCollection top3 = (PCollection)input.apply((PTransform)Top.smallest((int)3));
        PCollection<KV<String, Integer>> inputTable = this.createEmptyInputTable((Pipeline)this.p);
        PCollection largestPerKey = (PCollection)inputTable.apply((PTransform)Top.largestPerKey((int)2));
        PCollection smallestPerKey = (PCollection)inputTable.apply(Top.smallestPerKey((int)2));
        PAssert.thatSingletonIterable((PCollection)top1).empty();
        PAssert.thatSingletonIterable((PCollection)top2).empty();
        PAssert.thatSingletonIterable((PCollection)top3).empty();
        PAssert.that((PCollection)largestPerKey).empty();
        PAssert.that((PCollection)smallestPerKey).empty();
        this.p.run();
    }

    @Test
    public void testTopEmptyWithIncompatibleWindows() {
        this.p.enableAbandonedNodeEnforcement(false);
        Window windowingFn = Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardDays((long)10L)));
        PCollection input = (PCollection)((PCollection)this.p.apply((PTransform)Create.empty((Coder)StringUtf8Coder.of()))).apply((PTransform)windowingFn);
        this.expectedEx.expect(IllegalStateException.class);
        this.expectedEx.expectMessage("Top");
        this.expectedEx.expectMessage("GlobalWindows");
        this.expectedEx.expectMessage("withoutDefaults");
        this.expectedEx.expectMessage("asSingletonView");
        input.apply((PTransform)Top.of((int)1, (Comparator)new OrderByLength()));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testTopZero() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection top1 = (PCollection)input.apply((PTransform)Top.of((int)0, (Comparator)new OrderByLength()));
        PCollection top2 = (PCollection)input.apply((PTransform)Top.largest((int)0));
        PCollection top3 = (PCollection)input.apply((PTransform)Top.smallest((int)0));
        PCollection<KV<String, Integer>> inputTable = this.createInputTable((Pipeline)this.p);
        PCollection largestPerKey = (PCollection)inputTable.apply((PTransform)Top.largestPerKey((int)0));
        PCollection smallestPerKey = (PCollection)inputTable.apply(Top.smallestPerKey((int)0));
        PAssert.thatSingletonIterable((PCollection)top1).empty();
        PAssert.thatSingletonIterable((PCollection)top2).empty();
        PAssert.thatSingletonIterable((PCollection)top3).empty();
        PAssert.that((PCollection)largestPerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", Arrays.asList(new Integer[0])), KV.of((Object)"b", Arrays.asList(new Integer[0]))});
        PAssert.that((PCollection)smallestPerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", Arrays.asList(new Integer[0])), KV.of((Object)"b", Arrays.asList(new Integer[0]))});
        this.p.run();
    }

    @Test
    public void testPerKeySerializabilityRequirement() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.p.apply("CreateCollection", (PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        PCollection<KV<String, Integer>> inputTable = this.createInputTable((Pipeline)this.p);
        inputTable.apply(Top.perKey((int)1, (Comparator)new IntegerComparator()));
        inputTable.apply("PerKey2", Top.perKey((int)1, (Comparator)new IntegerComparator2()));
    }

    @Test
    public void testCountConstraint() {
        this.p.enableAbandonedNodeEnforcement(false);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(COLLECTION)).withCoder((Coder)StringUtf8Coder.of()));
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)">= 0"));
        input.apply((PTransform)Top.of((int)-1, (Comparator)new OrderByLength()));
    }

    @Test
    public void testTopGetNames() {
        Assert.assertEquals((Object)"Combine.globally(Top(OrderByLength))", (Object)Top.of((int)1, (Comparator)new OrderByLength()).getName());
        Assert.assertEquals((Object)"Combine.globally(Top(Reversed))", (Object)Top.smallest((int)1).getName());
        Assert.assertEquals((Object)"Combine.globally(Top(Natural))", (Object)Top.largest((int)2).getName());
        Assert.assertEquals((Object)"Combine.perKey(Top(IntegerComparator))", (Object)Top.perKey((int)1, (Comparator)new IntegerComparator()).getName());
        Assert.assertEquals((Object)"Combine.perKey(Top(Reversed))", (Object)Top.smallestPerKey((int)1).getName());
        Assert.assertEquals((Object)"Combine.perKey(Top(Natural))", (Object)Top.largestPerKey((int)2).getName());
    }

    @Test
    public void testDisplayData() {
        Top.Natural comparer = new Top.Natural();
        Combine.Globally top = Top.of((int)1234, (Comparator)comparer);
        DisplayData displayData = DisplayData.from((HasDisplayData)top);
        MatcherAssert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("count", 1234L));
        MatcherAssert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("comparer", comparer.getClass()));
    }

    private static class IntegerComparator2
    implements Comparator<Integer>,
    Serializable {
        private IntegerComparator2() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    }

    private static class IntegerComparator
    implements Comparator<Integer>,
    Serializable {
        private IntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    }

    private static class OrderByLength
    implements Comparator<String>,
    Serializable {
        private OrderByLength() {
        }

        @Override
        public int compare(String a, String b) {
            if (a.length() != b.length()) {
                return a.length() - b.length();
            }
            return a.compareTo(b);
        }
    }
}

