/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ToString;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ToStringTest {
    @Rule
    public final TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={NeedsRunner.class})
    public void testToStringOf() {
        Integer[] ints = new Integer[]{1, 2, 3, 4, 5};
        Object[] strings = new String[]{"1", "2", "3", "4", "5"};
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(ints)));
        PCollection output = (PCollection)input.apply(ToString.elements());
        PAssert.that((PCollection)output).containsInAnyOrder(strings);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testToStringKV() {
        ArrayList<KV> kvs = new ArrayList<KV>();
        kvs.add(KV.of((Object)"one", (Object)1));
        kvs.add(KV.of((Object)"two", (Object)2));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("one,1");
        expected.add("two,2");
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(kvs));
        PCollection output = (PCollection)input.apply(ToString.kvs());
        PAssert.that((PCollection)output).containsInAnyOrder(expected);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testToStringKVWithDelimiter() {
        ArrayList<KV> kvs = new ArrayList<KV>();
        kvs.add(KV.of((Object)"one", (Object)1));
        kvs.add(KV.of((Object)"two", (Object)2));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("one\t1");
        expected.add("two\t2");
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(kvs));
        PCollection output = (PCollection)input.apply(ToString.kvs((String)"\t"));
        PAssert.that((PCollection)output).containsInAnyOrder(expected);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testToStringIterable() {
        ArrayList<List<String>> iterables = new ArrayList<List<String>>();
        iterables.add(Arrays.asList("one", "two", "three"));
        iterables.add(Arrays.asList("four", "five", "six"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("one,two,three");
        expected.add("four,five,six");
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(iterables).withCoder((Coder)IterableCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply(ToString.iterables());
        PAssert.that((PCollection)output).containsInAnyOrder(expected);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testToStringIterableWithDelimiter() {
        ArrayList<List<String>> iterables = new ArrayList<List<String>>();
        iterables.add(Arrays.asList("one", "two", "three"));
        iterables.add(Arrays.asList("four", "five", "six"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("one\ttwo\tthree");
        expected.add("four\tfive\tsix");
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(iterables).withCoder((Coder)IterableCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply(ToString.iterables((String)"\t"));
        PAssert.that((PCollection)output).containsInAnyOrder(expected);
        this.p.run();
    }
}

