/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Sum;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SumTest {
    private static final CoderRegistry STANDARD_REGISTRY = CoderRegistry.createDefault();

    @Test
    public void testSumGetNames() {
        Assert.assertEquals((Object)"Combine.globally(SumInteger)", (Object)Sum.integersGlobally().getName());
        Assert.assertEquals((Object)"Combine.globally(SumDouble)", (Object)Sum.doublesGlobally().getName());
        Assert.assertEquals((Object)"Combine.globally(SumLong)", (Object)Sum.longsGlobally().getName());
        Assert.assertEquals((Object)"Combine.perKey(SumInteger)", (Object)Sum.integersPerKey().getName());
        Assert.assertEquals((Object)"Combine.perKey(SumDouble)", (Object)Sum.doublesPerKey().getName());
        Assert.assertEquals((Object)"Combine.perKey(SumLong)", (Object)Sum.longsPerKey().getName());
    }

    @Test
    public void testSumIntegerFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Sum.ofIntegers(), Lists.newArrayList(1, 2, 3, 4), (Object)10);
    }

    @Test
    public void testSumLongFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Sum.ofLongs(), Lists.newArrayList(1L, 2L, 3L, 4L), (Object)10L);
    }

    @Test
    public void testSumDoubleFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Sum.ofDoubles(), Lists.newArrayList(1.0, 2.0, 3.0, 4.0), (Object)10.0);
    }

    @Test
    public void testGetAccumulatorCoderEquals() {
        Combine.BinaryCombineIntegerFn sumIntegerFn = Sum.ofIntegers();
        Assert.assertEquals((Object)sumIntegerFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)VarIntCoder.of()), (Object)sumIntegerFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)VarIntCoder.of()));
        Assert.assertNotEquals((Object)sumIntegerFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)VarIntCoder.of()), (Object)sumIntegerFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)BigEndianIntegerCoder.of()));
        Combine.BinaryCombineLongFn sumLongFn = Sum.ofLongs();
        Assert.assertEquals((Object)sumLongFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)VarLongCoder.of()), (Object)sumLongFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)VarLongCoder.of()));
        Assert.assertNotEquals((Object)sumLongFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)VarLongCoder.of()), (Object)sumLongFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)BigEndianLongCoder.of()));
        Combine.BinaryCombineDoubleFn sumDoubleFn = Sum.ofDoubles();
        Assert.assertEquals((Object)sumDoubleFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)DoubleCoder.of()), (Object)sumDoubleFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)DoubleCoder.of()));
    }
}

