/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Ordering;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.testing.UsesBoundedSplittableParDo;
import org.apache.beam.sdk.testing.UsesParDoLifecycle;
import org.apache.beam.sdk.testing.UsesSplittableParDoWithWindowedSideInputs;
import org.apache.beam.sdk.testing.UsesTestStream;
import org.apache.beam.sdk.testing.UsesUnboundedSplittableParDo;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SplittableDoFnTest
implements Serializable {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    private static PairStringWithIndexToLengthBase pairStringWithIndexToLengthFn(PCollection.IsBounded bounded) {
        return bounded == PCollection.IsBounded.BOUNDED ? new PairStringWithIndexToLengthBounded() : new PairStringWithIndexToLengthUnbounded();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class})
    public void testPairWithIndexBasicBounded() {
        this.testPairWithIndexBasic(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class})
    public void testPairWithIndexBasicUnbounded() {
        this.testPairWithIndexBasic(PCollection.IsBounded.UNBOUNDED);
    }

    private void testPairWithIndexBasic(PCollection.IsBounded bounded) {
        PCollection res = ((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"bb", "ccccc"}))).apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.pairStringWithIndexToLengthFn(bounded)))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of()));
        PAssert.that((PCollection)res).containsInAnyOrder(Arrays.asList(KV.of((Object)"a", (Object)0), KV.of((Object)"bb", (Object)0), KV.of((Object)"bb", (Object)1), KV.of((Object)"ccccc", (Object)0), KV.of((Object)"ccccc", (Object)1), KV.of((Object)"ccccc", (Object)2), KV.of((Object)"ccccc", (Object)3), KV.of((Object)"ccccc", (Object)4)));
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class})
    public void testPairWithIndexWindowedTimestampedBounded() {
        this.testPairWithIndexWindowedTimestamped(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class})
    public void testPairWithIndexWindowedTimestampedUnbounded() {
        this.testPairWithIndexWindowedTimestamped(PCollection.IsBounded.UNBOUNDED);
    }

    private void testPairWithIndexWindowedTimestamped(PCollection.IsBounded bounded) {
        MutableDateTime mutableNow = Instant.now().toMutableDateTime();
        mutableNow.setMillisOfSecond(0);
        Instant now = mutableNow.toInstant();
        Instant nowP1 = now.plus((ReadableDuration)Duration.standardSeconds((long)1L));
        Instant nowP2 = now.plus((ReadableDuration)Duration.standardSeconds((long)2L));
        SlidingWindows windowFn = SlidingWindows.of((Duration)Duration.standardSeconds((long)5L)).every(Duration.standardSeconds((long)1L));
        PCollection res = ((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"a", (Instant)now), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"bb", (Instant)nowP1), TimestampedValue.of((Object)"ccccc", (Instant)nowP2)}))).apply((PTransform)Window.into((WindowFn)windowFn))).apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.pairStringWithIndexToLengthFn(bounded)))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of()));
        Assert.assertEquals((Object)windowFn, (Object)res.getWindowingStrategy().getWindowFn());
        PCollection timestamped = (PCollection)res.apply(Reify.timestamps());
        for (int i = 0; i < 4; ++i) {
            Instant base = now.minus((ReadableDuration)Duration.standardSeconds((long)i));
            IntervalWindow window = new IntervalWindow(base, base.plus((ReadableDuration)Duration.standardSeconds((long)5L)));
            List<TimestampedValue> expectedUnfiltered = Arrays.asList(TimestampedValue.of((Object)KV.of((Object)"a", (Object)0), (Instant)now), TimestampedValue.of((Object)KV.of((Object)"bb", (Object)0), (Instant)nowP1), TimestampedValue.of((Object)KV.of((Object)"bb", (Object)1), (Instant)nowP1), TimestampedValue.of((Object)KV.of((Object)"ccccc", (Object)0), (Instant)nowP2), TimestampedValue.of((Object)KV.of((Object)"ccccc", (Object)1), (Instant)nowP2), TimestampedValue.of((Object)KV.of((Object)"ccccc", (Object)2), (Instant)nowP2), TimestampedValue.of((Object)KV.of((Object)"ccccc", (Object)3), (Instant)nowP2), TimestampedValue.of((Object)KV.of((Object)"ccccc", (Object)4), (Instant)nowP2));
            ArrayList<TimestampedValue> expected = new ArrayList<TimestampedValue>();
            for (TimestampedValue tv : expectedUnfiltered) {
                if (window.start().isAfter((ReadableInstant)tv.getTimestamp()) || tv.getTimestamp().isAfter((ReadableInstant)window.maxTimestamp())) continue;
                expected.add(tv);
            }
            Assert.assertFalse((boolean)expected.isEmpty());
            PAssert.that((PCollection)timestamped).inWindow((BoundedWindow)window).containsInAnyOrder(expected);
        }
        this.p.run();
    }

    private static SDFWithMultipleOutputsPerBlockBase sdfWithMultipleOutputsPerBlock(PCollection.IsBounded bounded, int numClaimsPerCall) {
        return bounded == PCollection.IsBounded.BOUNDED ? new SDFWithMultipleOutputsPerBlockBounded(numClaimsPerCall) : new SDFWithMultipleOutputsPerBlockUnbounded(numClaimsPerCall);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class})
    public void testOutputAfterCheckpointBounded() {
        this.testOutputAfterCheckpoint(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class})
    public void testOutputAfterCheckpointUnbounded() {
        this.testOutputAfterCheckpoint(PCollection.IsBounded.UNBOUNDED);
    }

    private void testOutputAfterCheckpoint(PCollection.IsBounded bounded) {
        PCollection outputs = (PCollection)((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"foo", (Object[])new String[0]))).apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.sdfWithMultipleOutputsPerBlock(bounded, 3)))).apply((PTransform)Window.configure().triggering((Trigger)Never.ever()).discardingFiredPanes());
        PAssert.thatSingleton((PCollection)((PCollection)outputs.apply(Count.globally()))).isEqualTo((Object)98765L);
        this.p.run();
    }

    private static SDFWithSideInputBase sdfWithSideInput(PCollection.IsBounded bounded, PCollectionView<String> sideInput) {
        return bounded == PCollection.IsBounded.BOUNDED ? new SDFWithSideInputBounded(sideInput) : new SDFWithSideInputUnbounded(sideInput);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class})
    public void testSideInputBounded() {
        this.testSideInput(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class})
    public void testSideInputUnbounded() {
        this.testSideInput(PCollection.IsBounded.UNBOUNDED);
    }

    private void testSideInput(PCollection.IsBounded bounded) {
        PCollectionView sideInput = (PCollectionView)((PCollection)this.p.apply("side input", (PTransform)Create.of((Object)"foo", (Object[])new String[0]))).apply((PTransform)View.asSingleton());
        PCollection res = (PCollection)((PCollection)this.p.apply("input", (PTransform)Create.of((Object)0, (Object[])new Integer[]{1, 2}))).apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.sdfWithSideInput(bounded, (PCollectionView<String>)sideInput)).withSideInputs(new PCollectionView[]{sideInput}));
        PAssert.that((PCollection)res).containsInAnyOrder(Arrays.asList("foo:0", "foo:1", "foo:2"));
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class, UsesSplittableParDoWithWindowedSideInputs.class})
    public void testWindowedSideInputBounded() {
        this.testWindowedSideInput(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class, UsesSplittableParDoWithWindowedSideInputs.class})
    public void testWindowedSideInputUnbounded() {
        this.testWindowedSideInput(PCollection.IsBounded.UNBOUNDED);
    }

    private void testWindowedSideInput(PCollection.IsBounded bounded) {
        PCollection mainInput = (PCollection)((PCollection)this.p.apply("main", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)0, (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)), TimestampedValue.of((Object)3, (Instant)new Instant(3L)), TimestampedValue.of((Object)4, (Instant)new Instant(4L)), TimestampedValue.of((Object)5, (Instant)new Instant(5L)), TimestampedValue.of((Object)6, (Instant)new Instant(6L)), TimestampedValue.of((Object)7, (Instant)new Instant(7L))}))).apply("window 2", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)2L))));
        PCollectionView sideInput = (PCollectionView)((PCollection)((PCollection)this.p.apply("side", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"a", (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"b", (Instant)new Instant(4L))}))).apply("window 4", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)4L))))).apply("singleton", (PTransform)View.asSingleton());
        PCollection res = (PCollection)mainInput.apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.sdfWithSideInput(bounded, (PCollectionView<String>)sideInput)).withSideInputs(new PCollectionView[]{sideInput}));
        PAssert.that((PCollection)res).containsInAnyOrder((Object[])new String[]{"a:0", "a:1", "a:2", "a:3", "b:4", "b:5", "b:6", "b:7"});
        this.p.run();
    }

    private static SDFWithMultipleOutputsPerBlockAndSideInputBase sdfWithMultipleOutputsPerBlockAndSideInput(PCollection.IsBounded bounded, PCollectionView<String> sideInput, int numClaimsPerCall) {
        return bounded == PCollection.IsBounded.BOUNDED ? new SDFWithMultipleOutputsPerBlockAndSideInputBounded(sideInput, numClaimsPerCall) : new SDFWithMultipleOutputsPerBlockAndSideInputUnbounded(sideInput, numClaimsPerCall);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class, UsesSplittableParDoWithWindowedSideInputs.class})
    public void testWindowedSideInputWithCheckpointsBounded() {
        this.testWindowedSideInputWithCheckpoints(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class, UsesSplittableParDoWithWindowedSideInputs.class})
    public void testWindowedSideInputWithCheckpointsUnbounded() {
        this.testWindowedSideInputWithCheckpoints(PCollection.IsBounded.UNBOUNDED);
    }

    private void testWindowedSideInputWithCheckpoints(PCollection.IsBounded bounded) {
        PCollection mainInput = (PCollection)((PCollection)this.p.apply("main", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)0, (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)1, (Instant)new Instant(1L)), TimestampedValue.of((Object)2, (Instant)new Instant(2L)), TimestampedValue.of((Object)3, (Instant)new Instant(3L))}))).apply("window 1", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)1L))));
        PCollectionView sideInput = (PCollectionView)((PCollection)((PCollection)this.p.apply("side", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"a", (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"b", (Instant)new Instant(2L))}))).apply("window 2", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)2L))))).apply("singleton", (PTransform)View.asSingleton());
        PCollection res = (PCollection)mainInput.apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.sdfWithMultipleOutputsPerBlockAndSideInput(bounded, (PCollectionView<String>)sideInput, 3)).withSideInputs(new PCollectionView[]{sideInput}));
        PCollection grouped = (PCollection)res.apply((PTransform)GroupByKey.create());
        PAssert.that((PCollection)((PCollection)grouped.apply((PTransform)Keys.create()))).containsInAnyOrder((Object[])new String[]{"a:0", "a:1", "b:2", "b:3"});
        PAssert.that((PCollection)grouped).satisfies((SerializableFunction & Serializable)input -> {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            for (int i = 0; i < 98765; ++i) {
                expected.add(i);
            }
            for (KV kv : input) {
                Assert.assertEquals(expected, Ordering.natural().sortedCopy((Iterable)kv.getValue()));
            }
            return null;
        });
        this.p.run();
    }

    private static SDFWithAdditionalOutputBase sdfWithAdditionalOutput(PCollection.IsBounded bounded, TupleTag<String> additionalOutput) {
        return bounded == PCollection.IsBounded.BOUNDED ? new SDFWithAdditionalOutputBounded(additionalOutput) : new SDFWithAdditionalOutputUnbounded(additionalOutput);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class})
    public void testAdditionalOutputBounded() {
        this.testAdditionalOutput(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedSplittableParDo.class})
    public void testAdditionalOutputUnbounded() {
        this.testAdditionalOutput(PCollection.IsBounded.UNBOUNDED);
    }

    private void testAdditionalOutput(PCollection.IsBounded bounded) {
        TupleTag<String> mainOutputTag = new TupleTag<String>("main"){};
        TupleTag<String> additionalOutputTag = new TupleTag<String>("additional"){};
        PCollectionTuple res = (PCollectionTuple)((PCollection)this.p.apply("input", (PTransform)Create.of((Object)0, (Object[])new Integer[]{1, 2}))).apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.sdfWithAdditionalOutput(bounded, additionalOutputTag)).withOutputTags((TupleTag)mainOutputTag, TupleTagList.of((TupleTag)additionalOutputTag)));
        PAssert.that((PCollection)res.get((TupleTag)mainOutputTag)).containsInAnyOrder(Arrays.asList("main:0", "main:1", "main:2"));
        PAssert.that((PCollection)res.get((TupleTag)additionalOutputTag)).containsInAnyOrder(Arrays.asList("additional:0", "additional:1", "additional:2"));
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesBoundedSplittableParDo.class, UsesTestStream.class})
    public void testLateData() {
        Instant base = Instant.now();
        TestStream stream = TestStream.create((Coder)StringUtf8Coder.of()).advanceWatermarkTo(base).addElements((Object)"aa", (Object[])new String[0]).advanceWatermarkTo(base.plus((ReadableDuration)Duration.standardSeconds((long)5L))).addElements(TimestampedValue.of((Object)"bb", (Instant)base.minus((ReadableDuration)Duration.standardHours((long)1L))), new TimestampedValue[0]).advanceProcessingTime(Duration.standardHours((long)1L)).advanceWatermarkToInfinity();
        PCollection input = (PCollection)((PCollection)this.p.apply((PTransform)stream)).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))).withAllowedLateness(Duration.standardMinutes((long)1L)).discardingFiredPanes());
        PCollection afterSDF = ((PCollection)input.apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.pairStringWithIndexToLengthFn(PCollection.IsBounded.UNBOUNDED)))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of()));
        PCollection nonLate = (PCollection)((PCollection)afterSDF.apply((PTransform)GroupByKey.create())).apply((PTransform)Keys.create());
        PAssert.that((PCollection)afterSDF).containsInAnyOrder(Arrays.asList(KV.of((Object)"aa", (Object)0), KV.of((Object)"aa", (Object)1), KV.of((Object)"bb", (Object)0), KV.of((Object)"bb", (Object)1)));
        Assert.assertEquals((Object)afterSDF.getWindowingStrategy(), (Object)input.getWindowingStrategy());
        PAssert.that((PCollection)nonLate).containsInAnyOrder((Object[])new String[]{"aa"});
        this.p.run();
    }

    private static SDFWithLifecycleBase sdfWithLifecycle(PCollection.IsBounded bounded) {
        return bounded == PCollection.IsBounded.BOUNDED ? new SDFWithLifecycleBounded() : new SDFWithLifecycleUnbounded();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesParDoLifecycle.class, UsesBoundedSplittableParDo.class})
    public void testLifecycleMethodsBounded() {
        this.testLifecycleMethods(PCollection.IsBounded.BOUNDED);
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesParDoLifecycle.class, UsesUnboundedSplittableParDo.class})
    public void testLifecycleMethodsUnbounded() {
        this.testLifecycleMethods(PCollection.IsBounded.UNBOUNDED);
    }

    private void testLifecycleMethods(PCollection.IsBounded bounded) {
        PCollection res = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c"}))).apply((PTransform)ParDo.of((DoFn)SplittableDoFnTest.sdfWithLifecycle(bounded)));
        PAssert.that((PCollection)res).containsInAnyOrder((Object[])new String[]{"a", "b", "c"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testBoundedness() {
        PCollection foo = (PCollection)this.p.apply((PTransform)Create.of((Object)"foo", (Object[])new String[0]));
        PCollection res = (PCollection)foo.apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element String element, OffsetRangeTracker tracker) {
            }

            @DoFn.GetInitialRestriction
            public OffsetRange getInitialRestriction(String element) {
                return new OffsetRange(0L, 1L);
            }
        }));
        Assert.assertEquals((Object)PCollection.IsBounded.BOUNDED, (Object)res.isBounded());
        res = (PCollection)foo.apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public DoFn.ProcessContinuation process(@DoFn.Element String element, OffsetRangeTracker tracker) {
                return DoFn.ProcessContinuation.stop();
            }

            @DoFn.GetInitialRestriction
            public OffsetRange getInitialRestriction(String element) {
                return new OffsetRange(0L, 1L);
            }
        }));
        Assert.assertEquals((Object)PCollection.IsBounded.UNBOUNDED, (Object)res.isBounded());
    }

    @DoFn.UnboundedPerElement
    private static class SDFWithLifecycleUnbounded
    extends SDFWithLifecycleBase {
        private SDFWithLifecycleUnbounded() {
        }
    }

    @DoFn.BoundedPerElement
    private static class SDFWithLifecycleBounded
    extends SDFWithLifecycleBase {
        private SDFWithLifecycleBounded() {
        }
    }

    private static class SDFWithLifecycleBase
    extends DoFn<String, String> {
        private transient State state;

        private SDFWithLifecycleBase() {
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRestriction(String value) {
            Assert.assertEquals((Object)((Object)State.OUTSIDE_BUNDLE), (Object)((Object)this.state));
            return new OffsetRange(0L, 1L);
        }

        @DoFn.SplitRestriction
        public void splitRestriction(String value, OffsetRange range, DoFn.OutputReceiver<OffsetRange> receiver) {
            Assert.assertEquals((Object)((Object)State.OUTSIDE_BUNDLE), (Object)((Object)this.state));
            receiver.output((Object)range);
        }

        @DoFn.Setup
        public void setUp() {
            Assert.assertEquals(null, (Object)((Object)this.state));
            this.state = State.OUTSIDE_BUNDLE;
        }

        @DoFn.StartBundle
        public void startBundle() {
            Assert.assertEquals((Object)((Object)State.OUTSIDE_BUNDLE), (Object)((Object)this.state));
            this.state = State.INSIDE_BUNDLE;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, OffsetRangeTracker tracker) {
            Assert.assertEquals((Object)((Object)State.INSIDE_BUNDLE), (Object)((Object)this.state));
            Assert.assertTrue((boolean)tracker.tryClaim((Object)0L));
            c.output((Object)((String)c.element()));
        }

        @DoFn.FinishBundle
        public void finishBundle() {
            Assert.assertEquals((Object)((Object)State.INSIDE_BUNDLE), (Object)((Object)this.state));
            this.state = State.OUTSIDE_BUNDLE;
        }

        @DoFn.Teardown
        public void tearDown() {
            Assert.assertEquals((Object)((Object)State.OUTSIDE_BUNDLE), (Object)((Object)this.state));
            this.state = State.TORN_DOWN;
        }

        private static enum State {
            OUTSIDE_BUNDLE,
            INSIDE_BUNDLE,
            TORN_DOWN;

        }
    }

    @DoFn.UnboundedPerElement
    private static class SDFWithAdditionalOutputUnbounded
    extends SDFWithAdditionalOutputBase {
        private SDFWithAdditionalOutputUnbounded(TupleTag<String> additionalOutput) {
            super(additionalOutput);
        }
    }

    @DoFn.BoundedPerElement
    private static class SDFWithAdditionalOutputBounded
    extends SDFWithAdditionalOutputBase {
        private SDFWithAdditionalOutputBounded(TupleTag<String> additionalOutput) {
            super(additionalOutput);
        }
    }

    private static class SDFWithAdditionalOutputBase
    extends DoFn<Integer, String> {
        private final TupleTag<String> additionalOutput;

        private SDFWithAdditionalOutputBase(TupleTag<String> additionalOutput) {
            this.additionalOutput = additionalOutput;
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, OffsetRangeTracker tracker) {
            Preconditions.checkState(tracker.tryClaim((Object)tracker.currentRestriction().getFrom()));
            c.output((Object)("main:" + c.element()));
            c.output(this.additionalOutput, (Object)("additional:" + c.element()));
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRestriction(Integer value) {
            return new OffsetRange(0L, 1L);
        }
    }

    @DoFn.UnboundedPerElement
    private static class SDFWithMultipleOutputsPerBlockAndSideInputUnbounded
    extends SDFWithMultipleOutputsPerBlockAndSideInputBase {
        private SDFWithMultipleOutputsPerBlockAndSideInputUnbounded(PCollectionView<String> sideInput, int numClaimsPerCall) {
            super(sideInput, numClaimsPerCall);
        }
    }

    @DoFn.BoundedPerElement
    private static class SDFWithMultipleOutputsPerBlockAndSideInputBounded
    extends SDFWithMultipleOutputsPerBlockAndSideInputBase {
        private SDFWithMultipleOutputsPerBlockAndSideInputBounded(PCollectionView<String> sideInput, int numClaimsPerCall) {
            super(sideInput, numClaimsPerCall);
        }
    }

    private static class SDFWithMultipleOutputsPerBlockAndSideInputBase
    extends DoFn<Integer, KV<String, Integer>> {
        private static final int MAX_INDEX = 98765;
        private final PCollectionView<String> sideInput;
        private final int numClaimsPerCall;

        SDFWithMultipleOutputsPerBlockAndSideInputBase(PCollectionView<String> sideInput, int numClaimsPerCall) {
            this.sideInput = sideInput;
            this.numClaimsPerCall = numClaimsPerCall;
        }

        private static int snapToNextBlock(int index, int[] blockStarts) {
            for (int i = 1; i < blockStarts.length; ++i) {
                if (index <= blockStarts[i - 1] || index > blockStarts[i]) continue;
                return i;
            }
            throw new IllegalStateException("Shouldn't get here");
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(DoFn.ProcessContext c, OffsetRangeTracker tracker) {
            int trueStart;
            int[] blockStarts = new int[]{-1, 0, 12, 123, 1234, 12345, 34567, 98765};
            int i = trueStart = SDFWithMultipleOutputsPerBlockAndSideInputBase.snapToNextBlock((int)tracker.currentRestriction().getFrom(), blockStarts);
            int numIterations = 1;
            while (tracker.tryClaim((Object)blockStarts[i])) {
                for (int index = blockStarts[i]; index < blockStarts[i + 1]; ++index) {
                    c.output((Object)KV.of((Object)((String)c.sideInput(this.sideInput) + ":" + c.element()), (Object)index));
                }
                if (numIterations == this.numClaimsPerCall) {
                    return DoFn.ProcessContinuation.resume();
                }
                ++i;
                ++numIterations;
            }
            return DoFn.ProcessContinuation.stop();
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRange(Integer element) {
            return new OffsetRange(0L, 98765L);
        }
    }

    @DoFn.UnboundedPerElement
    private static class SDFWithSideInputUnbounded
    extends SDFWithSideInputBase {
        private SDFWithSideInputUnbounded(PCollectionView<String> sideInput) {
            super(sideInput);
        }
    }

    @DoFn.BoundedPerElement
    private static class SDFWithSideInputBounded
    extends SDFWithSideInputBase {
        private SDFWithSideInputBounded(PCollectionView<String> sideInput) {
            super(sideInput);
        }
    }

    private static class SDFWithSideInputBase
    extends DoFn<Integer, String> {
        private final PCollectionView<String> sideInput;

        private SDFWithSideInputBase(PCollectionView<String> sideInput) {
            this.sideInput = sideInput;
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, OffsetRangeTracker tracker) {
            Preconditions.checkState(tracker.tryClaim((Object)tracker.currentRestriction().getFrom()));
            String side = (String)c.sideInput(this.sideInput);
            c.output((Object)(side + ":" + c.element()));
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRestriction(Integer value) {
            return new OffsetRange(0L, 1L);
        }
    }

    @DoFn.UnboundedPerElement
    private static class SDFWithMultipleOutputsPerBlockUnbounded
    extends SDFWithMultipleOutputsPerBlockBase {
        SDFWithMultipleOutputsPerBlockUnbounded(int numClaimsPerCall) {
            super(numClaimsPerCall);
        }
    }

    @DoFn.BoundedPerElement
    private static class SDFWithMultipleOutputsPerBlockBounded
    extends SDFWithMultipleOutputsPerBlockBase {
        SDFWithMultipleOutputsPerBlockBounded(int numClaimsPerCall) {
            super(numClaimsPerCall);
        }
    }

    private static class SDFWithMultipleOutputsPerBlockBase
    extends DoFn<String, Integer> {
        private static final int MAX_INDEX = 98765;
        private final int numClaimsPerCall;

        private SDFWithMultipleOutputsPerBlockBase(int numClaimsPerCall) {
            this.numClaimsPerCall = numClaimsPerCall;
        }

        private static int snapToNextBlock(int index, int[] blockStarts) {
            for (int i = 1; i < blockStarts.length; ++i) {
                if (index <= blockStarts[i - 1] || index > blockStarts[i]) continue;
                return i;
            }
            throw new IllegalStateException("Shouldn't get here");
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(DoFn.ProcessContext c, OffsetRangeTracker tracker) {
            int trueStart;
            int[] blockStarts = new int[]{-1, 0, 12, 123, 1234, 12345, 34567, 98765};
            int i = trueStart = SDFWithMultipleOutputsPerBlockBase.snapToNextBlock((int)tracker.currentRestriction().getFrom(), blockStarts);
            int numIterations = 1;
            while (tracker.tryClaim((Object)blockStarts[i])) {
                for (int index = blockStarts[i]; index < blockStarts[i + 1]; ++index) {
                    c.output((Object)index);
                }
                if (numIterations == this.numClaimsPerCall) {
                    return DoFn.ProcessContinuation.resume();
                }
                ++i;
                ++numIterations;
            }
            return DoFn.ProcessContinuation.stop();
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRange(String element) {
            return new OffsetRange(0L, 98765L);
        }
    }

    @DoFn.UnboundedPerElement
    static class PairStringWithIndexToLengthUnbounded
    extends PairStringWithIndexToLengthBase {
        PairStringWithIndexToLengthUnbounded() {
        }
    }

    @DoFn.BoundedPerElement
    static class PairStringWithIndexToLengthBounded
    extends PairStringWithIndexToLengthBase {
        PairStringWithIndexToLengthBounded() {
        }
    }

    static class PairStringWithIndexToLengthBase
    extends DoFn<String, KV<String, Integer>> {
        PairStringWithIndexToLengthBase() {
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation process(DoFn.ProcessContext c, OffsetRangeTracker tracker) {
            long i = tracker.currentRestriction().getFrom();
            long numIterations = 0L;
            while (tracker.tryClaim((Object)i)) {
                c.output((Object)KV.of((Object)((String)c.element()), (Object)((int)i)));
                if (numIterations % 3L == 0L) {
                    return DoFn.ProcessContinuation.resume();
                }
                ++i;
                ++numIterations;
            }
            return DoFn.ProcessContinuation.stop();
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRange(String element) {
            return new OffsetRange(0L, (long)element.length());
        }

        @DoFn.SplitRestriction
        public void splitRange(String element, OffsetRange range, DoFn.OutputReceiver<OffsetRange> receiver) {
            receiver.output((Object)new OffsetRange(range.getFrom(), (range.getFrom() + range.getTo()) / 2L));
            receiver.output((Object)new OffsetRange((range.getFrom() + range.getTo()) / 2L, range.getTo()));
        }
    }
}

