/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Mean;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sum;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SimpleStatsFnsTest {
    static final double DOUBLE_COMPARISON_ACCURACY = 1.0E-7;
    static final List<TestCase<Double>> DOUBLE_CASES = Arrays.asList(new TestCase((Number)-312.31, (Number)6312.31, (Number)11629.13, (Number[])new Double[]{-312.31, 29.13, 112.158, 6312.31, -312.158, -312.158, 112.158, -312.31, 6312.31, 0.0}), new TestCase((Number)3.14, (Number)3.14, (Number)3.14, (Number[])new Double[]{3.14}), new TestCase((Number)Double.POSITIVE_INFINITY, (Number)Double.NEGATIVE_INFINITY, (Number)0.0, (Number[])new Double[0]));
    static final List<TestCase<Long>> LONG_CASES = Arrays.asList(new TestCase((Number)-50000000000000000L, (Number)70000000000000000L, (Number)60000033123213121L, (Number[])new Long[]{0L, 1L, 10000000000000000L, -50000000000000000L, 70000000000000000L, 0L, 10000000000000000L, -1L, -50000000000000000L, 70000000000000000L, 33123213121L}), new TestCase((Number)3L, (Number)3L, (Number)3L, (Number[])new Long[]{3L}), new TestCase((Number)Long.MAX_VALUE, (Number)Long.MIN_VALUE, (Number)0L, (Number[])new Long[0]));
    static final List<TestCase<Integer>> INTEGER_CASES = Arrays.asList(new TestCase((Number)-3, (Number)6, (Number)22, (Number[])new Integer[]{1, -3, 2, 6, 3, 4, -3, 5, 6, 1}), new TestCase((Number)3, (Number)3, (Number)3, (Number[])new Integer[]{3}), new TestCase((Number)Integer.MAX_VALUE, (Number)Integer.MIN_VALUE, (Number)0, (Number[])new Integer[0]));

    @Test
    public void testInstantStats() {
        Assert.assertEquals((Object)new Instant(1000L), (Object)Min.naturalOrder().apply(Arrays.asList(new Instant(1000L), new Instant(2000L))));
        Assert.assertEquals(null, (Object)Min.naturalOrder().apply(Collections.emptyList()));
        Assert.assertEquals((Object)new Instant(5000L), (Object)Min.naturalOrder((Comparable)new Instant(5000L)).apply(Collections.emptyList()));
        Assert.assertEquals((Object)new Instant(2000L), (Object)Max.naturalOrder().apply(Arrays.asList(new Instant(1000L), new Instant(2000L))));
        Assert.assertEquals(null, (Object)Max.naturalOrder().apply(Collections.emptyList()));
        Assert.assertEquals((Object)new Instant(5000L), (Object)Max.naturalOrder((Comparable)new Instant(5000L)).apply(Collections.emptyList()));
    }

    @Test
    public void testDoubleStats() {
        for (TestCase<Double> t : DOUBLE_CASES) {
            Assert.assertEquals((double)((Double)t.sum), (double)((Double)Sum.ofDoubles().apply(t.data)), (double)1.0E-7);
            Assert.assertEquals((double)((Double)t.min), (double)((Double)Min.ofDoubles().apply(t.data)), (double)1.0E-7);
            Assert.assertEquals((double)((Double)t.max), (double)((Double)Max.ofDoubles().apply(t.data)), (double)1.0E-7);
            Assert.assertEquals((double)t.mean, (double)((Double)Mean.of().apply(t.data)), (double)1.0E-7);
        }
    }

    @Test
    public void testIntegerStats() {
        for (TestCase<Integer> t : INTEGER_CASES) {
            Assert.assertEquals(t.sum, (Object)Sum.ofIntegers().apply(t.data));
            Assert.assertEquals(t.min, (Object)Min.ofIntegers().apply(t.data));
            Assert.assertEquals(t.max, (Object)Max.ofIntegers().apply(t.data));
            Assert.assertEquals((Object)t.mean, (Object)Mean.of().apply(t.data));
        }
    }

    @Test
    public void testLongStats() {
        for (TestCase<Long> t : LONG_CASES) {
            Assert.assertEquals(t.sum, (Object)Sum.ofLongs().apply(t.data));
            Assert.assertEquals(t.min, (Object)Min.ofLongs().apply(t.data));
            Assert.assertEquals(t.max, (Object)Max.ofLongs().apply(t.data));
            Assert.assertEquals((Object)t.mean, (Object)Mean.of().apply(t.data));
        }
    }

    private static class TestCase<NumT extends Number> {
        final List<NumT> data;
        final NumT min;
        final NumT max;
        final NumT sum;
        final Double mean;

        @SafeVarargs
        public TestCase(NumT min, NumT max, NumT sum, NumT ... values) {
            this.data = Arrays.asList(values);
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.mean = values.length == 0 ? Double.NaN : ((Number)sum).doubleValue() / (double)values.length;
        }
    }
}

