/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SimpleFunctionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testFailureIfNotOverridden() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("must override");
        this.thrown.expectMessage("apply");
        new SimpleFunction<Integer, Integer>(){};
    }

    @Test
    public void testGoodTypeForLambda() throws Exception {
        SimpleFunction<Integer, String> fn = new SimpleFunction<Integer, String>(Object::toString){};
        Assert.assertThat((Object)fn.getInputTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptors.integers()));
        Assert.assertThat((Object)fn.getOutputTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptors.strings()));
    }

    @Test
    public void testGoodTypeForMethodRef() throws Exception {
        SimpleFunction<Integer, String> fn = new SimpleFunction<Integer, String>(SimpleFunctionTest::toStringThisThing){};
        Assert.assertThat((Object)fn.getInputTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptors.integers()));
        Assert.assertThat((Object)fn.getOutputTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptors.strings()));
    }

    private static String toStringThisThing(Integer i) {
        return i.toString();
    }
}

