/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Joiner;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

public class SampleTest {
    private static final Integer[] EMPTY = new Integer[0];
    private static final Integer[] DATA = new Integer[]{1, 2, 3, 4, 5};
    private static final Integer[] REPEATED_DATA = new Integer[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5};

    @RunWith(value=JUnit4.class)
    public static class MiscTest {
        @Rule
        public final transient TestPipeline pipeline = TestPipeline.create();

        private static TimestampedValue<Integer> tv(int i) {
            return TimestampedValue.of((Object)i, (Instant)new Instant((long)(i * 1000)));
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleAny() {
            PCollection input = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped(ImmutableList.of(MiscTest.tv(0), MiscTest.tv(1), MiscTest.tv(2), MiscTest.tv(3), MiscTest.tv(4), MiscTest.tv(5))).withCoder((Coder)BigEndianIntegerCoder.of()))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)3L))));
            PCollection output = (PCollection)input.apply(Sample.any((long)2L));
            PAssert.that((PCollection)output).inWindow((BoundedWindow)new IntervalWindow(new Instant(0L), (ReadableDuration)Duration.standardSeconds((long)3L))).satisfies(new VerifyCorrectSample<Integer>(2, (Collection<Integer>)Arrays.asList(0, 1, 2)));
            PAssert.that((PCollection)output).inWindow((BoundedWindow)new IntervalWindow(new Instant(3000L), (ReadableDuration)Duration.standardSeconds((long)3L))).satisfies(new VerifyCorrectSample<Integer>(2, (Collection<Integer>)Arrays.asList(3, 4, 5)));
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleAnyEmpty() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.empty((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)3L))))).apply(Sample.any((long)2L));
            PAssert.that((PCollection)output).satisfies((SerializableFunction)new VerifyCorrectSample(0, (Comparable[])EMPTY));
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleAnyZero() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.timestamped(ImmutableList.of(MiscTest.tv(0), MiscTest.tv(1), MiscTest.tv(2), MiscTest.tv(3), MiscTest.tv(4), MiscTest.tv(5))).withCoder((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)3L))))).apply(Sample.any((long)0L));
            PAssert.that((PCollection)output).inWindow((BoundedWindow)new IntervalWindow(new Instant(0L), (ReadableDuration)Duration.standardSeconds((long)3L))).satisfies((SerializableFunction)new VerifyCorrectSample(0, (Comparable[])EMPTY));
            PAssert.that((PCollection)output).inWindow((BoundedWindow)new IntervalWindow(new Instant(3000L), (ReadableDuration)Duration.standardSeconds((long)3L))).satisfies((SerializableFunction)new VerifyCorrectSample(0, (Comparable[])EMPTY));
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleAnyInsufficientElements() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.empty((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)3L))))).apply(Sample.any((long)10L));
            PAssert.that((PCollection)output).inWindow((BoundedWindow)new IntervalWindow(new Instant(0L), (ReadableDuration)Duration.standardSeconds((long)3L))).satisfies((SerializableFunction)new VerifyCorrectSample(0, (Comparable[])EMPTY));
            this.pipeline.run();
        }

        @Test(expected=IllegalArgumentException.class)
        public void testSampleAnyNegative() {
            this.pipeline.enableAbandonedNodeEnforcement(false);
            ((PCollection)this.pipeline.apply((PTransform)Create.empty((Coder)BigEndianIntegerCoder.of()))).apply(Sample.any((long)-10L));
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSample() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of(ImmutableList.copyOf(DATA)).withCoder((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)input.apply(Sample.fixedSizeGlobally((int)3));
            PAssert.thatSingletonIterable((PCollection)output).satisfies((SerializableFunction)new VerifyCorrectSample(3, (Comparable[])DATA));
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleEmpty() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.empty((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)input.apply(Sample.fixedSizeGlobally((int)3));
            PAssert.thatSingletonIterable((PCollection)output).satisfies((SerializableFunction)new VerifyCorrectSample(0, (Comparable[])EMPTY));
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleZero() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of(ImmutableList.copyOf(DATA)).withCoder((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)input.apply(Sample.fixedSizeGlobally((int)0));
            PAssert.thatSingletonIterable((PCollection)output).satisfies((SerializableFunction)new VerifyCorrectSample(0, (Comparable[])DATA));
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleInsufficientElements() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of(ImmutableList.copyOf(DATA)).withCoder((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)input.apply(Sample.fixedSizeGlobally((int)10));
            PAssert.thatSingletonIterable((PCollection)output).satisfies((SerializableFunction)new VerifyCorrectSample(5, (Comparable[])DATA));
            this.pipeline.run();
        }

        @Test(expected=IllegalArgumentException.class)
        public void testSampleNegative() {
            this.pipeline.enableAbandonedNodeEnforcement(false);
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of(ImmutableList.copyOf(DATA)).withCoder((Coder)BigEndianIntegerCoder.of()));
            input.apply(Sample.fixedSizeGlobally((int)-1));
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testSampleMultiplicity() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of(ImmutableList.copyOf(REPEATED_DATA)).withCoder((Coder)BigEndianIntegerCoder.of()));
            PCollection output = (PCollection)input.apply(Sample.fixedSizeGlobally((int)6));
            PAssert.thatSingletonIterable((PCollection)output).satisfies((SerializableFunction)new VerifyCorrectSample(6, (Comparable[])REPEATED_DATA));
            this.pipeline.run();
        }

        @Test
        public void testSampleGetName() {
            Assert.assertEquals((Object)"Sample.Any", (Object)Sample.any((long)1L).getName());
        }

        @Test
        public void testDisplayData() {
            PTransform sampleAny = Sample.any((long)1234L);
            DisplayData sampleAnyDisplayData = DisplayData.from((HasDisplayData)sampleAny);
            MatcherAssert.assertThat((Object)sampleAnyDisplayData, DisplayDataMatchers.hasDisplayItem("sampleSize", 1234L));
            PTransform samplePerKey = Sample.fixedSizePerKey((int)2345);
            DisplayData perKeyDisplayData = DisplayData.from((HasDisplayData)samplePerKey);
            MatcherAssert.assertThat((Object)perKeyDisplayData, DisplayDataMatchers.hasDisplayItem("sampleSize", 2345L));
        }

        public static class VerifyCorrectSample<T extends Comparable>
        implements SerializableFunction<Iterable<T>, Void> {
            private Object[] expectedValues;
            private int expectedSize;

            @SafeVarargs
            VerifyCorrectSample(int expectedSize, T ... expected) {
                this.expectedValues = expected;
                this.expectedSize = expectedSize;
            }

            VerifyCorrectSample(int expectedSize, Collection<T> expected) {
                this.expectedValues = expected.toArray();
                this.expectedSize = expectedSize;
            }

            public Void apply(Iterable<T> in) {
                ArrayList<Comparable> actual = new ArrayList<Comparable>();
                for (Comparable elem : in) {
                    actual.add(elem);
                }
                Assert.assertEquals((long)this.expectedSize, (long)actual.size());
                Collections.sort(actual);
                int i = 0;
                for (Comparable s : actual) {
                    boolean matchFound = false;
                    while (i < this.expectedValues.length) {
                        if (s.equals(this.expectedValues[i])) {
                            matchFound = true;
                            break;
                        }
                        ++i;
                    }
                    Assert.assertTrue((String)("Invalid sample: " + Joiner.on(',').join(actual)), (boolean)matchFound);
                    ++i;
                }
                return null;
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class PickAnyTest {
        @Rule
        public final transient TestPipeline p = TestPipeline.create();
        @Parameterized.Parameter(value=0)
        public List<String> lines;
        @Parameterized.Parameter(value=1)
        public int limit;

        @Parameterized.Parameters(name="limit_{1}")
        public static Iterable<Object[]> data() throws IOException {
            return ((ImmutableList.Builder)ImmutableList.builder().add((Object[])new Object[][]{{TestUtils.NO_LINES, 0}, {TestUtils.NO_LINES, 1}, {TestUtils.LINES, 1}, {TestUtils.LINES, TestUtils.LINES.size() / 2}, {TestUtils.LINES, TestUtils.LINES.size() * 2}, {TestUtils.LINES, TestUtils.LINES.size() - 1}, {TestUtils.LINES, TestUtils.LINES.size()}, {TestUtils.LINES, TestUtils.LINES.size() + 1}})).build();
        }

        void runPickAnyTest(List<String> lines, int limit) {
            Preconditions.checkArgument(new HashSet<String>(lines).size() == lines.size(), "Duplicates are unsupported.");
            PCollection input = (PCollection)this.p.apply((PTransform)Create.of(lines).withCoder((Coder)StringUtf8Coder.of()));
            PCollection output = (PCollection)input.apply(Sample.any((long)limit));
            PAssert.that((PCollection)output).satisfies((SerializableFunction)new VerifyAnySample(lines, limit));
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testPickAny() {
            this.runPickAnyTest(this.lines, this.limit);
        }

        @Test
        public void testCombineFn() {
            CombineFnTester.testCombineFn((Combine.CombineFn)Sample.combineFn((int)this.limit), this.lines, (Matcher)Matchers.allOf((Matcher)Matchers.iterableWithSize((int)Math.min(this.lines.size(), this.limit)), (Matcher)Matchers.everyItem((Matcher)Matchers.isIn(this.lines))));
        }

        private static class VerifyAnySample
        implements SerializableFunction<Iterable<String>, Void> {
            private final List<String> lines;
            private final int limit;

            private VerifyAnySample(List<String> lines, int limit) {
                this.lines = lines;
                this.limit = limit;
            }

            public Void apply(Iterable<String> actualIter) {
                int expectedSize = Math.min(this.limit, this.lines.size());
                ArrayList<String> actual = new ArrayList<String>();
                for (String s : actualIter) {
                    actual.add(s);
                }
                Assert.assertEquals((long)expectedSize, (long)actual.size());
                TreeSet actualAsSet = new TreeSet(actual);
                TreeSet<String> linesAsSet = new TreeSet<String>(this.lines);
                Assert.assertEquals((long)actual.size(), (long)actualAsSet.size());
                Assert.assertEquals((long)this.lines.size(), (long)linesAsSet.size());
                Assert.assertTrue((boolean)linesAsSet.containsAll(actualAsSet));
                return null;
            }
        }
    }
}

