/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.ReifyTimestamps;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReifyTest
implements Serializable {
    public static final WithTimestamps<KV<String, Integer>> TIMESTAMP_FROM_V = WithTimestamps.of((SerializableFunction & Serializable)input -> new Instant(((Integer)input.getValue()).longValue()));
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Test
    @Category(value={NeedsRunner.class})
    public void extractFromValuesSucceeds() {
        PCollection preified = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"foo", (Object)TimestampedValue.of((Object)0, (Instant)new Instant(0L))), (Object[])new KV[]{KV.of((Object)"foo", (Object)TimestampedValue.of((Object)1, (Instant)new Instant(1L))), KV.of((Object)"bar", (Object)TimestampedValue.of((Object)2, (Instant)new Instant(2L))), KV.of((Object)"baz", (Object)TimestampedValue.of((Object)3, (Instant)new Instant(3L)))}));
        PCollection timestamped = (PCollection)preified.apply(Reify.extractTimestampsFromValues());
        PAssert.that((PCollection)timestamped).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"foo", (Object)0), KV.of((Object)"foo", (Object)1), KV.of((Object)"bar", (Object)2), KV.of((Object)"baz", (Object)3)});
        timestamped.apply("AssertElementTimestamps", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, Integer>, Void>(){

            @DoFn.ProcessElement
            public void verifyTimestampsEqualValue(DoFn.ProcessContext context) {
                Assert.assertThat((Object)new Instant(((Integer)((KV)context.element()).getValue()).longValue()), (Matcher)Matchers.equalTo((Object)context.timestamp()));
            }
        }));
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void extractFromValuesWhenValueTimestampedLaterSucceeds() {
        PCollection preified = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"foo", (Object)TimestampedValue.of((Object)0, (Instant)new Instant(0L))), (Instant)new Instant(100L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"foo", (Object)TimestampedValue.of((Object)1, (Instant)new Instant(1L))), (Instant)new Instant(101L)), TimestampedValue.of((Object)KV.of((Object)"bar", (Object)TimestampedValue.of((Object)2, (Instant)new Instant(2L))), (Instant)new Instant(102L)), TimestampedValue.of((Object)KV.of((Object)"baz", (Object)TimestampedValue.of((Object)3, (Instant)new Instant(3L))), (Instant)new Instant(103L))}));
        PCollection timestamped = (PCollection)preified.apply(ReifyTimestamps.extractFromValues());
        PAssert.that((PCollection)timestamped).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"foo", (Object)0), KV.of((Object)"foo", (Object)1), KV.of((Object)"bar", (Object)2), KV.of((Object)"baz", (Object)3)});
        timestamped.apply("AssertElementTimestamps", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, Integer>, Void>(){

            @DoFn.ProcessElement
            public void verifyTimestampsEqualValue(DoFn.ProcessContext context) {
                Assert.assertThat((Object)new Instant(((Integer)((KV)context.element()).getValue()).longValue()), (Matcher)Matchers.equalTo((Object)context.timestamp()));
            }
        }));
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void globalWindowNoKeys() {
        PCollection result = (PCollection)((PCollection)this.pipeline.apply((PTransform)TestStream.create((Coder)StringUtf8Coder.of()).addElements(TimestampedValue.of((Object)"dei", (Instant)new Instant(123L)), new TimestampedValue[0]).advanceWatermarkToInfinity())).apply(Reify.windows());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new ValueInSingleWindow[]{ValueInSingleWindow.of((Object)"dei", (Instant)new Instant(123L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void timestampedValuesSucceeds() {
        PCollection timestamped = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"foo", (Object)0), (Object[])new KV[]{KV.of((Object)"foo", (Object)1), KV.of((Object)"bar", (Object)2), KV.of((Object)"baz", (Object)3)}))).apply(TIMESTAMP_FROM_V);
        PCollection reified = (PCollection)timestamped.apply(Reify.timestampsInValue());
        PAssert.that((PCollection)reified).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"foo", (Object)TimestampedValue.of((Object)0, (Instant)new Instant(0L))), KV.of((Object)"foo", (Object)TimestampedValue.of((Object)1, (Instant)new Instant(1L))), KV.of((Object)"bar", (Object)TimestampedValue.of((Object)2, (Instant)new Instant(2L))), KV.of((Object)"baz", (Object)TimestampedValue.of((Object)3, (Instant)new Instant(3L)))});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void timestampsSucceeds() {
        PCollection timestamped = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"foo", (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"bar", (Instant)new Instant(1L))}));
        PCollection reified = (PCollection)timestamped.apply(Reify.timestamps());
        PAssert.that((PCollection)reified).containsInAnyOrder((Object[])new TimestampedValue[]{TimestampedValue.of((Object)"foo", (Instant)new Instant(0L)), TimestampedValue.of((Object)"bar", (Instant)new Instant(1L))});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void windowsInValueSucceeds() {
        PCollection timestamped = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"foo", (Object)0), (Object[])new KV[]{KV.of((Object)"foo", (Object)1), KV.of((Object)"bar", (Object)2), KV.of((Object)"baz", (Object)3)}))).apply(TIMESTAMP_FROM_V);
        PCollection reified = (PCollection)timestamped.apply(Reify.windowsInValue());
        PAssert.that((PCollection)reified).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"foo", (Object)ValueInSingleWindow.of((Object)0, (Instant)new Instant(0L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)), KV.of((Object)"foo", (Object)ValueInSingleWindow.of((Object)1, (Instant)new Instant(1L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)), KV.of((Object)"bar", (Object)ValueInSingleWindow.of((Object)2, (Instant)new Instant(2L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)), KV.of((Object)"baz", (Object)ValueInSingleWindow.of((Object)3, (Instant)new Instant(3L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING))});
        this.pipeline.run();
    }
}

