/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Regex;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RegexTest
implements Serializable {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={NeedsRunner.class})
    public void testFind() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"aj", (Object[])new String[]{"xj", "yj", "zj"}))).apply((PTransform)Regex.find((String)"[xyz]"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"x", "y", "z"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFindGroup() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"aj", (Object[])new String[]{"xj", "yj", "zj"}))).apply((PTransform)Regex.find((String)"([xyz])", (int)1));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"x", "y", "z"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFindNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c", "d"}))).apply((PTransform)Regex.find((String)"[xyz]"));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFindNameGroup() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"aj", (Object[])new String[]{"xj", "yj", "zj"}))).apply((PTransform)Regex.find((String)"(?<namedgroup>[xyz])", (String)"namedgroup"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"x", "y", "z"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFindAllGroups() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"aj", (Object[])new String[]{"xjx", "yjy", "zjz"}))).apply((PTransform)Regex.findAll((String)"([xyz])j([xyz])"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new List[]{Arrays.asList("xjx", "x", "x"), Arrays.asList("yjy", "y", "y"), Arrays.asList("zjz", "z", "z")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFindNameNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c", "d"}))).apply((PTransform)Regex.find((String)"(?<namedgroup>[xyz])", (String)"namedgroup"));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVFind() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a b c", (Object[])new String[0]))).apply((PTransform)Regex.findKV((String)"a (b) (c)", (int)1, (int)2));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"b", (Object)"c")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVFindNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"x y z", (Object[])new String[0]))).apply((PTransform)Regex.findKV((String)"a (b) (c)", (int)1, (int)2));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVFindName() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a b c", (Object[])new String[0]))).apply((PTransform)Regex.findKV((String)"a (?<keyname>b) (?<valuename>c)", (String)"keyname", (String)"valuename"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"b", (Object)"c")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVFindNameNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"x y z", (Object[])new String[0]))).apply((PTransform)Regex.findKV((String)"a (?<keyname>b) (?<valuename>c)", (String)"keyname", (String)"valuename"));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatches() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"x", "y", "z"}))).apply((PTransform)Regex.matches((String)"[xyz]"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"x", "y", "z"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchesNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c", "d"}))).apply((PTransform)Regex.matches((String)"[xyz]"));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchesGroup() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"x xxx", "x yyy", "x zzz"}))).apply((PTransform)Regex.matches((String)"x ([xyz]*)", (int)1));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"xxx", "yyy", "zzz"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchesName() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"x xxx", "x yyy", "x zzz"}))).apply((PTransform)Regex.matches((String)"x (?<namedgroup>[xyz]*)", (String)"namedgroup"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"xxx", "yyy", "zzz"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchesNameNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c", "d"}))).apply((PTransform)Regex.matches((String)"x (?<namedgroup>[xyz]*)", (String)"namedgroup"));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testAllMatches() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a x", (Object[])new String[]{"x x", "y y", "z z"}))).apply((PTransform)Regex.allMatches((String)"([xyz]) ([xyz])"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new List[]{Arrays.asList("x x", "x", "x"), Arrays.asList("y y", "y", "y"), Arrays.asList("z z", "z", "z")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVMatches() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a b c", (Object[])new String[0]))).apply((PTransform)Regex.matchesKV((String)"a (b) (c)", (int)1, (int)2));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"b", (Object)"c")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVMatchesNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"x y z", (Object[])new String[0]))).apply((PTransform)Regex.matchesKV((String)"a (b) (c)", (int)1, (int)2));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVMatchesName() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"a b c", (Object[])new String[0]))).apply((PTransform)Regex.findKV((String)"a (?<keyname>b) (?<valuename>c)", (String)"keyname", (String)"valuename"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"b", (Object)"c")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testKVMatchesNameNone() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"x y z", (Object[])new String[0]))).apply((PTransform)Regex.findKV((String)"a (?<keyname>b) (?<valuename>c)", (String)"keyname", (String)"valuename"));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testReplaceAll() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"xj", (Object[])new String[]{"yj", "zj"}))).apply((PTransform)Regex.replaceAll((String)"[xyz]", (String)"new"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"newj", "newj", "newj"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testReplaceAllMixed() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"abc", (Object[])new String[]{"xj", "yj", "zj", "def"}))).apply((PTransform)Regex.replaceAll((String)"[xyz]", (String)"new"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"abc", "newj", "newj", "newj", "def"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testReplaceFirst() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"xjx", (Object[])new String[]{"yjy", "zjz"}))).apply((PTransform)Regex.replaceFirst((String)"[xyz]", (String)"new"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"newjx", "newjy", "newjz"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testReplaceFirstMixed() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"abc", (Object[])new String[]{"xjx", "yjy", "zjz", "def"}))).apply((PTransform)Regex.replaceFirst((String)"[xyz]", (String)"new"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"abc", "newjx", "newjy", "newjz", "def"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testSplits() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"The  quick   brown fox jumps over    the lazy dog", (Object[])new String[0]))).apply((PTransform)Regex.split((String)"\\W+"));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testSplitsWithEmpty() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"The  quick   brown fox jumps over    the lazy dog", (Object[])new String[0]))).apply((PTransform)Regex.split((String)"\\s", (boolean)true));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"The", "", "quick", "brown", "", "", "fox", "jumps", "over", "", "", "", "the", "lazy", "dog"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testSplitsWithoutEmpty() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"The  quick   brown fox jumps over    the lazy dog", (Object[])new String[0]))).apply((PTransform)Regex.split((String)"\\s", (boolean)false));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"});
        this.p.run();
    }
}

