/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartitionTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testEvenOddPartition() {
        PCollectionList outputs = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)591, (Object[])new Integer[]{11789, 1257, 24578, 24799, 307}))).apply((PTransform)Partition.of((int)2, (Partition.PartitionFn)new ModFn()));
        Assert.assertTrue((outputs.size() == 2 ? 1 : 0) != 0);
        PAssert.that((PCollection)outputs.get(0)).containsInAnyOrder((Object[])new Integer[]{24578});
        PAssert.that((PCollection)outputs.get(1)).containsInAnyOrder((Object[])new Integer[]{591, 11789, 1257, 24799, 307});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testModPartition() {
        PCollectionList outputs = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 4, 5}))).apply((PTransform)Partition.of((int)3, (Partition.PartitionFn)new ModFn()));
        Assert.assertTrue((outputs.size() == 3 ? 1 : 0) != 0);
        PAssert.that((PCollection)outputs.get(0)).empty();
        PAssert.that((PCollection)outputs.get(1)).containsInAnyOrder((Object[])new Integer[]{1, 4});
        PAssert.that((PCollection)outputs.get(2)).containsInAnyOrder((Object[])new Integer[]{2, 5});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testOutOfBoundsPartitions() {
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)-1, (Object[])new Integer[0]))).apply((PTransform)Partition.of((int)5, (Partition.PartitionFn)new IdentityFn()));
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Partition function returned out of bounds index: -1 not in [0..5)");
        this.pipeline.run();
    }

    @Test
    public void testZeroNumPartitions() {
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)591, (Object[])new Integer[0]));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("numPartitions must be > 0");
        input.apply((PTransform)Partition.of((int)0, (Partition.PartitionFn)new IdentityFn()));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDroppedPartition() {
        PCollectionList outputs = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)2, (Object[])new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12}))).apply((PTransform)Partition.of((int)3, (Partition.PartitionFn)new ModFn()));
        ArrayList outputsList = new ArrayList(outputs.getAll());
        outputsList.remove(0);
        outputs = PCollectionList.of(outputsList);
        Assert.assertTrue((outputs.size() == 2 ? 1 : 0) != 0);
        PCollection output = (PCollection)outputs.apply((PTransform)Flatten.pCollections());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 5, 7, 8, 10, 11});
        this.pipeline.run();
    }

    @Test
    public void testPartitionGetName() {
        Assert.assertEquals((Object)"Partition", (Object)Partition.of((int)3, (Partition.PartitionFn)new ModFn()).getName());
    }

    @Test
    public void testDisplayData() {
        Partition partition = Partition.of((int)123, (Partition.PartitionFn)new IdentityFn());
        DisplayData displayData = DisplayData.from((HasDisplayData)partition);
        MatcherAssert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("numPartitions", 123L));
        MatcherAssert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("partitionFn", IdentityFn.class));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testModPartitionWithLambda() {
        PCollectionList outputs = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 4, 5}))).apply((PTransform)Partition.of((int)3, (Partition.PartitionFn & Serializable)(element, numPartitions) -> element % numPartitions));
        Assert.assertEquals((long)3L, (long)outputs.size());
        PAssert.that((PCollection)outputs.get(0)).empty();
        PAssert.that((PCollection)outputs.get(1)).containsInAnyOrder((Object[])new Integer[]{1, 4});
        PAssert.that((PCollection)outputs.get(2)).containsInAnyOrder((Object[])new Integer[]{2, 5});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testPartitionFnOutputTypeDescriptorRaw() throws Exception {
        PCollectionList output = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)Partition.of((int)1, (Partition.PartitionFn & Serializable)(element, numPartitions) -> 0));
        this.thrown.expect(CannotProvideCoderException.class);
        this.pipeline.getCoderRegistry().getCoder(output.get(0).getTypeDescriptor());
    }

    static class IdentityFn
    implements Partition.PartitionFn<Integer> {
        IdentityFn() {
        }

        public int partitionFor(Integer elem, int numPartitions) {
            return elem;
        }
    }

    static class ModFn
    implements Partition.PartitionFn<Integer> {
        ModFn() {
        }

        public int partitionFor(Integer elem, int numPartitions) {
            return elem % numPartitions;
        }
    }
}

