/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.schemas.DefaultSchema;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesSchema;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ParDoSchemaTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testSimpleSchemaPipeline() {
        ArrayList<MyPojo> pojoList = Lists.newArrayList(new MyPojo("a", 1), new MyPojo("b", 2), new MyPojo("c", 3));
        Schema schema = Schema.builder().addStringField("string_field").addInt32Field("integer_field").build();
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList).withSchema(schema, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string_field"), r.getInt32("integer_field"))))).apply((PTransform)ParDo.of((DoFn)new DoFn<MyPojo, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString(0) + ":" + row.getInt32(1)));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testReadAndWrite() {
        ArrayList<MyPojo> pojoList = Lists.newArrayList(new MyPojo("a", 1), new MyPojo("b", 2), new MyPojo("c", 3));
        Schema schema1 = Schema.builder().addStringField("string_field").addInt32Field("integer_field").build();
        final Schema schema2 = Schema.builder().addStringField("string2_field").addInt32Field("integer2_field").build();
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList).withSchema(schema1, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema1).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string_field"), r.getInt32("integer_field"))))).apply("first", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, MyPojo>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> r) {
                r.output((Object)Row.withSchema((Schema)schema2).addValues(new Object[]{row.getString(0), row.getInt32(1)}).build());
            }
        }))).setSchema(schema2, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema2).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string2_field"), r.getInt32("integer2_field"))).apply("second", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString(0) + ":" + row.getInt32(1)));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testReadAndWriteMultiOutput() {
        ArrayList<MyPojo> pojoList = Lists.newArrayList(new MyPojo("a", 1), new MyPojo("b", 2), new MyPojo("c", 3));
        Schema schema1 = Schema.builder().addStringField("string_field").addInt32Field("integer_field").build();
        final Schema schema2 = Schema.builder().addStringField("string2_field").addInt32Field("integer2_field").build();
        final Schema schema3 = Schema.builder().addStringField("string3_field").addInt32Field("integer3_field").build();
        final TupleTag firstOutput = new TupleTag("first");
        final TupleTag secondOutput = new TupleTag("second");
        PCollectionTuple tuple = (PCollectionTuple)((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList).withSchema(schema1, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema1).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string_field"), r.getInt32("integer_field"))))).apply("first", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, MyPojo>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.MultiOutputReceiver r) {
                r.getRowReceiver(firstOutput).output((Object)Row.withSchema((Schema)schema2).addValues(new Object[]{row.getString(0), row.getInt32(1)}).build());
                r.getRowReceiver(secondOutput).output((Object)Row.withSchema((Schema)schema3).addValues(new Object[]{row.getString(0), row.getInt32(1)}).build());
            }
        }).withOutputTags(firstOutput, TupleTagList.of((TupleTag)secondOutput)));
        tuple.get(firstOutput).setSchema(schema2, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema2).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string2_field"), r.getInt32("integer2_field")));
        tuple.get(secondOutput).setSchema(schema3, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema3).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string3_field"), r.getInt32("integer3_field")));
        PCollection output1 = (PCollection)tuple.get(firstOutput).apply("second", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString("string2_field") + ":" + row.getInt32("integer2_field")));
            }
        }));
        PCollection output2 = (PCollection)tuple.get(secondOutput).apply("third", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString("string3_field") + ":" + row.getInt32("integer3_field")));
            }
        }));
        PAssert.that((PCollection)output1).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        PAssert.that((PCollection)output2).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testReadAndWriteWithSchemaRegistry() {
        final Schema schema = Schema.builder().addStringField("string_field").addInt32Field("integer_field").build();
        this.pipeline.getSchemaRegistry().registerSchemaForClass(MyPojo.class, schema, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string_field"), r.getInt32("integer_field")));
        ArrayList<MyPojo> pojoList = Lists.newArrayList(new MyPojo("a", 1), new MyPojo("b", 2), new MyPojo("c", 3));
        PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList))).apply("first", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, MyPojo>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> r) {
                r.output((Object)Row.withSchema((Schema)schema).addValues(new Object[]{row.getString(0), row.getInt32(1)}).build());
            }
        }))).apply("second", (PTransform)ParDo.of((DoFn)new DoFn<MyPojo, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString(0) + ":" + row.getInt32(1)));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testFieldAccessSchemaPipeline() {
        ArrayList<MyPojo> pojoList = Lists.newArrayList(new MyPojo("a", 1), new MyPojo("b", 2), new MyPojo("c", 3));
        Schema schema = Schema.builder().addStringField("string_field").addInt32Field("integer_field").build();
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList).withSchema(schema, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string_field"), r.getInt32("integer_field"))))).apply((PTransform)ParDo.of((DoFn)new DoFn<MyPojo, String>(){
            @DoFn.FieldAccess(value="foo")
            final FieldAccessDescriptor fieldAccess = FieldAccessDescriptor.withAllFields();

            @DoFn.ProcessElement
            public void process(@DoFn.FieldAccess(value="foo") Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString(0) + ":" + row.getInt32(1)));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testNoSchema() {
        this.thrown.expect(IllegalArgumentException.class);
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c"}))).apply((PTransform)ParDo.of((DoFn)new DoFn<String, Void>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row) {
            }
        }));
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testUnmatchedSchema() {
        ArrayList<MyPojo> pojoList = Lists.newArrayList(new MyPojo("a", 1), new MyPojo("b", 2), new MyPojo("c", 3));
        Schema schema = Schema.builder().addStringField("string_field").addInt32Field("integer_field").build();
        this.thrown.expect(IllegalArgumentException.class);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList).withSchema(schema, (SerializableFunction & Serializable)o -> Row.withSchema((Schema)schema).addValues(new Object[]{o.stringField, o.integerField}).build(), (SerializableFunction & Serializable)r -> new MyPojo(r.getString("string_field"), r.getInt32("integer_field"))))).apply((PTransform)ParDo.of((DoFn)new DoFn<MyPojo, Void>(){
            @DoFn.FieldAccess(value="a")
            FieldAccessDescriptor fieldAccess = FieldAccessDescriptor.withFieldNames((String[])new String[]{"baad"});

            @DoFn.ProcessElement
            public void process(@DoFn.FieldAccess(value="a") Row row) {
            }
        }));
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesSchema.class})
    public void testInferredSchemaPipeline() {
        ArrayList<InferredPojo> pojoList = Lists.newArrayList(new InferredPojo("a", 1), new InferredPojo("b", 2), new InferredPojo("c", 3));
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(pojoList))).apply((PTransform)ParDo.of((DoFn)new DoFn<InferredPojo, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, DoFn.OutputReceiver<String> r) {
                r.output((Object)(row.getString(0) + ":" + row.getInt32(1)));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.pipeline.run();
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class InferredPojo {
        public String stringField;
        public Integer integerField;

        public InferredPojo(String stringField, Integer integerField) {
            this.stringField = stringField;
            this.integerField = integerField;
        }

        public InferredPojo() {
        }
    }

    static class MyPojo
    implements Serializable {
        String stringField;
        Integer integerField;

        MyPojo(String stringField, Integer integerField) {
            this.stringField = stringField;
            this.integerField = integerField;
        }
    }
}

