/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Comparator;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MinTest {
    @Test
    public void testMinGetNames() {
        Assert.assertEquals((Object)"Combine.globally(MinInteger)", (Object)Min.integersGlobally().getName());
        Assert.assertEquals((Object)"Combine.globally(MinDouble)", (Object)Min.doublesGlobally().getName());
        Assert.assertEquals((Object)"Combine.globally(MinLong)", (Object)Min.longsGlobally().getName());
        Assert.assertEquals((Object)"Combine.perKey(MinInteger)", (Object)Min.integersPerKey().getName());
        Assert.assertEquals((Object)"Combine.perKey(MinDouble)", (Object)Min.doublesPerKey().getName());
        Assert.assertEquals((Object)"Combine.perKey(MinLong)", (Object)Min.longsPerKey().getName());
    }

    @Test
    public void testMinIntegerFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Min.ofIntegers(), Lists.newArrayList(1, 2, 3, 4), (Object)1);
    }

    @Test
    public void testMinLongFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Min.ofLongs(), Lists.newArrayList(1L, 2L, 3L, 4L), (Object)1L);
    }

    @Test
    public void testMinDoubleFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Min.ofDoubles(), Lists.newArrayList(1.0, 2.0, 3.0, 4.0), (Object)1.0);
    }

    @Test
    public void testDisplayData() {
        Top.Reversed comparer = new Top.Reversed();
        Combine.Globally min = Min.globally((Comparator)comparer);
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)min), DisplayDataMatchers.hasDisplayItem("comparer", comparer.getClass()));
    }
}

