/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Mean;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MeanTest {
    private static final Coder<Mean.CountSum<Number>> TEST_CODER = new Mean.CountSumCoder();
    private static final List<Mean.CountSum<Number>> TEST_VALUES = Arrays.asList(new Mean.CountSum(1L, 5.7), new Mean.CountSum(42L, 42.0), new Mean.CountSum(29L, 2.2));

    @Test
    public void testMeanGetNames() {
        Assert.assertEquals((Object)"Combine.globally(Mean)", (Object)Mean.globally().getName());
        Assert.assertEquals((Object)"Combine.perKey(Mean)", (Object)Mean.perKey().getName());
    }

    @Test
    public void testCountSumCoderEncodeDecode() throws Exception {
        for (Mean.CountSum<Number> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, value);
        }
    }

    @Test
    public void testCountSumCoderSerializable() throws Exception {
        CoderProperties.coderSerializable(TEST_CODER);
    }

    @Test
    public void testMeanFn() throws Exception {
        CombineFnTester.testCombineFn((Combine.CombineFn)Mean.of(), Lists.newArrayList(1, 2, 3, 4), (Object)2.5);
    }
}

