/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Comparator;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MaxTest {
    @Test
    public void testMaxGetNames() {
        Assert.assertEquals((Object)"Combine.globally(MaxInteger)", (Object)Max.integersGlobally().getName());
        Assert.assertEquals((Object)"Combine.globally(MaxDouble)", (Object)Max.doublesGlobally().getName());
        Assert.assertEquals((Object)"Combine.globally(MaxLong)", (Object)Max.longsGlobally().getName());
        Assert.assertEquals((Object)"Combine.perKey(MaxInteger)", (Object)Max.integersPerKey().getName());
        Assert.assertEquals((Object)"Combine.perKey(MaxDouble)", (Object)Max.doublesPerKey().getName());
        Assert.assertEquals((Object)"Combine.perKey(MaxLong)", (Object)Max.longsPerKey().getName());
    }

    @Test
    public void testMaxIntegerFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Max.ofIntegers(), Lists.newArrayList(1, 2, 3, 4), (Object)4);
    }

    @Test
    public void testMaxLongFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Max.ofLongs(), Lists.newArrayList(1L, 2L, 3L, 4L), (Object)4L);
    }

    @Test
    public void testMaxDoubleFn() {
        CombineFnTester.testCombineFn((Combine.CombineFn)Max.ofDoubles(), Lists.newArrayList(1.0, 2.0, 3.0, 4.0), (Object)4.0);
    }

    @Test
    public void testDisplayData() {
        Top.Natural comparer = new Top.Natural();
        Combine.Globally max = Max.globally((Comparator)comparer);
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)max), DisplayDataMatchers.hasDisplayItem("comparer", comparer.getClass()));
    }
}

