/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Set;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MapElementsTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapBasic() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Integer, Integer>(){

            public Integer apply(Integer input) {
                return -input.intValue();
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{-2, -1, -3});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapBasicWithSideInput() throws Exception {
        PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("Create base", (PTransform)Create.of((Object)40, (Object[])new Integer[0]))).apply((PTransform)View.asSingleton());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)0, (Object[])new Integer[]{1, 2}))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.integers()).via(Contextful.fn((Contextful.Fn & Serializable)(element, c) -> element + (Integer)c.sideInput(view), (Requirements)Requirements.requiresSideInputs((PCollectionView[])new PCollectionView[]{view}))));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{40, 41, 42});
        this.pipeline.run();
    }

    @Test
    public void testPolymorphicSimpleFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply("Polymorphic Identity", (PTransform)MapElements.via(new PolymorphicSimpleFunction()))).apply("Test Consumer", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        }));
    }

    @Test
    public void testNestedPolymorphicSimpleFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply("Polymorphic Identity", (PTransform)MapElements.via(new NestedPolymorphicSimpleFunction()))).apply("Test Consumer", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<Integer, String>, Integer>(){

            public Integer apply(KV<Integer, String> input) {
                return 42;
            }
        }));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapBasicSerializableFunction() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.integers()).via((SerializableFunction & Serializable)input -> -input.intValue()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{-2, -1, -3});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testSimpleFunctionOutputTypeDescriptor() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

            public String apply(String input) {
                return input;
            }
        }));
        Assert.assertThat((Object)output.getTypeDescriptor(), (Matcher)Matchers.equalTo((Object)new TypeDescriptor<String>(){}));
        Assert.assertThat((Object)this.pipeline.getCoderRegistry().getCoder(output.getTypeDescriptor()), (Matcher)Matchers.equalTo((Object)this.pipeline.getCoderRegistry().getCoder((TypeDescriptor)new TypeDescriptor<String>(){})));
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testVoidValues() throws Exception {
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)WithKeys.of((Object)"k"))).apply((PTransform)new VoidValues<String, String>(){});
        this.pipeline.run();
    }

    @Test
    public void testSerializableFunctionDisplayData() {
        SerializableFunction & Serializable serializableFn = (SerializableFunction & Serializable)input -> input;
        MapElements serializableMap = MapElements.into((TypeDescriptor)TypeDescriptors.integers()).via((SerializableFunction)serializableFn);
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)serializableMap), DisplayDataMatchers.hasDisplayItem("class", serializableFn.getClass()));
    }

    @Test
    public void testSimpleFunctionClassDisplayData() {
        SimpleFunction<Integer, Integer> simpleFn = new SimpleFunction<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        };
        MapElements simpleMap = MapElements.via((SimpleFunction)simpleFn);
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)simpleMap), DisplayDataMatchers.hasDisplayItem("class", simpleFn.getClass()));
    }

    @Test
    public void testSimpleFunctionDisplayData() {
        SimpleFunction<Integer, Integer> simpleFn = new SimpleFunction<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"baz"));
            }
        };
        MapElements simpleMap = MapElements.via((SimpleFunction)simpleFn);
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)simpleMap), DisplayDataMatchers.hasDisplayItem("class", simpleFn.getClass()));
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)simpleMap), DisplayDataMatchers.hasDisplayItem("foo", "baz"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testPrimitiveDisplayData() {
        SimpleFunction<Integer, Integer> mapFn = new SimpleFunction<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        };
        MapElements map = MapElements.via((SimpleFunction)mapFn);
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        Set<DisplayData> displayData = evaluator.displayDataForPrimitiveTransforms(map);
        Assert.assertThat((String)"MapElements should include the mapFn in its primitive display data", displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("class", mapFn.getClass())));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapLambda() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.integers()).via((SerializableFunction & Serializable)i -> i * 2));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{6, 2, 4});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapWrappedLambda() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Integer, Integer>((SerializableFunction & Serializable)i -> i * 2){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{6, 2, 4});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMapMethodReference() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.integers()).via(new Doubler()::doubleIt));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{6, 2, 4});
        this.pipeline.run();
    }

    private static class Doubler
    implements Serializable {
        private Doubler() {
        }

        public int doubleIt(int val) {
            return val * 2;
        }
    }

    static class VoidValues<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Void>>> {
        VoidValues() {
        }

        public PCollection<KV<K, Void>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<K, V>, KV<K, Void>>(){

                public KV<K, Void> apply(KV<K, V> input) {
                    return KV.of((Object)input.getKey(), null);
                }
            }));
        }
    }

    private static class NestedPolymorphicSimpleFunction<T>
    extends SimpleFunction<T, KV<T, String>> {
        private NestedPolymorphicSimpleFunction() {
        }

        public KV<T, String> apply(T input) {
            return KV.of(input, (Object)"hello");
        }
    }

    private static class PolymorphicSimpleFunction<T>
    extends SimpleFunction<T, T> {
        private PolymorphicSimpleFunction() {
        }

        public T apply(T input) {
            return input;
        }
    }
}

