/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Latest;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LatestTest
implements Serializable {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private static final AtomicLong uniqueLong = new AtomicLong();

    @Test
    @Category(value={NeedsRunner.class})
    public void testGloballyEventTimestamp() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"foo", (Instant)new Instant(100L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"bar", (Instant)new Instant(300L)), TimestampedValue.of((Object)"baz", (Instant)new Instant(200L))}))).apply(Latest.globally());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"bar"});
        this.p.run();
    }

    @Test
    public void testGloballyOutputCoder() {
        this.p.enableAbandonedNodeEnforcement(false);
        BigEndianLongCoder inputCoder = BigEndianLongCoder.of();
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1L, (Object[])new Long[]{2L}).withCoder((Coder)inputCoder))).apply(Latest.globally());
        Coder outputCoder = output.getCoder();
        MatcherAssert.assertThat((Object)outputCoder, (Matcher)Matchers.instanceOf(NullableCoder.class));
        Assert.assertEquals((Object)inputCoder, (Object)((NullableCoder)outputCoder).getValueCoder());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testGloballyEmptyCollection() {
        PCollection emptyInput = (PCollection)this.p.apply((PTransform)Create.empty((Coder)VarLongCoder.of()));
        PCollection output = (PCollection)emptyInput.apply(Latest.globally());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Long[]{null});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testPerKeyEventTimestamp() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"A", (Object)"foo"), (Instant)new Instant(100L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"B", (Object)"bar"), (Instant)new Instant(300L)), TimestampedValue.of((Object)KV.of((Object)"A", (Object)"baz"), (Instant)new Instant(200L))}))).apply(Latest.perKey());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"B", (Object)"bar"), KV.of((Object)"A", (Object)"baz")});
        this.p.run();
    }

    @Test
    public void testPerKeyOutputCoder() {
        this.p.enableAbandonedNodeEnforcement(false);
        KvCoder inputCoder = KvCoder.of((Coder)AvroCoder.of(String.class), (Coder)AvroCoder.of(Long.class));
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)"foo", (Object)1L), (Object[])new KV[0]).withCoder((Coder)inputCoder))).apply(Latest.perKey());
        Assert.assertEquals((String)"Should use input coder for outputs", (Object)inputCoder, (Object)output.getCoder());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testPerKeyEmptyCollection() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.empty((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())))).apply(Latest.perKey());
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    private static TimestampedValue<Long> timestamped(Instant timestamp) {
        return TimestampedValue.of((Object)uniqueLong.incrementAndGet(), (Instant)timestamp);
    }
}

