/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.Latest;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LatestFnTest {
    private static final Instant INSTANT = new Instant(100L);
    private static final long VALUE = 100L * INSTANT.getMillis();
    private static final TimestampedValue<Long> TV = TimestampedValue.of((Object)VALUE, (Instant)INSTANT);
    private static final TimestampedValue<Long> TV_MINUS_TEN = TimestampedValue.of((Object)(VALUE - 10L), (Instant)INSTANT.minus(10L));
    private static final TimestampedValue<Long> TV_PLUS_TEN = TimestampedValue.of((Object)(VALUE + 10L), (Instant)INSTANT.plus(10L));
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final Latest.LatestFn<Long> fn = new Latest.LatestFn();
    private final Instant baseTimestamp = Instant.now();

    @Test
    public void testDefaultValue() {
        MatcherAssert.assertThat((Object)((Long)this.fn.defaultValue()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCreateAccumulator() {
        Assert.assertEquals((Object)TimestampedValue.atMinimumTimestamp(null), (Object)this.fn.createAccumulator());
    }

    @Test
    public void testAddInputInitialAdd() {
        TimestampedValue<Long> input = TV;
        Assert.assertEquals(input, (Object)this.fn.addInput(this.fn.createAccumulator(), input));
    }

    @Test
    public void testAddInputMinTimestamp() {
        TimestampedValue input = TimestampedValue.atMinimumTimestamp((Object)1234L);
        Assert.assertEquals((Object)input, (Object)this.fn.addInput(this.fn.createAccumulator(), input));
    }

    @Test
    public void testAddInputEarlierValue() {
        Assert.assertEquals(TV, (Object)this.fn.addInput(TV, TV_MINUS_TEN));
    }

    @Test
    public void testAddInputLaterValue() {
        Assert.assertEquals(TV_PLUS_TEN, (Object)this.fn.addInput(TV, TV_PLUS_TEN));
    }

    @Test
    public void testAddInputSameTimestamp() {
        TimestampedValue accum = TimestampedValue.of((Object)100L, (Instant)INSTANT);
        TimestampedValue input = TimestampedValue.of((Object)200L, (Instant)INSTANT);
        MatcherAssert.assertThat((String)"Latest for values with the same timestamp is chosen arbitrarily", (Object)this.fn.addInput(accum, input), (Matcher)Matchers.isOneOf((Object[])new TimestampedValue[]{accum, input}));
    }

    @Test
    public void testAddInputNullAccumulator() {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("accumulator");
        this.fn.addInput(null, TV);
    }

    @Test
    public void testAddInputNullInput() {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("input");
        this.fn.addInput(TV, null);
    }

    @Test
    public void testAddInputNullValue() {
        TimestampedValue input = TimestampedValue.of(null, (Instant)INSTANT.plus(10L));
        Assert.assertEquals((String)"Null values are allowed", (Object)input, (Object)this.fn.addInput(TV, input));
    }

    @Test
    public void testMergeAccumulatorsMultipleValues() {
        ArrayList<TimestampedValue> accums = Lists.newArrayList(TV, TV_PLUS_TEN, TV_MINUS_TEN);
        Assert.assertEquals(TV_PLUS_TEN, (Object)this.fn.mergeAccumulators(accums));
    }

    @Test
    public void testMergeAccumulatorsSingleValue() {
        Assert.assertEquals(TV, (Object)this.fn.mergeAccumulators(Lists.newArrayList(TV)));
    }

    @Test
    public void testMergeAccumulatorsEmptyIterable() {
        ArrayList emptyAccums = Lists.newArrayList();
        Assert.assertEquals((Object)TimestampedValue.atMinimumTimestamp(null), (Object)this.fn.mergeAccumulators(emptyAccums));
    }

    @Test
    public void testMergeAccumulatorsDefaultAccumulator() {
        TimestampedValue defaultAccum = this.fn.createAccumulator();
        Assert.assertEquals(TV, (Object)this.fn.mergeAccumulators(Lists.newArrayList(TV, defaultAccum)));
    }

    @Test
    public void testMergeAccumulatorsAllDefaultAccumulators() {
        TimestampedValue defaultAccum = this.fn.createAccumulator();
        Assert.assertEquals((Object)defaultAccum, (Object)this.fn.mergeAccumulators(Lists.newArrayList(defaultAccum, defaultAccum)));
    }

    @Test
    public void testMergeAccumulatorsNullIterable() {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("accumulators");
        this.fn.mergeAccumulators(null);
    }

    @Test
    public void testExtractOutput() {
        Assert.assertEquals((Object)TV.getValue(), (Object)this.fn.extractOutput(TV));
    }

    @Test
    public void testExtractOutputDefaultAccumulator() {
        TimestampedValue accum = this.fn.createAccumulator();
        MatcherAssert.assertThat((Object)((Long)this.fn.extractOutput(accum)), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testExtractOutputNullValue() {
        TimestampedValue accum = TimestampedValue.of(null, (Instant)this.baseTimestamp);
        Assert.assertEquals(null, (Object)this.fn.extractOutput(accum));
    }

    @Test
    public void testDefaultCoderHandlesNull() throws CannotProvideCoderException {
        Latest.LatestFn fn = new Latest.LatestFn();
        CoderRegistry registry = CoderRegistry.createDefault();
        TimestampedValue.TimestampedValueCoder inputCoder = TimestampedValue.TimestampedValueCoder.of((Coder)VarLongCoder.of());
        MatcherAssert.assertThat((String)"Default output coder should handle null values", (Object)fn.getDefaultOutputCoder(registry, (Coder)inputCoder), (Matcher)Matchers.instanceOf(NullableCoder.class));
        MatcherAssert.assertThat((String)"Default accumulator coder should handle null values", (Object)fn.getAccumulatorCoder(registry, (Coder)inputCoder), (Matcher)Matchers.instanceOf(NullableCoder.class));
    }
}

