/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Arrays;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KeysTest {
    static final KV<String, Integer>[] TABLE = new KV[]{KV.of((Object)"one", (Object)1), KV.of((Object)"two", (Object)2), KV.of((Object)"three", (Object)3), KV.of((Object)"dup", (Object)4), KV.of((Object)"dup", (Object)5)};
    static final KV<String, Integer>[] EMPTY_TABLE = new KV[0];
    @Rule
    public final TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testKeys() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(TABLE)).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Keys.create());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"one", "two", "three", "dup", "dup"});
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testKeysEmpty() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(Arrays.asList(EMPTY_TABLE)).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Keys.create());
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }
}

