/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.JsonToRow;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JsonToRowTest
implements Serializable {
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Test
    @Category(value={NeedsRunner.class})
    public void testParsesRows() throws Exception {
        Schema personSchema = Schema.builder().addStringField("name").addInt32Field("height").addBooleanField("knowsJavascript").build();
        PCollection jsonPersons = (PCollection)this.pipeline.apply("jsonPersons", (PTransform)Create.of((Object)this.jsonPerson("person1", "80", "true"), (Object[])new String[]{this.jsonPerson("person2", "70", "false"), this.jsonPerson("person3", "60", "true"), this.jsonPerson("person4", "50", "false"), this.jsonPerson("person5", "40", "true")}));
        PCollection personRows = ((PCollection)jsonPersons.apply(JsonToRow.withSchema((Schema)personSchema))).setCoder((Coder)personSchema.getRowCoder());
        PAssert.that((PCollection)personRows).containsInAnyOrder((Object[])new Row[]{this.row(personSchema, "person1", 80, true), this.row(personSchema, "person2", 70, false), this.row(personSchema, "person3", 60, true), this.row(personSchema, "person4", 50, false), this.row(personSchema, "person5", 40, true)});
        this.pipeline.run();
    }

    private String jsonPerson(String name, String height, String knowsJs) {
        return "{\n  \"name\": \"" + name + "\",\n  \"height\": " + height + ",\n  \"knowsJavascript\": " + knowsJs + "\n}";
    }

    private Row row(Schema schema, Object ... values) {
        return Row.withSchema((Schema)schema).addValues(values).build();
    }
}

