/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.testing.FlattenWithHeterogeneousCoders;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FlattenTest
implements Serializable {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenPCollections() {
        List inputs = Arrays.asList(TestUtils.LINES, TestUtils.NO_LINES, TestUtils.LINES2, TestUtils.NO_LINES, TestUtils.LINES, TestUtils.NO_LINES);
        PCollection output = (PCollection)this.makePCollectionListOfStrings((Pipeline)this.p, inputs).apply((PTransform)Flatten.pCollections());
        PAssert.that((PCollection)output).containsInAnyOrder(this.flattenLists(inputs));
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenPCollectionsSingletonList() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.LINES));
        PCollection output = (PCollection)PCollectionList.of((PCollection)input).apply((PTransform)Flatten.pCollections());
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)input)));
        PAssert.that((PCollection)output).containsInAnyOrder(TestUtils.LINES);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenPCollectionsThenParDo() {
        List inputs = Arrays.asList(TestUtils.LINES, TestUtils.NO_LINES, TestUtils.LINES2, TestUtils.NO_LINES, TestUtils.LINES, TestUtils.NO_LINES);
        PCollection output = (PCollection)((PCollection)this.makePCollectionListOfStrings((Pipeline)this.p, inputs).apply((PTransform)Flatten.pCollections())).apply((PTransform)ParDo.of(new IdentityFn()));
        PAssert.that((PCollection)output).containsInAnyOrder(this.flattenLists(inputs));
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenPCollectionsEmpty() {
        PCollection output = ((PCollection)PCollectionList.empty((Pipeline)this.p).apply((PTransform)Flatten.pCollections())).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenInputMultipleCopies() {
        int count = 5;
        PCollection longs = (PCollection)this.p.apply("mkLines", (PTransform)GenerateSequence.from((long)0L).to((long)count));
        PCollection biggerLongs = (PCollection)((PCollection)this.p.apply("mkOtherLines", (PTransform)GenerateSequence.from((long)0L).to((long)count))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Long, Long>(){

            public Long apply(Long input) {
                return input + 10L;
            }
        }));
        PCollection flattened = (PCollection)PCollectionList.of((PCollection)longs).and(longs).and(biggerLongs).apply((PTransform)Flatten.pCollections());
        ArrayList<Long> expectedLongs = new ArrayList<Long>();
        for (int i = 0; i < count; ++i) {
            expectedLongs.add(Long.valueOf(i));
            expectedLongs.add(Long.valueOf(i));
            expectedLongs.add((long)i + 10L);
        }
        PAssert.that((PCollection)flattened).containsInAnyOrder(expectedLongs);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, FlattenWithHeterogeneousCoders.class})
    public void testFlattenMultipleCoders() throws CannotProvideCoderException {
        PCollection bigEndianLongs = (PCollection)this.p.apply("BigEndianLongs", (PTransform)Create.of((Object)0L, (Object[])new Long[]{1L, 2L, 3L, null, 4L, 5L, null, 6L, 7L, 8L, null, 9L}).withCoder((Coder)NullableCoder.of((Coder)BigEndianLongCoder.of())));
        PCollection varLongs = ((PCollection)this.p.apply("VarLengthLongs", (PTransform)GenerateSequence.from((long)0L).to(5L))).setCoder((Coder)VarLongCoder.of());
        PCollection flattened = ((PCollection)PCollectionList.of((PCollection)bigEndianLongs).and(varLongs).apply((PTransform)Flatten.pCollections())).setCoder((Coder)NullableCoder.of((Coder)VarLongCoder.of()));
        PAssert.that((PCollection)flattened).containsInAnyOrder((Object[])new Long[]{0L, 0L, 1L, 1L, 2L, 3L, 2L, 4L, 5L, 3L, 6L, 7L, 4L, 8L, 9L, null, null, null});
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyFlattenAsSideInput() {
        final PCollectionView view = (PCollectionView)((PCollection)PCollectionList.empty((Pipeline)this.p).apply((PTransform)Flatten.pCollections())).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)View.asIterable());
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]).withCoder((Coder)VoidCoder.of()))).apply((PTransform)ParDo.of((DoFn)new DoFn<Void, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (String side : (Iterable)c.sideInput(view)) {
                    c.output((Object)side);
                }
            }
        }).withSideInputs(new PCollectionView[]{view}));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenPCollectionsEmptyThenParDo() {
        PCollection output = (PCollection)((PCollection)PCollectionList.empty((Pipeline)this.p).apply((PTransform)Flatten.pCollections())).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)ParDo.of(new IdentityFn()));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFlattenNoListsNoCoder() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to return a default Coder");
        PCollectionList.empty((Pipeline)this.p).apply((PTransform)Flatten.pCollections());
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenIterables() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.LINES, (Object[])new Iterable[0]).withCoder((Coder)IterableCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Flatten.iterables());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.LINES_ARRAY);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenIterablesLists() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.LINES, (Object[])new List[0]).withCoder((Coder)ListCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Flatten.iterables());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.LINES_ARRAY);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenIterablesSets() {
        ImmutableSet<String> linesSet = ImmutableSet.copyOf(TestUtils.LINES);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(linesSet, (Object[])new Set[0]).withCoder((Coder)SetCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Flatten.iterables());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.LINES_ARRAY);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenIterablesCollections() {
        ImmutableSet<String> linesSet = ImmutableSet.copyOf(TestUtils.LINES);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(linesSet, (Object[])new Collection[0]).withCoder((Coder)CollectionCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Flatten.iterables());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.LINES_ARRAY);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenIterablesEmpty() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.NO_LINES, (Object[])new Iterable[0]).withCoder((Coder)IterableCoder.of((Coder)StringUtf8Coder.of())));
        PCollection output = (PCollection)input.apply((PTransform)Flatten.iterables());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.NO_LINES_ARRAY);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFlattenMultiplePCollectionsHavingMultipleConsumers() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of((Object)"AA", (Object[])new String[]{"BBB", "CC"}));
        TupleTag<String> outputEvenLengthTag = new TupleTag<String>(){};
        TupleTag<String> outputOddLengthTag = new TupleTag<String>(){};
        PCollectionTuple tuple = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>((TupleTag)outputOddLengthTag){
            final /* synthetic */ TupleTag val$outputOddLengthTag;
            {
                this.val$outputOddLengthTag = tupleTag;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                if (((String)c.element()).length() % 2 == 0) {
                    c.output((Object)((String)c.element()));
                } else {
                    c.output(this.val$outputOddLengthTag, (Object)((String)c.element()));
                }
            }
        }).withOutputTags((TupleTag)outputEvenLengthTag, TupleTagList.of((TupleTag)outputOddLengthTag)));
        PCollection outputEvenLength = tuple.get((TupleTag)outputEvenLengthTag);
        PCollection outputOddLength = tuple.get((TupleTag)outputOddLengthTag);
        PCollection outputMerged = (PCollection)PCollectionList.of((PCollection)outputEvenLength).and(outputOddLength).apply((PTransform)Flatten.pCollections());
        PAssert.that((PCollection)outputMerged).containsInAnyOrder((Object[])new String[]{"AA", "BBB", "CC"});
        PAssert.that((PCollection)outputEvenLength).containsInAnyOrder((Object[])new String[]{"AA", "CC"});
        PAssert.that((PCollection)outputOddLength).containsInAnyOrder((Object[])new String[]{"BBB"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testEqualWindowFnPropagation() {
        PCollection input1 = (PCollection)((PCollection)this.p.apply("CreateInput1", (PTransform)Create.of((Object)"Input1", (Object[])new String[0]))).apply("Window1", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        PCollection input2 = (PCollection)((PCollection)this.p.apply("CreateInput2", (PTransform)Create.of((Object)"Input2", (Object[])new String[0]))).apply("Window2", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        PCollection output = (PCollection)PCollectionList.of((PCollection)input1).and(input2).apply((PTransform)Flatten.pCollections());
        this.p.run();
        Assert.assertTrue((boolean)output.getWindowingStrategy().getWindowFn().isCompatible((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCompatibleWindowFnPropagation() {
        PCollection input1 = (PCollection)((PCollection)this.p.apply("CreateInput1", (PTransform)Create.of((Object)"Input1", (Object[])new String[0]))).apply("Window1", (PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.standardMinutes((long)1L))));
        PCollection input2 = (PCollection)((PCollection)this.p.apply("CreateInput2", (PTransform)Create.of((Object)"Input2", (Object[])new String[0]))).apply("Window2", (PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.standardMinutes((long)2L))));
        PCollection output = (PCollection)PCollectionList.of((PCollection)input1).and(input2).apply((PTransform)Flatten.pCollections());
        this.p.run();
        Assert.assertTrue((boolean)output.getWindowingStrategy().getWindowFn().isCompatible((WindowFn)Sessions.withGapDuration((Duration)Duration.standardMinutes((long)2L))));
    }

    @Test
    public void testIncompatibleWindowFnPropagationFailure() {
        this.p.enableAbandonedNodeEnforcement(false);
        PCollection input1 = (PCollection)((PCollection)this.p.apply("CreateInput1", (PTransform)Create.of((Object)"Input1", (Object[])new String[0]))).apply("Window1", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        PCollection input2 = (PCollection)((PCollection)this.p.apply("CreateInput2", (PTransform)Create.of((Object)"Input2", (Object[])new String[0]))).apply("Window2", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)2L))));
        try {
            PCollectionList.of((PCollection)input1).and(input2).apply((PTransform)Flatten.pCollections());
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Inputs to Flatten had incompatible window windowFns"));
        }
    }

    @Test
    public void testFlattenGetName() {
        Assert.assertEquals((Object)"Flatten.Iterables", (Object)Flatten.iterables().getName());
        Assert.assertEquals((Object)"Flatten.PCollections", (Object)Flatten.pCollections().getName());
    }

    private PCollectionList<String> makePCollectionListOfStrings(Pipeline p, List<List<String>> lists) {
        return this.makePCollectionList(p, (Coder)StringUtf8Coder.of(), lists);
    }

    private <T> PCollectionList<T> makePCollectionList(Pipeline p, Coder<T> coder, List<List<T>> lists) {
        ArrayList<PCollection> pcs = new ArrayList<PCollection>();
        int index = 0;
        for (List<T> list : lists) {
            PCollection pc = (PCollection)p.apply("Create" + index++, (PTransform)Create.of(list).withCoder(coder));
            pcs.add(pc);
        }
        return PCollectionList.of(pcs);
    }

    private <T> List<T> flattenLists(List<List<T>> lists) {
        ArrayList<T> flattened = new ArrayList<T>();
        for (List<T> list : lists) {
            flattened.addAll(list);
        }
        return flattened;
    }

    private static class IdentityFn<T>
    extends DoFn<T, T> {
        private IdentityFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(c.element());
        }
    }

    private static class ClassWithoutCoder {
        private ClassWithoutCoder() {
        }
    }
}

