/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FlatMapElementsTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testFlatMapBasic() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)FlatMapElements.via((SimpleFunction)new SimpleFunction<Integer, List<Integer>>(){

            public List<Integer> apply(Integer input) {
                return ImmutableList.of(Integer.valueOf(-input.intValue()), input);
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, -2, -1, -3, 2, 3});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFlatMapBasicWithSideInput() throws Exception {
        PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("Create base", (PTransform)Create.of((Object)40, (Object[])new Integer[0]))).apply((PTransform)View.asSingleton());
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)0, (Object[])new Integer[]{1, 2}))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.integers()).via(Contextful.fn((Contextful.Fn & Serializable)(input, c) -> ImmutableList.of(Integer.valueOf((Integer)c.sideInput(view) - input), Integer.valueOf((Integer)c.sideInput(view) + input)), (Requirements)Requirements.requiresSideInputs((PCollectionView[])new PCollectionView[]{view}))));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{38, 39, 40, 40, 41, 42});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFlatMapFnOutputTypeDescriptor() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)FlatMapElements.via((SimpleFunction)new SimpleFunction<String, Set<String>>(){

            public Set<String> apply(String input) {
                return ImmutableSet.copyOf(input.split(""));
            }
        }));
        Assert.assertThat((Object)output.getTypeDescriptor(), (Matcher)Matchers.equalTo((Object)new TypeDescriptor<String>(){}));
        Assert.assertThat((Object)this.pipeline.getCoderRegistry().getCoder(output.getTypeDescriptor()), (Matcher)Matchers.equalTo((Object)this.pipeline.getCoderRegistry().getCoder((TypeDescriptor)new TypeDescriptor<String>(){})));
        this.pipeline.run();
    }

    @Test
    public void testPolymorphicSimpleFunction() throws Exception {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply("Polymorphic Identity", (PTransform)MapElements.via(new PolymorphicSimpleFunction()))).apply("Test Consumer", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Iterable<Integer>, Integer>(){

            public Integer apply(Iterable<Integer> input) {
                return 42;
            }
        }));
    }

    @Test
    public void testSimpleFunctionClassDisplayData() {
        SimpleFunction<Integer, List<Integer>> simpleFn = new SimpleFunction<Integer, List<Integer>>(){

            public List<Integer> apply(Integer input) {
                return Collections.emptyList();
            }
        };
        FlatMapElements simpleMap = FlatMapElements.via((SimpleFunction)simpleFn);
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)simpleMap), DisplayDataMatchers.hasDisplayItem("class", simpleFn.getClass()));
    }

    @Test
    public void testSimpleFunctionDisplayData() {
        SimpleFunction<Integer, List<Integer>> simpleFn = new SimpleFunction<Integer, List<Integer>>(){

            public List<Integer> apply(Integer input) {
                return Collections.emptyList();
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"baz"));
            }
        };
        FlatMapElements simpleFlatMap = FlatMapElements.via((SimpleFunction)simpleFn);
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)simpleFlatMap), DisplayDataMatchers.hasDisplayItem("class", simpleFn.getClass()));
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)simpleFlatMap), DisplayDataMatchers.hasDisplayItem("foo", "baz"));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testVoidValues() throws Exception {
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)WithKeys.of((Object)"k"))).apply((PTransform)new VoidValues<String, String>(){});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFlatMapBasicWithLambda() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.integers()).via((SerializableFunction & Serializable)i -> ImmutableList.of(i, Integer.valueOf(-i.intValue()))));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 3, -1, -3, 2, -2});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFlatMapMethodReference() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.integers()).via(new Negater()::numAndNegation));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 3, -1, -3, 2, -2});
        this.pipeline.run();
    }

    private static class Negater
    implements Serializable {
        private Negater() {
        }

        public List<Integer> numAndNegation(int input) {
            return ImmutableList.of(Integer.valueOf(input), Integer.valueOf(-input));
        }
    }

    static class VoidValues<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Void>>> {
        VoidValues() {
        }

        public PCollection<KV<K, Void>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)input.apply((PTransform)FlatMapElements.via((SimpleFunction)new SimpleFunction<KV<K, V>, Iterable<KV<K, Void>>>(){

                public Iterable<KV<K, Void>> apply(KV<K, V> input) {
                    return Collections.singletonList(KV.of((Object)input.getKey(), null));
                }
            }));
        }
    }

    private static class PolymorphicSimpleFunction<T>
    extends SimpleFunction<T, Iterable<T>> {
        private PolymorphicSimpleFunction() {
        }

        public Iterable<T> apply(T input) {
            return Collections.emptyList();
        }
    }
}

