/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterTest
implements Serializable {
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testIdentityFilterByPredicate() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)591, (Object[])new Integer[]{11789, 1257, 24578, 24799, 307}))).apply((PTransform)Filter.by((SerializableFunction)new TrivialFn(true)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{591, 11789, 1257, 24578, 24799, 307});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testNoFilterByPredicate() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 4, 5}))).apply((PTransform)Filter.by((SerializableFunction)new TrivialFn(false)));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterByPredicate() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by((SerializableFunction)new EvenFn()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterLessThan() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.lessThan((Comparable)Integer.valueOf(4)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 2, 3});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterGreaterThan() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.greaterThan((Comparable)Integer.valueOf(4)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{5, 6, 7});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterLessThanEq() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.lessThanEq((Comparable)Integer.valueOf(4)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 4});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterGreaterThanEq() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.greaterThanEq((Comparable)Integer.valueOf(4)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{4, 5, 6, 7});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterEqual() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.equal((Comparable)Integer.valueOf(4)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{4});
        this.p.run();
    }

    @Test
    public void testDisplayData() {
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)Filter.lessThan((Comparable)Integer.valueOf(123))), DisplayDataMatchers.hasDisplayItem("predicate", "x < 123"));
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)Filter.lessThanEq((Comparable)Integer.valueOf(234))), DisplayDataMatchers.hasDisplayItem("predicate", "x \u2264 234"));
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)Filter.greaterThan((Comparable)Integer.valueOf(345))), DisplayDataMatchers.hasDisplayItem("predicate", "x > 345"));
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)Filter.greaterThanEq((Comparable)Integer.valueOf(456))), DisplayDataMatchers.hasDisplayItem("predicate", "x \u2265 456"));
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)Filter.equal((Comparable)Integer.valueOf(567))), DisplayDataMatchers.hasDisplayItem("predicate", "x == 567"));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testIdentityFilterByPredicateWithLambda() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)591, (Object[])new Integer[]{11789, 1257, 24578, 24799, 307}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> true));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{591, 11789, 1257, 24578, 24799, 307});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testNoFilterByPredicateWithLambda() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 4, 5}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> false));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterByPredicateWithLambda() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> i % 2 == 0));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        this.p.run();
    }

    @Test
    public void testFilterParDoOutputTypeDescriptorRawWithLambda() throws Exception {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)Filter.by((SerializableFunction & Serializable)s -> true));
        this.thrown.expect(CannotProvideCoderException.class);
        this.p.getCoderRegistry().getCoder(output.getTypeDescriptor());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testFilterByMethodReferenceWithLambda() {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by(new EvenFilter()::isEven));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        this.p.run();
    }

    private static class EvenFilter
    implements Serializable {
        private EvenFilter() {
        }

        public boolean isEven(int i) {
            return i % 2 == 0;
        }
    }

    static class EvenFn
    implements SerializableFunction<Integer, Boolean> {
        EvenFn() {
        }

        public Boolean apply(Integer elem) {
            return elem % 2 == 0;
        }
    }

    static class TrivialFn
    implements SerializableFunction<Integer, Boolean> {
        private final Boolean returnVal;

        TrivialFn(Boolean returnVal) {
            this.returnVal = returnVal;
        }

        public Boolean apply(Integer elem) {
            return this.returnVal;
        }
    }
}

