/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CreateTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final TestPipeline p = TestPipeline.create();
    private static final Schema STRING_SCHEMA = Schema.builder().addStringField("field").build();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCreate() {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.LINES));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.LINES_ARRAY);
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCreateEmpty() {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.empty((Coder)StringUtf8Coder.of()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])TestUtils.NO_LINES_ARRAY);
        Assert.assertEquals((Object)StringUtf8Coder.of(), (Object)output.getCoder());
        this.p.run();
    }

    @Test
    public void testCreateEmptyIterableRequiresCoder() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("determine a default Coder");
        this.thrown.expectMessage("Create.empty(Coder)");
        this.thrown.expectMessage("Create.empty(TypeDescriptor)");
        this.thrown.expectMessage("withCoder(Coder)");
        this.thrown.expectMessage("withType(TypeDescriptor)");
        this.p.apply((PTransform)Create.of(Collections.emptyList()));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCreateEmptyIterableWithCoder() {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.of(Collections.emptyList()).withCoder((Coder)VoidCoder.of()));
        Assert.assertEquals((Object)VoidCoder.of(), (Object)output.getCoder());
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    public void testPolymorphicType() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Unable to infer a coder"));
        this.p.apply((PTransform)Create.of((Object)new Record(), (Object[])new Record[]{new Record2()}));
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCreateWithNullsAndValues() throws Exception {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.of(null, (Object[])new String[]{"test1", null, "test2", null}).withCoder((Coder)SerializableCoder.of(String.class)));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{null, "test1", null, "test2", null});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCreateParameterizedType() throws Exception {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.of((Object)TimestampedValue.of((Object)"a", (Instant)new Instant(0L)), (Object[])new TimestampedValue[]{TimestampedValue.of((Object)"b", (Instant)new Instant(0L))}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new TimestampedValue[]{TimestampedValue.of((Object)"a", (Instant)new Instant(0L)), TimestampedValue.of((Object)"b", (Instant)new Instant(0L))});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCreateWithUnserializableElements() throws Exception {
        ImmutableList<UnserializableRecord> elements = ImmutableList.of(new UnserializableRecord("foo"), new UnserializableRecord("bar"), new UnserializableRecord("baz"));
        Create.Values create = Create.of(elements).withCoder((Coder)new UnserializableRecord.UnserializableRecordCoder());
        PAssert.that((PCollection)((PCollection)this.p.apply((PTransform)create))).containsInAnyOrder((Object[])new UnserializableRecord[]{new UnserializableRecord("foo"), new UnserializableRecord("bar"), new UnserializableRecord("baz")});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCreateTimestamped() {
        List<TimestampedValue> data = Arrays.asList(TimestampedValue.of((Object)"a", (Instant)new Instant(1L)), TimestampedValue.of((Object)"b", (Instant)new Instant(2L)), TimestampedValue.of((Object)"c", (Instant)new Instant(3L)));
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.timestamped(data))).apply((PTransform)ParDo.of((DoFn)new PrintTimestamps()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"a:1", "b:2", "c:3"});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCreateTimestampedEmpty() {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.timestamped(new ArrayList()).withCoder((Coder)StringUtf8Coder.of()));
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    public void testCreateTimestampedEmptyUnspecifiedCoder() {
        this.p.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("determine a default Coder");
        this.thrown.expectMessage("Create.empty(Coder)");
        this.thrown.expectMessage("Create.empty(TypeDescriptor)");
        this.thrown.expectMessage("withCoder(Coder)");
        this.thrown.expectMessage("withType(TypeDescriptor)");
        this.p.apply((PTransform)Create.timestamped(new ArrayList()));
    }

    @Test
    public void testCreateTimestampedPolymorphicType() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Unable to infer a coder"));
        PCollection c = (PCollection)this.p.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)new Record(), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)new Record2(), (Instant)new Instant(0L))}));
        this.p.run();
        throw new RuntimeException("Coder: " + c.getCoder());
    }

    @Test
    public void testCreateTimestampedDefaultOutputCoderUsingCoder() throws Exception {
        RecordCoder coder = new RecordCoder();
        Create.TimestampedValues values = Create.timestamped((TimestampedValue)TimestampedValue.of((Object)new Record(), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)new Record2(), (Instant)new Instant(0L))}).withCoder((Coder)coder);
        Assert.assertThat((Object)((PCollection)this.p.apply((PTransform)values)).getCoder(), (Matcher)Matchers.equalTo((Object)((Object)coder)));
    }

    @Test
    public void testCreateTimestampedDefaultOutputCoderUsingTypeDescriptor() throws Exception {
        RecordCoder coder = new RecordCoder();
        this.p.getCoderRegistry().registerCoderForClass(Record.class, (Coder)coder);
        Create.TimestampedValues values = Create.timestamped((TimestampedValue)TimestampedValue.of((Object)new Record(), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)new Record2(), (Instant)new Instant(0L))}).withType((TypeDescriptor)new TypeDescriptor<Record>(){});
        Assert.assertThat((Object)((PCollection)this.p.apply((PTransform)values)).getCoder(), (Matcher)Matchers.equalTo((Object)((Object)coder)));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCreateWithVoidType() throws Exception {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.of((Object)null, (Object[])new Void[]{null}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Void[]{null, null});
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCreateWithKVVoidType() throws Exception {
        PCollection output = (PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)null, (Object)null), (Object[])new KV[]{KV.of((Object)null, (Object)null)}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)null, (Object)null), KV.of((Object)null, (Object)null)});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCreateOfProvider() throws Exception {
        PAssert.that((PCollection)((PCollection)this.p.apply("Static", (PTransform)Create.ofProvider((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"foo"), (Coder)StringUtf8Coder.of())))).containsInAnyOrder((Object[])new String[]{"foo"});
        PAssert.that((PCollection)((PCollection)this.p.apply("Static nested", (PTransform)Create.ofProvider((ValueProvider)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"foo"), (SerializableFunction & Serializable)input -> input + "bar"), (Coder)StringUtf8Coder.of())))).containsInAnyOrder((Object[])new String[]{"foobar"});
        PAssert.that((PCollection)((PCollection)this.p.apply("Runtime", (PTransform)Create.ofProvider((ValueProvider)this.p.newProvider((Object)"runtimeFoo"), (Coder)StringUtf8Coder.of())))).containsInAnyOrder((Object[])new String[]{"runtimeFoo"});
        this.p.run();
    }

    @Test
    public void testCreateGetName() {
        Assert.assertEquals((Object)"Create.Values", (Object)Create.of((Object)1, (Object[])new Integer[]{2, 3}).getName());
        Assert.assertEquals((Object)"Create.TimestampedValues", (Object)Create.timestamped(Collections.emptyList()).getName());
    }

    @Test
    public void testCreateDefaultOutputCoderUsingInference() throws Exception {
        RecordCoder coder = new RecordCoder();
        this.p.getCoderRegistry().registerCoderForClass(Record.class, (Coder)coder);
        Assert.assertThat((Object)((PCollection)this.p.apply((PTransform)Create.of((Object)new Record(), (Object[])new Record[]{new Record(), new Record()}))).getCoder(), (Matcher)Matchers.equalTo((Object)((Object)coder)));
    }

    @Test
    public void testCreateDefaultOutputCoderUsingCoder() throws Exception {
        RecordCoder coder = new RecordCoder();
        Assert.assertThat((Object)((PCollection)this.p.apply((PTransform)Create.of((Object)new Record(), (Object[])new Record[]{new Record2()}).withCoder((Coder)coder))).getCoder(), (Matcher)Matchers.equalTo((Object)((Object)coder)));
    }

    @Test
    public void testCreateDefaultOutputCoderUsingTypeDescriptor() throws Exception {
        RecordCoder coder = new RecordCoder();
        this.p.getCoderRegistry().registerCoderForClass(Record.class, (Coder)coder);
        Create.Values values = Create.of((Object)new Record(), (Object[])new Record[]{new Record2()}).withType((TypeDescriptor)new TypeDescriptor<Record>(){});
        Assert.assertThat((Object)((PCollection)this.p.apply((PTransform)values)).getCoder(), (Matcher)Matchers.equalTo((Object)((Object)coder)));
    }

    @Test
    public void testCreateRegisteredSchema() {
        this.p.getSchemaRegistry().registerSchemaForClass(String.class, STRING_SCHEMA, (SerializableFunction & Serializable)s -> Row.withSchema((Schema)STRING_SCHEMA).addValue(s).build(), (SerializableFunction & Serializable)r -> r.getString("field"));
        PCollection out = (PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c", "d"}));
        Assert.assertThat((Object)out.getCoder(), (Matcher)Matchers.instanceOf(SchemaCoder.class));
    }

    @Test
    public void testCreateExplicitSchema() {
        PCollection out = (PCollection)this.p.apply((PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c", "d"}).withSchema(STRING_SCHEMA, (SerializableFunction & Serializable)s -> Row.withSchema((Schema)STRING_SCHEMA).addValue(s).build(), (SerializableFunction & Serializable)r -> r.getString("field")));
        Assert.assertThat((Object)out.getCoder(), (Matcher)Matchers.instanceOf(SchemaCoder.class));
    }

    @Test
    public void testSourceIsSerializableWithUnserializableElements() throws Exception {
        ImmutableList<UnserializableRecord> elements = ImmutableList.of(new UnserializableRecord("foo"), new UnserializableRecord("bar"), new UnserializableRecord("baz"));
        Create.Values.CreateSource source = Create.Values.CreateSource.fromIterable(elements, (Coder)new UnserializableRecord.UnserializableRecordCoder());
        SerializableUtils.ensureSerializable((Serializable)source);
    }

    @Test
    public void testSourceSplit() throws Exception {
        Create.Values.CreateSource source = Create.Values.CreateSource.fromIterable(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)), (Coder)BigEndianIntegerCoder.of());
        PipelineOptions options = PipelineOptionsFactory.create();
        List splitSources = source.split(12L, options);
        Assert.assertThat((Object)splitSources, (Matcher)Matchers.hasSize((int)3));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splitSources, (PipelineOptions)options);
    }

    @Test
    public void testSourceSplitVoid() throws Exception {
        Create.Values.CreateSource source = Create.Values.CreateSource.fromIterable(Lists.newArrayList(null, null, null, null, null), (Coder)VoidCoder.of());
        PipelineOptions options = PipelineOptionsFactory.create();
        List splitSources = source.split(3L, options);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splitSources, (PipelineOptions)options);
    }

    @Test
    public void testSourceSplitEmpty() throws Exception {
        Create.Values.CreateSource source = Create.Values.CreateSource.fromIterable(ImmutableList.of(), (Coder)BigEndianIntegerCoder.of());
        PipelineOptions options = PipelineOptionsFactory.create();
        List splitSources = source.split(12L, options);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splitSources, (PipelineOptions)options);
    }

    @Test
    public void testSourceGetOutputCoderReturnsConstructorCoder() throws Exception {
        VarIntCoder coder = VarIntCoder.of();
        Create.Values.CreateSource source = Create.Values.CreateSource.fromIterable(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)), (Coder)coder);
        Coder defaultCoder = source.getOutputCoder();
        Assert.assertThat((Object)defaultCoder, (Matcher)Matchers.equalTo((Object)coder));
    }

    @Test
    public void testSourceSplitAtFraction() throws Exception {
        ArrayList<Integer> elements = new ArrayList<Integer>();
        Random random = new Random();
        for (int i = 0; i < 25; ++i) {
            elements.add(random.nextInt());
        }
        Create.Values.CreateSource source = Create.Values.CreateSource.fromIterable(elements, (Coder)VarIntCoder.of());
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, (PipelineOptions)PipelineOptionsFactory.create());
    }

    public static interface CreateOfProviderOptions
    extends PipelineOptions {
        public ValueProvider<String> getFoo();

        public void setFoo(ValueProvider<String> var1);
    }

    private static class PrintTimestamps
    extends DoFn<String, String> {
        private PrintTimestamps() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((String)c.element() + ":" + c.timestamp().getMillis()));
        }
    }

    private static class UnserializableRecord {
        private final String myString;

        private UnserializableRecord(String myString) {
            this.myString = myString;
        }

        public int hashCode() {
            return this.myString.hashCode();
        }

        public boolean equals(Object o) {
            return this.myString.equals(((UnserializableRecord)o).myString);
        }

        static class UnserializableRecordCoder
        extends AtomicCoder<UnserializableRecord> {
            private final Coder<String> stringCoder = StringUtf8Coder.of();

            UnserializableRecordCoder() {
            }

            public void encode(UnserializableRecord value, OutputStream outStream) throws CoderException, IOException {
                this.stringCoder.encode((Object)value.myString, outStream);
            }

            public UnserializableRecord decode(InputStream inStream) throws CoderException, IOException {
                return new UnserializableRecord((String)this.stringCoder.decode(inStream));
            }
        }
    }

    private static class RecordCoder
    extends AtomicCoder<Record> {
        private RecordCoder() {
        }

        public void encode(Record value, OutputStream outStream) throws CoderException, IOException {
        }

        public Record decode(InputStream inStream) throws CoderException, IOException {
            return null;
        }
    }

    static class Record2
    extends Record {
        Record2() {
        }
    }

    static class Record
    implements Serializable {
        Record() {
        }
    }
}

