/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CountTest {
    static final String[] WORDS_ARRAY = new String[]{"hi", "there", "hi", "hi", "sue", "bob", "hi", "sue", "", "", "ZOW", "bob", ""};
    static final List<String> WORDS = Arrays.asList(WORDS_ARRAY);
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={NeedsRunner.class})
    public void testCountPerElementBasic() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(WORDS));
        PCollection output = (PCollection)input.apply(Count.perElement());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"hi", (Object)4L), KV.of((Object)"there", (Object)1L), KV.of((Object)"sue", (Object)2L), KV.of((Object)"bob", (Object)2L), KV.of((Object)"", (Object)3L), KV.of((Object)"ZOW", (Object)1L)});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCountPerElementEmpty() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.NO_LINES).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply(Count.perElement());
        PAssert.that((PCollection)output).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCountGloballyBasic() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(WORDS));
        PCollection output = (PCollection)input.apply(Count.globally());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Long[]{13L});
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testCountGloballyEmpty() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(TestUtils.NO_LINES).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply(Count.globally());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Long[]{0L});
        this.p.run();
    }

    @Test
    public void testCountGetName() {
        Assert.assertEquals((Object)"Count.PerElement", (Object)Count.perElement().getName());
        Assert.assertEquals((Object)"Combine.globally(Count)", (Object)Count.globally().getName());
    }
}

