/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Mean;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

public class CombineTest
implements Serializable {
    static final List<KV<String, Integer>> EMPTY_TABLE = Collections.emptyList();

    private static PCollection<KV<String, Integer>> createInput(Pipeline p, List<KV<String, Integer>> table) {
        return (PCollection)p.apply((PTransform)Create.of(table).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
    }

    @RunWith(value=JUnit4.class)
    public static class AccumulationTests
    extends SharedTestBase {
        @Test
        @Category(value={ValidatesRunner.class})
        public void testAccumulatingCombine() {
            this.runTestAccumulatingCombine(Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)13)), 4.0, Arrays.asList(KV.of((Object)"a", (Object)2.0), KV.of((Object)"b", (Object)7.0)));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testAccumulatingCombineEmpty() {
            this.runTestAccumulatingCombine(EMPTY_TABLE, 0.0, Collections.emptyList());
        }
    }

    @RunWith(value=JUnit4.class)
    public static class WindowingTests
    extends SharedTestBase
    implements Serializable {
        @Test
        @Category(value={ValidatesRunner.class})
        public void testFixedWindowsCombine() {
            PCollection input = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), TimestampedValue.of((Object)KV.of((Object)"a", (Object)4), (Instant)new Instant(6L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)1), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)13), (Instant)new Instant(8L))}).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)2L))));
            PCollection sum = (PCollection)((PCollection)input.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((SerializableFunction)new SharedTestBase.SumInts()).withoutDefaults());
            PCollection sumPerKey = (PCollection)input.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFn()));
            PAssert.that((PCollection)sum).containsInAnyOrder((Object[])new Integer[]{2, 5, 13});
            PAssert.that((PCollection)sumPerKey).containsInAnyOrder(Arrays.asList(KV.of((Object)"a", (Object)"11"), KV.of((Object)"a", (Object)"4"), KV.of((Object)"b", (Object)"1"), KV.of((Object)"b", (Object)"13")));
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testFixedWindowsCombineWithContext() {
            PCollection perKeyInput = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(1L)), TimestampedValue.of((Object)KV.of((Object)"a", (Object)4), (Instant)new Instant(6L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)1), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)13), (Instant)new Instant(8L))}).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)2L))));
            PCollection globallyInput = (PCollection)perKeyInput.apply((PTransform)Values.create());
            PCollection sum = (PCollection)globallyInput.apply("Sum", (PTransform)Combine.globally((SerializableFunction)new SharedTestBase.SumInts()).withoutDefaults());
            PCollectionView globallySumView = (PCollectionView)sum.apply((PTransform)View.asSingleton());
            PCollection combinePerKeyWithContext = (PCollection)perKeyInput.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFnWithContext((PCollectionView<Integer>)globallySumView)).withSideInputs(new PCollectionView[]{globallySumView}));
            PCollection combineGloballyWithContext = (PCollection)globallyInput.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFnWithContext((PCollectionView<Integer>)globallySumView)).withoutDefaults().withSideInputs(new PCollectionView[]{globallySumView}));
            PAssert.that((PCollection)sum).containsInAnyOrder((Object[])new Integer[]{2, 5, 13});
            PAssert.that((PCollection)combinePerKeyWithContext).containsInAnyOrder(Arrays.asList(KV.of((Object)"a", (Object)"2:11"), KV.of((Object)"a", (Object)"5:4"), KV.of((Object)"b", (Object)"5:1"), KV.of((Object)"b", (Object)"13:13")));
            PAssert.that((PCollection)combineGloballyWithContext).containsInAnyOrder((Object[])new String[]{"2:11", "5:14", "13:13"});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testSlidingWindowsCombine() {
            PCollection input = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"a", (Instant)new Instant(1L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"b", (Instant)new Instant(2L)), TimestampedValue.of((Object)"c", (Instant)new Instant(3L))}))).apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)Duration.millis((long)3L)).every(Duration.millis((long)1L))));
            PCollection combined = (PCollection)input.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new Combine.CombineFn<String, List<String>, List<String>>(){

                public List<String> createAccumulator() {
                    return new ArrayList<String>();
                }

                public List<String> addInput(List<String> accumulator, String input) {
                    accumulator.add(input);
                    return accumulator;
                }

                public List<String> mergeAccumulators(Iterable<List<String>> accumulators) {
                    List<String> cur = this.createAccumulator();
                    for (List<String> accumulator : accumulators) {
                        accumulator.addAll((Collection<String>)cur);
                        cur = accumulator;
                    }
                    return cur;
                }

                public List<String> extractOutput(List<String> accumulator) {
                    ArrayList<String> result = new ArrayList<String>(accumulator);
                    Collections.sort(result);
                    return result;
                }
            }).withoutDefaults());
            PAssert.that((PCollection)combined).containsInAnyOrder((Object[])new List[]{ImmutableList.of("a"), ImmutableList.of("a", "b"), ImmutableList.of("a", "b", "c"), ImmutableList.of("b", "c"), ImmutableList.of("c")});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testSlidingWindowsCombineWithContext() {
            PCollection perKeyInput = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(2L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(3L)), TimestampedValue.of((Object)KV.of((Object)"a", (Object)4), (Instant)new Instant(8L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)1), (Instant)new Instant(9L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)13), (Instant)new Instant(10L))}).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())))).apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)Duration.millis((long)2L))));
            PCollection globallyInput = (PCollection)perKeyInput.apply((PTransform)Values.create());
            PCollection sum = (PCollection)globallyInput.apply("Sum", (PTransform)Sum.integersGlobally().withoutDefaults());
            PCollectionView globallySumView = (PCollectionView)sum.apply((PTransform)View.asSingleton());
            PCollection combinePerKeyWithContext = (PCollection)perKeyInput.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFnWithContext((PCollectionView<Integer>)globallySumView)).withSideInputs(new PCollectionView[]{globallySumView}));
            PCollection combineGloballyWithContext = (PCollection)globallyInput.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFnWithContext((PCollectionView<Integer>)globallySumView)).withoutDefaults().withSideInputs(new PCollectionView[]{globallySumView}));
            PAssert.that((PCollection)sum).containsInAnyOrder((Object[])new Integer[]{1, 2, 1, 4, 5, 14, 13});
            PAssert.that((PCollection)combinePerKeyWithContext).containsInAnyOrder(Arrays.asList(KV.of((Object)"a", (Object)"1:1"), KV.of((Object)"a", (Object)"2:11"), KV.of((Object)"a", (Object)"1:1"), KV.of((Object)"a", (Object)"4:4"), KV.of((Object)"a", (Object)"5:4"), KV.of((Object)"b", (Object)"5:1"), KV.of((Object)"b", (Object)"14:113"), KV.of((Object)"b", (Object)"13:13")));
            PAssert.that((PCollection)combineGloballyWithContext).containsInAnyOrder((Object[])new String[]{"1:1", "2:11", "1:1", "4:4", "5:14", "14:113", "13:13"});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testGlobalCombineWithDefaultsAndTriggers() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{1}));
            PCollection output = (PCollection)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).accumulatingFiredPanes().withAllowedLateness(new Duration(0L), Window.ClosingBehavior.FIRE_ALWAYS))).apply((PTransform)Sum.integersGlobally())).apply((PTransform)ParDo.of((DoFn)new SharedTestBase.FormatPaneInfo()));
            PAssert.that((PCollection)output).satisfies((SerializableFunction & Serializable)input1 -> {
                Assert.assertThat((Object)input1, (Matcher)Matchers.hasItem((Object)"2: true"));
                return null;
            });
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testSessionsCombine() {
            PCollection input = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(4L)), TimestampedValue.of((Object)KV.of((Object)"a", (Object)4), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)1), (Instant)new Instant(10L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)13), (Instant)new Instant(16L))}).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())))).apply((PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)5L))));
            PCollection sum = (PCollection)((PCollection)input.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((SerializableFunction)new SharedTestBase.SumInts()).withoutDefaults());
            PCollection sumPerKey = (PCollection)input.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFn()));
            PAssert.that((PCollection)sum).containsInAnyOrder((Object[])new Integer[]{7, 13});
            PAssert.that((PCollection)sumPerKey).containsInAnyOrder(Arrays.asList(KV.of((Object)"a", (Object)"114"), KV.of((Object)"b", (Object)"1"), KV.of((Object)"b", (Object)"13")));
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testSessionsCombineWithContext() {
            PCollection perKeyInput = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)"a", (Object)1), (Instant)new Instant(4L)), TimestampedValue.of((Object)KV.of((Object)"a", (Object)4), (Instant)new Instant(7L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)1), (Instant)new Instant(10L)), TimestampedValue.of((Object)KV.of((Object)"b", (Object)13), (Instant)new Instant(16L))}).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
            PCollection globallyInput = (PCollection)perKeyInput.apply((PTransform)Values.create());
            PCollection fixedWindowsSum = (PCollection)((PCollection)globallyInput.apply("FixedWindows", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)5L))))).apply("Sum", (PTransform)Combine.globally((SerializableFunction)new SharedTestBase.SumInts()).withoutDefaults());
            PCollectionView globallyFixedWindowsView = (PCollectionView)fixedWindowsSum.apply((PTransform)View.asSingleton().withDefaultValue((Object)0));
            PCollection sessionsCombinePerKey = (PCollection)((PCollection)perKeyInput.apply("PerKey Input Sessions", (PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)5L))))).apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFnWithContext((PCollectionView<Integer>)globallyFixedWindowsView)).withSideInputs(new PCollectionView[]{globallyFixedWindowsView}));
            PCollection sessionsCombineGlobally = (PCollection)((PCollection)globallyInput.apply("Globally Input Sessions", (PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)5L))))).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFnWithContext((PCollectionView<Integer>)globallyFixedWindowsView)).withoutDefaults().withSideInputs(new PCollectionView[]{globallyFixedWindowsView}));
            PAssert.that((PCollection)fixedWindowsSum).containsInAnyOrder((Object[])new Integer[]{2, 4, 1, 13});
            PAssert.that((PCollection)sessionsCombinePerKey).containsInAnyOrder(Arrays.asList(KV.of((Object)"a", (Object)"1:114"), KV.of((Object)"b", (Object)"1:1"), KV.of((Object)"b", (Object)"0:13")));
            PAssert.that((PCollection)sessionsCombineGlobally).containsInAnyOrder((Object[])new String[]{"1:1114", "0:13"});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testWindowedCombineEmpty() {
            PCollection mean = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.empty((Coder)BigEndianIntegerCoder.of()))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.millis((long)1L))))).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new SharedTestBase.MeanInts()).withoutDefaults());
            PAssert.that((PCollection)mean).empty();
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombineGloballyAsSingletonView() {
            final PCollectionView view = (PCollectionView)((PCollection)this.pipeline.apply("CreateEmptySideInput", (PTransform)Create.empty((Coder)BigEndianIntegerCoder.of()))).apply((PTransform)Sum.integersGlobally().asSingletonView());
            PCollection output = (PCollection)((PCollection)this.pipeline.apply("CreateVoidMainInput", (PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply("OutputSideInput", (PTransform)ParDo.of((DoFn)new DoFn<Void, Integer>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)((Integer)c.sideInput(view)));
                }
            }).withSideInputs(new PCollectionView[]{view}));
            PAssert.thatSingleton((PCollection)output).isEqualTo((Object)0);
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testWindowedCombineGloballyAsSingletonView() {
            FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardMinutes((long)1L));
            final PCollectionView view = (PCollectionView)((PCollection)((PCollection)this.pipeline.apply("CreateSideInput", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)1, (Instant)new Instant(100L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)3, (Instant)new Instant(100L))}))).apply("WindowSideInput", (PTransform)Window.into((WindowFn)windowFn))).apply("CombineSideInput", (PTransform)Sum.integersGlobally().asSingletonView());
            TimestampedValue nonEmptyElement = TimestampedValue.of(null, (Instant)new Instant(100L));
            TimestampedValue emptyElement = TimestampedValue.atMinimumTimestamp(null);
            PCollection output = (PCollection)((PCollection)((PCollection)this.pipeline.apply("CreateMainInput", (PTransform)Create.timestamped((TimestampedValue)nonEmptyElement, (TimestampedValue[])new TimestampedValue[]{emptyElement}).withCoder((Coder)VoidCoder.of()))).apply("WindowMainInput", (PTransform)Window.into((WindowFn)windowFn))).apply("OutputSideInput", (PTransform)ParDo.of((DoFn)new DoFn<Void, Integer>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)((Integer)c.sideInput(view)));
                }
            }).withSideInputs(new PCollectionView[]{view}));
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{4, 0});
            PAssert.that((PCollection)output).inWindow((BoundedWindow)windowFn.assignWindow(nonEmptyElement.getTimestamp())).containsInAnyOrder((Object[])new Integer[]{4});
            PAssert.that((PCollection)output).inWindow((BoundedWindow)windowFn.assignWindow(emptyElement.getTimestamp())).containsInAnyOrder((Object[])new Integer[]{0});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombineGloballyLambda() {
            PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply((PTransform)Combine.globally((SerializableFunction & Serializable)integers -> {
                int sum = 0;
                Iterator iterator = integers.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    sum += i;
                }
                return sum;
            }));
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{10});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombineGloballyInstanceMethodReference() {
            PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply((PTransform)Combine.globally(new SharedTestBase.Summer()::sum));
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{10});
            this.pipeline.run();
        }
    }

    @RunWith(value=JUnit4.class)
    public static class CombineWithContextTests
    extends SharedTestBase {
        @Test
        @Category(value={ValidatesRunner.class})
        public void testSimpleCombineWithContext() {
            this.runTestSimpleCombineWithContext(Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)13)), 20, Arrays.asList(KV.of((Object)"a", (Object)"20:114"), KV.of((Object)"b", (Object)"20:113")), new String[]{"20:111134"});
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testSimpleCombineWithContextEmpty() {
            this.runTestSimpleCombineWithContext(EMPTY_TABLE, 0, Collections.emptyList(), new String[0]);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class BasicTests
    extends SharedTestBase {
        @Test
        @Category(value={ValidatesRunner.class})
        public void testSimpleCombine() {
            this.runTestSimpleCombine(Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)13)), 20, Arrays.asList(KV.of((Object)"a", (Object)"114"), KV.of((Object)"b", (Object)"113")));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testSimpleCombineEmpty() {
            this.runTestSimpleCombine(EMPTY_TABLE, 0, Collections.emptyList());
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testBasicCombine() {
            this.runTestBasicCombine(Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)13)), ImmutableSet.of(Integer.valueOf(1), Integer.valueOf(13), Integer.valueOf(4)), Arrays.asList(KV.of((Object)"a", ImmutableSet.of(Integer.valueOf(1), Integer.valueOf(4))), KV.of((Object)"b", ImmutableSet.of(Integer.valueOf(1), Integer.valueOf(13)))));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testBasicCombineEmpty() {
            this.runTestBasicCombine(EMPTY_TABLE, ImmutableSet.of(), Collections.emptyList());
        }

        @Test
        public void testCombinerNames() {
            Combine.PerKey min = Min.integersPerKey();
            Combine.PerKey max = Max.integersPerKey();
            Combine.PerKey mean = Mean.perKey();
            Combine.PerKey sum = Sum.integersPerKey();
            Assert.assertThat((Object)min.getName(), (Matcher)Matchers.equalTo((Object)"Combine.perKey(MinInteger)"));
            Assert.assertThat((Object)max.getName(), (Matcher)Matchers.equalTo((Object)"Combine.perKey(MaxInteger)"));
            Assert.assertThat((Object)mean.getName(), (Matcher)Matchers.equalTo((Object)"Combine.perKey(Mean)"));
            Assert.assertThat((Object)sum.getName(), (Matcher)Matchers.equalTo((Object)"Combine.perKey(SumInteger)"));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testHotKeyCombining() {
            PCollection input = BasicTests.copy(CombineTest.createInput((Pipeline)this.pipeline, Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)13))), 10);
            SharedTestBase.MeanInts mean = new SharedTestBase.MeanInts();
            PCollection coldMean = (PCollection)input.apply("ColdMean", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)mean).withHotKeyFanout(0));
            PCollection warmMean = (PCollection)input.apply("WarmMean", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)mean).withHotKeyFanout(HOT_KEY_FANOUT));
            PCollection hotMean = (PCollection)input.apply("HotMean", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)mean).withHotKeyFanout(5));
            PCollection splitMean = (PCollection)input.apply("SplitMean", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)mean).withHotKeyFanout(SPLIT_HOT_KEY_FANOUT));
            List<KV> expected = Arrays.asList(KV.of((Object)"a", (Object)2.0), KV.of((Object)"b", (Object)7.0));
            PAssert.that((PCollection)coldMean).containsInAnyOrder(expected);
            PAssert.that((PCollection)warmMean).containsInAnyOrder(expected);
            PAssert.that((PCollection)hotMean).containsInAnyOrder(expected);
            PAssert.that((PCollection)splitMean).containsInAnyOrder(expected);
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testHotKeyCombiningWithAccumulationMode() {
            PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5}));
            PCollection output = (PCollection)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).accumulatingFiredPanes().withAllowedLateness(new Duration(0L), Window.ClosingBehavior.FIRE_ALWAYS))).apply((PTransform)Sum.integersGlobally().withoutDefaults().withFanout(2))).apply((PTransform)ParDo.of((DoFn)new SharedTestBase.GetLast()));
            PAssert.that((PCollection)output).satisfies((SerializableFunction & Serializable)input1 -> {
                Assert.assertThat((Object)input1, (Matcher)Matchers.hasItem((Object)15));
                return null;
            });
            this.pipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testBinaryCombineFn() {
            PCollection input = BasicTests.copy(CombineTest.createInput((Pipeline)this.pipeline, Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)13))), 2);
            PCollection intProduct = (PCollection)input.apply("IntProduct", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestProdInt()));
            PCollection objProduct = (PCollection)input.apply("ObjProduct", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestProdObj()));
            List<KV> expected = Arrays.asList(KV.of((Object)"a", (Object)16), KV.of((Object)"b", (Object)169));
            PAssert.that((PCollection)intProduct).containsInAnyOrder(expected);
            PAssert.that((PCollection)objProduct).containsInAnyOrder(expected);
            this.pipeline.run();
        }

        @Test
        public void testBinaryCombineFnWithNulls() {
            CombineFnTester.testCombineFn((Combine.CombineFn)new SharedTestBase.NullCombiner(), Arrays.asList(3, 3, 5), (Object)45);
            CombineFnTester.testCombineFn((Combine.CombineFn)new SharedTestBase.NullCombiner(), Arrays.asList(null, 3, 5), (Object)30);
            CombineFnTester.testCombineFn((Combine.CombineFn)new SharedTestBase.NullCombiner(), Arrays.asList(3, 3, null), (Object)18);
            CombineFnTester.testCombineFn((Combine.CombineFn)new SharedTestBase.NullCombiner(), Arrays.asList(null, 3, null), (Object)12);
            CombineFnTester.testCombineFn((Combine.CombineFn)new SharedTestBase.NullCombiner(), Arrays.asList(null, null, null), (Object)8);
        }

        @Test
        public void testCombineGetName() {
            Assert.assertEquals((Object)"Combine.globally(SumInts)", (Object)Combine.globally((SerializableFunction)new SharedTestBase.SumInts()).getName());
            Assert.assertEquals((Object)"Combine.GloballyAsSingletonView", (Object)Combine.globally((SerializableFunction)new SharedTestBase.SumInts()).asSingletonView().getName());
            Assert.assertEquals((Object)"Combine.perKey(Test)", (Object)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFn()).getName());
            Assert.assertEquals((Object)"Combine.perKeyWithFanout(Test)", (Object)Combine.perKey((CombineFnBase.GlobalCombineFn)new SharedTestBase.TestCombineFn()).withHotKeyFanout(10).getName());
        }

        @Test
        public void testDisplayData() {
            SharedTestBase.UniqueInts combineFn = new SharedTestBase.UniqueInts(){

                public void populateDisplayData(DisplayData.Builder builder) {
                    builder.add(DisplayData.item((String)"fnMetadata", (String)"foobar"));
                }
            };
            Combine.Globally combine = Combine.globally((CombineFnBase.GlobalCombineFn)combineFn).withFanout(1234);
            DisplayData displayData = DisplayData.from((HasDisplayData)combine);
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("combineFn", ((Object)((Object)combineFn)).getClass()));
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("emitDefaultOnEmptyInput", true));
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("fanout", 1234L));
            Assert.assertThat((Object)displayData, DisplayDataMatchers.includesDisplayDataFor("combineFn", (HasDisplayData)combineFn));
        }

        @Test
        public void testDisplayDataForWrappedFn() {
            SharedTestBase.UniqueInts combineFn = new SharedTestBase.UniqueInts(){

                public void populateDisplayData(DisplayData.Builder builder) {
                    builder.add(DisplayData.item((String)"foo", (String)"bar"));
                }
            };
            Combine.PerKey combine = Combine.perKey((CombineFnBase.GlobalCombineFn)combineFn);
            DisplayData displayData = DisplayData.from((HasDisplayData)combine);
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("combineFn", ((Object)((Object)combineFn)).getClass()));
            Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasNamespace(((Object)((Object)combineFn)).getClass())));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombinePerKeyPrimitiveDisplayData() {
            DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
            SharedTestBase.UniqueInts combineFn = new SharedTestBase.UniqueInts();
            Combine.PerKey combine = Combine.perKey((CombineFnBase.GlobalCombineFn)combineFn);
            Set<DisplayData> displayData = evaluator.displayDataForPrimitiveTransforms(combine, KvCoder.of((Coder)VarIntCoder.of(), (Coder)VarIntCoder.of()));
            Assert.assertThat((String)"Combine.perKey should include the combineFn in its primitive transform", displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("combineFn", ((Object)((Object)combineFn)).getClass())));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombinePerKeyWithHotKeyFanoutPrimitiveDisplayData() {
            int hotKeyFanout = 2;
            DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
            SharedTestBase.UniqueInts combineFn = new SharedTestBase.UniqueInts();
            Combine.PerKeyWithHotKeyFanout combine = Combine.perKey((CombineFnBase.GlobalCombineFn)combineFn).withHotKeyFanout(hotKeyFanout);
            Set<DisplayData> displayData = evaluator.displayDataForPrimitiveTransforms(combine, KvCoder.of((Coder)VarIntCoder.of(), (Coder)VarIntCoder.of()));
            Assert.assertThat((String)"Combine.perKey.withHotKeyFanout should include the combineFn in its primitive transform", displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("combineFn", ((Object)((Object)combineFn)).getClass())));
            Assert.assertThat((String)"Combine.perKey.withHotKeyFanout(int) should include the fanout in its primitive transform", displayData, (Matcher)Matchers.hasItem(DisplayDataMatchers.hasDisplayItem("fanout", hotKeyFanout)));
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombinePerKeyLambda() {
            PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)2), KV.of((Object)"a", (Object)3), KV.of((Object)"c", (Object)4)}))).apply((PTransform)Combine.perKey((SerializableFunction & Serializable)integers -> {
                int sum = 0;
                Iterator iterator = integers.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    sum += i;
                }
                return sum;
            }));
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)2), KV.of((Object)"c", (Object)4)});
            this.pipeline.run();
        }

        @Test
        @Category(value={ValidatesRunner.class})
        public void testCombinePerKeyInstanceMethodReference() {
            PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)2), KV.of((Object)"a", (Object)3), KV.of((Object)"c", (Object)4)}))).apply((PTransform)Combine.perKey(new SharedTestBase.Summer()::sum));
            PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)2), KV.of((Object)"c", (Object)4)});
            this.pipeline.run();
        }

        @Test
        public void testLambdaSerialization() {
            boolean lambdaClassSerializationThrows;
            SerializableFunction & Serializable combiner = (SerializableFunction & Serializable)xs -> Iterables.getFirst(xs, 0);
            try {
                SerializableUtils.clone(combiner.getClass());
                lambdaClassSerializationThrows = false;
            }
            catch (IllegalArgumentException e) {
                lambdaClassSerializationThrows = true;
            }
            Assume.assumeTrue((String)"Expected lambda class serialization to fail. If it's fixed, we can remove special behavior in Combine.", (boolean)lambdaClassSerializationThrows);
            Combine.Globally combine = Combine.globally((SerializableFunction)combiner);
            SerializableUtils.clone((Serializable)combine);
        }

        @Test
        public void testLambdaDisplayData() {
            Combine.Globally combine = Combine.globally((SerializableFunction & Serializable)xs -> Iterables.getFirst(xs, 0));
            DisplayData displayData = DisplayData.from((HasDisplayData)combine);
            MatcherAssert.assertThat((Object)displayData.items(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }
    }

    public static abstract class SharedTestBase {
        @Rule
        public final transient TestPipeline pipeline = TestPipeline.create();
        protected static final SerializableFunction<String, Integer> HOT_KEY_FANOUT = (SerializableFunction & Serializable)input -> "a".equals(input) ? 3 : 0;
        protected static final SerializableFunction<String, Integer> SPLIT_HOT_KEY_FANOUT = (SerializableFunction & Serializable)input -> Math.random() < 0.5 ? 3 : 0;

        protected void runTestSimpleCombine(List<KV<String, Integer>> table, int globalSum, List<KV<String, String>> perKeyCombines) {
            PCollection input = CombineTest.createInput((Pipeline)this.pipeline, table);
            PCollection sum = (PCollection)((PCollection)input.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((SerializableFunction)new SumInts()));
            PCollection sumPerKey = (PCollection)input.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new TestCombineFn()));
            PAssert.that((PCollection)sum).containsInAnyOrder((Object[])new Integer[]{globalSum});
            PAssert.that((PCollection)sumPerKey).containsInAnyOrder(perKeyCombines);
            this.pipeline.run();
        }

        protected void runTestBasicCombine(List<KV<String, Integer>> table, Set<Integer> globalUnique, List<KV<String, Set<Integer>>> perKeyUnique) {
            PCollection input = CombineTest.createInput((Pipeline)this.pipeline, table);
            PCollection unique = (PCollection)((PCollection)input.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new UniqueInts()));
            PCollection uniquePerKey = (PCollection)input.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new UniqueInts()));
            PAssert.that((PCollection)unique).containsInAnyOrder((Object[])new Set[]{globalUnique});
            PAssert.that((PCollection)uniquePerKey).containsInAnyOrder(perKeyUnique);
            this.pipeline.run();
        }

        protected void runTestSimpleCombineWithContext(List<KV<String, Integer>> table, int globalSum, List<KV<String, String>> perKeyCombines, String[] globallyCombines) {
            PCollection perKeyInput = CombineTest.createInput((Pipeline)this.pipeline, table);
            PCollection globallyInput = (PCollection)perKeyInput.apply((PTransform)Values.create());
            PCollection sum = (PCollection)globallyInput.apply("Sum", (PTransform)Combine.globally((SerializableFunction)new SumInts()));
            PCollectionView globallySumView = (PCollectionView)sum.apply((PTransform)View.asSingleton());
            PCollection combinePerKey = (PCollection)perKeyInput.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new TestCombineFnWithContext((PCollectionView<Integer>)globallySumView)).withSideInputs(new PCollectionView[]{globallySumView}));
            PCollection combineGlobally = (PCollection)globallyInput.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new TestCombineFnWithContext((PCollectionView<Integer>)globallySumView)).withoutDefaults().withSideInputs(new PCollectionView[]{globallySumView}));
            PAssert.that((PCollection)sum).containsInAnyOrder((Object[])new Integer[]{globalSum});
            PAssert.that((PCollection)combinePerKey).containsInAnyOrder(perKeyCombines);
            PAssert.that((PCollection)combineGlobally).containsInAnyOrder((Object[])globallyCombines);
            this.pipeline.run();
        }

        protected void runTestAccumulatingCombine(List<KV<String, Integer>> table, Double globalMean, List<KV<String, Double>> perKeyMeans) {
            PCollection input = CombineTest.createInput((Pipeline)this.pipeline, table);
            PCollection mean = (PCollection)((PCollection)input.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new MeanInts()));
            PCollection meanPerKey = (PCollection)input.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)new MeanInts()));
            PAssert.that((PCollection)mean).containsInAnyOrder((Object[])new Double[]{globalMean});
            PAssert.that((PCollection)meanPerKey).containsInAnyOrder(perKeyMeans);
            this.pipeline.run();
        }

        protected static <T> PCollection<T> copy(PCollection<T> pc, final int n) {
            return (PCollection)pc.apply((PTransform)ParDo.of((DoFn)new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) throws Exception {
                    for (int i = 0; i < n; ++i) {
                        c.output(c.element());
                    }
                }
            }));
        }

        protected static class Summer
        implements Serializable {
            protected Summer() {
            }

            public int sum(Iterable<Integer> integers) {
                int sum = 0;
                for (int i : integers) {
                    sum += i;
                }
                return sum;
            }
        }

        protected static class MeanInts
        extends Combine.AccumulatingCombineFn<Integer, CountSum, Double> {
            private static final Coder<Long> LONG_CODER = BigEndianLongCoder.of();
            private static final Coder<Double> DOUBLE_CODER = DoubleCoder.of();

            protected MeanInts() {
            }

            public CountSum createAccumulator() {
                return new CountSum(0L, 0.0);
            }

            public Coder<CountSum> getAccumulatorCoder(CoderRegistry registry, Coder<Integer> inputCoder) {
                return new CountSumCoder();
            }

            private static class CountSumCoder
            extends AtomicCoder<CountSum> {
                private CountSumCoder() {
                }

                public void encode(CountSum value, OutputStream outStream) throws IOException {
                    LONG_CODER.encode((Object)value.count, outStream);
                    DOUBLE_CODER.encode((Object)value.sum, outStream);
                }

                public CountSum decode(InputStream inStream) throws IOException {
                    long count = (Long)LONG_CODER.decode(inStream);
                    double sum = (Double)DOUBLE_CODER.decode(inStream);
                    return new CountSum(count, sum);
                }

                public void verifyDeterministic() throws Coder.NonDeterministicException {
                }

                public boolean isRegisterByteSizeObserverCheap(CountSum value) {
                    return true;
                }

                public void registerByteSizeObserver(CountSum value, ElementByteSizeObserver observer) throws Exception {
                    LONG_CODER.registerByteSizeObserver((Object)value.count, observer);
                    DOUBLE_CODER.registerByteSizeObserver((Object)value.sum, observer);
                }
            }

            static class CountSum
            implements Combine.AccumulatingCombineFn.Accumulator<Integer, CountSum, Double> {
                long count = 0L;
                double sum = 0.0;

                CountSum(long count, double sum) {
                    this.count = count;
                    this.sum = sum;
                }

                public void addInput(Integer element) {
                    ++this.count;
                    this.sum += element.doubleValue();
                }

                public void mergeAccumulator(CountSum accumulator) {
                    this.count += accumulator.count;
                    this.sum += accumulator.sum;
                }

                public Double extractOutput() {
                    return this.count == 0L ? 0.0 : this.sum / (double)this.count;
                }

                public int hashCode() {
                    return Objects.hash(this.count, this.sum);
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof CountSum)) {
                        return false;
                    }
                    CountSum other = (CountSum)obj;
                    return this.count == other.count && Math.abs(this.sum - other.sum) < 0.1;
                }

                public String toString() {
                    return MoreObjects.toStringHelper(this).add("count", this.count).add("sum", this.sum).toString();
                }
            }
        }

        public static class UniqueInts
        extends Combine.CombineFn<Integer, Set<Integer>, Set<Integer>> {
            public Set<Integer> createAccumulator() {
                return new HashSet<Integer>();
            }

            public Set<Integer> addInput(Set<Integer> accumulator, Integer input) {
                accumulator.add(input);
                return accumulator;
            }

            public Set<Integer> mergeAccumulators(Iterable<Set<Integer>> accumulators) {
                HashSet<Integer> all = new HashSet<Integer>();
                for (Set<Integer> part : accumulators) {
                    all.addAll(part);
                }
                return all;
            }

            public Set<Integer> extractOutput(Set<Integer> accumulator) {
                return accumulator;
            }
        }

        public static class SumInts
        implements SerializableFunction<Iterable<Integer>, Integer> {
            public Integer apply(Iterable<Integer> input) {
                int sum = 0;
                for (int item : input) {
                    sum += item;
                }
                return sum;
            }
        }

        protected static final class NullCombiner
        extends Combine.BinaryCombineFn<Integer> {
            protected NullCombiner() {
            }

            public Integer apply(Integer left, Integer right) {
                return (left == null ? 2 : left) * (right == null ? 2 : right);
            }
        }

        protected static final class TestProdObj
        extends Combine.BinaryCombineFn<Integer> {
            protected TestProdObj() {
            }

            public Integer apply(Integer left, Integer right) {
                return left * right;
            }
        }

        protected static final class TestProdInt
        extends Combine.BinaryCombineIntegerFn {
            protected TestProdInt() {
            }

            public int apply(int left, int right) {
                return left * right;
            }

            public int identity() {
                return 1;
            }
        }

        protected static class GetLast
        extends DoFn<Integer, Integer> {
            protected GetLast() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                if (c.pane().isLast()) {
                    c.output((Object)((Integer)c.element()));
                }
            }
        }

        protected static class FormatPaneInfo
        extends DoFn<Integer, String> {
            protected FormatPaneInfo() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)(c.element() + ": " + c.pane().isLast()));
            }
        }

        public static class TestCombineFnWithContext
        extends CombineWithContext.CombineFnWithContext<Integer, TestCombineFn.Accumulator, String> {
            private final PCollectionView<Integer> view;

            public TestCombineFnWithContext(PCollectionView<Integer> view) {
                this.view = view;
            }

            public Coder<TestCombineFn.Accumulator> getAccumulatorCoder(CoderRegistry registry, Coder<Integer> inputCoder) {
                return TestCombineFn.Accumulator.getCoder();
            }

            public TestCombineFn.Accumulator createAccumulator(CombineWithContext.Context c) {
                Integer sideInputValue = (Integer)c.sideInput(this.view);
                return new TestCombineFn.Accumulator(sideInputValue.toString(), "");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TestCombineFn.Accumulator addInput(TestCombineFn.Accumulator accumulator, Integer value, CombineWithContext.Context c) {
                try {
                    Assert.assertThat((String)"Not expecting view contents to change", (Object)accumulator.seed, (Matcher)Matchers.equalTo((Object)Integer.toString((Integer)c.sideInput(this.view))));
                    TestCombineFn.Accumulator accumulator2 = new TestCombineFn.Accumulator(accumulator.seed, accumulator.value + String.valueOf(value));
                    return accumulator2;
                }
                finally {
                    accumulator.value = "cleared in addInput";
                }
            }

            public TestCombineFn.Accumulator mergeAccumulators(Iterable<TestCombineFn.Accumulator> accumulators, CombineWithContext.Context c) {
                String sideInputValue = ((Integer)c.sideInput(this.view)).toString();
                StringBuilder all = new StringBuilder();
                for (TestCombineFn.Accumulator accumulator : accumulators) {
                    Assert.assertThat((String)"Accumulators should all have the same Side Input Value", (Object)accumulator.seed, (Matcher)Matchers.equalTo((Object)sideInputValue));
                    all.append(accumulator.value);
                    accumulator.value = "cleared in mergeAccumulators";
                }
                return new TestCombineFn.Accumulator(sideInputValue, all.toString());
            }

            public String extractOutput(TestCombineFn.Accumulator accumulator, CombineWithContext.Context c) {
                Assert.assertThat((Object)accumulator.seed, (Matcher)Matchers.startsWith((String)((Integer)c.sideInput(this.view)).toString()));
                char[] chars = accumulator.value.toCharArray();
                Arrays.sort(chars);
                return accumulator.seed + ":" + new String(chars);
            }
        }

        public static class TestCombineFn
        extends Combine.CombineFn<Integer, Accumulator, String> {
            public Coder<Accumulator> getAccumulatorCoder(CoderRegistry registry, Coder<Integer> inputCoder) {
                return Accumulator.getCoder();
            }

            public Accumulator createAccumulator() {
                return new Accumulator("", "");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Accumulator addInput(Accumulator accumulator, Integer value) {
                try {
                    Accumulator accumulator2 = new Accumulator(accumulator.seed, accumulator.value + String.valueOf(value));
                    return accumulator2;
                }
                finally {
                    accumulator.value = "cleared in addInput";
                }
            }

            public Accumulator mergeAccumulators(Iterable<Accumulator> accumulators) {
                Accumulator seedAccumulator = null;
                StringBuilder all = new StringBuilder();
                for (Accumulator accumulator : accumulators) {
                    if (seedAccumulator == null) {
                        seedAccumulator = accumulator;
                    } else {
                        Assert.assertEquals((String)String.format("Different seed values in accumulator: %s vs. %s", seedAccumulator, accumulator), (Object)seedAccumulator.seed, (Object)accumulator.seed);
                    }
                    all.append(accumulator.value);
                    accumulator.value = "cleared in mergeAccumulators";
                }
                return new Accumulator(((Accumulator)Preconditions.checkNotNull(seedAccumulator)).seed, all.toString());
            }

            public String extractOutput(Accumulator accumulator) {
                char[] chars = accumulator.value.toCharArray();
                Arrays.sort(chars);
                return new String(chars);
            }

            static class Accumulator {
                final String seed;
                String value;

                public Accumulator(String seed, String value) {
                    this.seed = seed;
                    this.value = value;
                }

                public static Coder<Accumulator> getCoder() {
                    return new AtomicCoder<Accumulator>(){

                        public void encode(Accumulator accumulator, OutputStream outStream) throws IOException {
                            StringUtf8Coder.of().encode(accumulator.seed, outStream);
                            StringUtf8Coder.of().encode(accumulator.value, outStream);
                        }

                        public Accumulator decode(InputStream inStream) throws IOException {
                            String seed = StringUtf8Coder.of().decode(inStream);
                            String value = StringUtf8Coder.of().decode(inStream);
                            return new Accumulator(seed, value);
                        }
                    };
                }
            }
        }

        public static class TestCounter
        extends Combine.AccumulatingCombineFn<Integer, Counter, Iterable<Long>> {
            public Counter createAccumulator() {
                return new Counter(0L, 0L, 0L, 0L);
            }

            public Coder<Counter> getAccumulatorCoder(CoderRegistry registry, Coder<Integer> inputCoder) {
                return SerializableCoder.of(Counter.class);
            }

            public static class Counter
            implements Combine.AccumulatingCombineFn.Accumulator<Integer, Counter, Iterable<Long>>,
            Serializable {
                public long sum = 0L;
                public long inputs = 0L;
                public long merges = 0L;
                public long outputs = 0L;

                public Counter(long sum, long inputs, long merges, long outputs) {
                    this.sum = sum;
                    this.inputs = inputs;
                    this.merges = merges;
                    this.outputs = outputs;
                }

                public void addInput(Integer element) {
                    Preconditions.checkState(this.merges == 0L);
                    Preconditions.checkState(this.outputs == 0L);
                    ++this.inputs;
                    this.sum += (long)element.intValue();
                }

                public void mergeAccumulator(Counter accumulator) {
                    Preconditions.checkState(this.outputs == 0L);
                    Assert.assertEquals((long)0L, (long)accumulator.outputs);
                    this.merges += accumulator.merges + 1L;
                    this.inputs += accumulator.inputs;
                    this.sum += accumulator.sum;
                }

                public Iterable<Long> extractOutput() {
                    Preconditions.checkState(this.outputs == 0L);
                    return Arrays.asList(this.sum, this.inputs, this.merges, this.outputs);
                }

                public int hashCode() {
                    return (int)(this.sum * 17L + this.inputs * 31L + this.merges * 43L + this.outputs * 181L);
                }

                public boolean equals(Object otherObj) {
                    if (otherObj instanceof Counter) {
                        Counter other = (Counter)otherObj;
                        return this.sum == other.sum && this.inputs == other.inputs && this.merges == other.merges && this.outputs == other.outputs;
                    }
                    return false;
                }

                public String toString() {
                    return this.sum + ":" + this.inputs + ":" + this.merges + ":" + this.outputs;
                }
            }
        }
    }
}

