/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Objects;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineFns;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CombineFnsTest {
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testDuplicatedTags() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("it is already present in the composition");
        TupleTag tag = new TupleTag();
        CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), tag).with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Min.ofIntegers(), tag);
    }

    @Test
    public void testDuplicatedTagsKeyed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("it is already present in the composition");
        TupleTag tag = new TupleTag();
        CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), tag).with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Min.ofIntegers(), tag);
    }

    @Test
    public void testDuplicatedTagsWithContext() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("it is already present in the composition");
        TupleTag tag = new TupleTag();
        CombineFns.compose().with((SimpleFunction)new GetUserStringFunction(), (CombineWithContext.CombineFnWithContext)new ConcatStringWithContext(null), tag).with((SimpleFunction)new GetUserStringFunction(), (CombineFnBase.GlobalCombineFn)new ConcatStringWithContext(null), tag);
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testComposedCombine() {
        this.p.getCoderRegistry().registerCoderForClass(UserString.class, (Coder)UserStringCoder.of());
        PCollection perKeyInput = (PCollection)this.p.apply((PTransform)Create.timestamped(Arrays.asList(KV.of((Object)"a", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"a", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"a", (Object)KV.of((Object)4, (Object)UserString.of("4"))), KV.of((Object)"b", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"b", (Object)KV.of((Object)13, (Object)UserString.of("13")))), Arrays.asList(0L, 4L, 7L, 10L, 16L)).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)UserStringCoder.of()))));
        TupleTag maxIntTag = new TupleTag();
        TupleTag concatStringTag = new TupleTag();
        PCollection combineGlobally = (PCollection)((PCollection)((PCollection)((PCollection)perKeyInput.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), maxIntTag).with((SimpleFunction)new GetUserStringFunction(), (Combine.CombineFn)new ConcatString(), concatStringTag)))).apply((PTransform)WithKeys.of((Object)"global"))).apply("ExtractGloballyResult", (PTransform)ParDo.of((DoFn)new ExtractResultDoFn((TupleTag<Integer>)maxIntTag, (TupleTag<UserString>)concatStringTag)));
        PCollection combinePerKey = (PCollection)((PCollection)perKeyInput.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), maxIntTag).with((SimpleFunction)new GetUserStringFunction(), (Combine.CombineFn)new ConcatString(), concatStringTag)))).apply("ExtractPerKeyResult", (PTransform)ParDo.of((DoFn)new ExtractResultDoFn((TupleTag<Integer>)maxIntTag, (TupleTag<UserString>)concatStringTag)));
        PAssert.that((PCollection)combineGlobally).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"global", (Object)KV.of((Object)13, (Object)"111134"))});
        PAssert.that((PCollection)combinePerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)KV.of((Object)4, (Object)"114")), KV.of((Object)"b", (Object)KV.of((Object)13, (Object)"113"))});
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testComposedCombineWithContext() {
        this.p.getCoderRegistry().registerCoderForClass(UserString.class, (Coder)UserStringCoder.of());
        PCollectionView view = (PCollectionView)((PCollection)this.p.apply((PTransform)Create.of((Object)"I", (Object[])new String[0]))).apply((PTransform)View.asSingleton());
        PCollection perKeyInput = (PCollection)this.p.apply((PTransform)Create.timestamped(Arrays.asList(KV.of((Object)"a", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"a", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"a", (Object)KV.of((Object)4, (Object)UserString.of("4"))), KV.of((Object)"b", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"b", (Object)KV.of((Object)13, (Object)UserString.of("13")))), Arrays.asList(0L, 4L, 7L, 10L, 16L)).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)UserStringCoder.of()))));
        TupleTag maxIntTag = new TupleTag();
        TupleTag concatStringTag = new TupleTag();
        PCollection combineGlobally = (PCollection)((PCollection)((PCollection)((PCollection)perKeyInput.apply((PTransform)Values.create())).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), maxIntTag).with((SimpleFunction)new GetUserStringFunction(), (CombineWithContext.CombineFnWithContext)new ConcatStringWithContext(view), concatStringTag)).withoutDefaults().withSideInputs(ImmutableList.of(view)))).apply((PTransform)WithKeys.of((Object)"global"))).apply("ExtractGloballyResult", (PTransform)ParDo.of((DoFn)new ExtractResultDoFn((TupleTag<Integer>)maxIntTag, (TupleTag<UserString>)concatStringTag)));
        PCollection combinePerKey = (PCollection)((PCollection)perKeyInput.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), maxIntTag).with((SimpleFunction)new GetUserStringFunction(), (CombineWithContext.CombineFnWithContext)new ConcatStringWithContext(view), concatStringTag)).withSideInputs(ImmutableList.of(view)))).apply("ExtractPerKeyResult", (PTransform)ParDo.of((DoFn)new ExtractResultDoFn((TupleTag<Integer>)maxIntTag, (TupleTag<UserString>)concatStringTag)));
        PAssert.that((PCollection)combineGlobally).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"global", (Object)KV.of((Object)13, (Object)"111134I"))});
        PAssert.that((PCollection)combinePerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)KV.of((Object)4, (Object)"114I")), KV.of((Object)"b", (Object)KV.of((Object)13, (Object)"113I"))});
        this.p.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testComposedCombineNullValues() {
        this.p.getCoderRegistry().registerCoderForClass(UserString.class, (Coder)NullableCoder.of((Coder)UserStringCoder.of()));
        this.p.getCoderRegistry().registerCoderForClass(String.class, (Coder)NullableCoder.of((Coder)StringUtf8Coder.of()));
        PCollection perKeyInput = (PCollection)this.p.apply((PTransform)Create.timestamped(Arrays.asList(KV.of((Object)"a", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"a", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"a", (Object)KV.of((Object)4, (Object)UserString.of("4"))), KV.of((Object)"b", (Object)KV.of((Object)1, (Object)UserString.of("1"))), KV.of((Object)"b", (Object)KV.of((Object)13, (Object)UserString.of("13")))), Arrays.asList(0L, 4L, 7L, 10L, 16L)).withCoder((Coder)KvCoder.of((Coder)NullableCoder.of((Coder)StringUtf8Coder.of()), (Coder)KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)NullableCoder.of((Coder)UserStringCoder.of())))));
        TupleTag maxIntTag = new TupleTag();
        TupleTag concatStringTag = new TupleTag();
        PCollection combinePerKey = (PCollection)((PCollection)perKeyInput.apply((PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)CombineFns.compose().with((SimpleFunction)new GetIntegerFunction(), (Combine.CombineFn)Max.ofIntegers(), maxIntTag).with((SimpleFunction)new GetUserStringFunction(), (Combine.CombineFn)new OutputNullString(), concatStringTag)))).apply("ExtractPerKeyResult", (PTransform)ParDo.of((DoFn)new ExtractResultDoFn((TupleTag<Integer>)maxIntTag, (TupleTag<UserString>)concatStringTag)));
        PAssert.that((PCollection)combinePerKey).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)KV.of((Object)4, (Object)null)), KV.of((Object)"b", (Object)KV.of((Object)13, (Object)null))});
        this.p.run();
    }

    @Test
    public void testComposedCombineDisplayData() {
        SimpleFunction<String, String> extractFn = new SimpleFunction<String, String>(){

            public String apply(String input) {
                return input;
            }
        };
        DisplayDataCombineFn combineFn1 = new DisplayDataCombineFn("value1");
        DisplayDataCombineFn combineFn2 = new DisplayDataCombineFn("value2");
        CombineFns.ComposedCombineFn composedCombine = CombineFns.compose().with((SimpleFunction)extractFn, (Combine.CombineFn)combineFn1, new TupleTag()).with((SimpleFunction)extractFn, (Combine.CombineFn)combineFn2, new TupleTag());
        DisplayData displayData = DisplayData.from((HasDisplayData)composedCombine);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("combineFn1", ((Object)((Object)combineFn1)).getClass()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("combineFn2", ((Object)((Object)combineFn2)).getClass()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.includesDisplayDataFor("combineFn1", (HasDisplayData)combineFn1));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.includesDisplayDataFor("combineFn2", (HasDisplayData)combineFn2));
    }

    private static class ExtractResultDoFn
    extends DoFn<KV<String, CombineFns.CoCombineResult>, KV<String, KV<Integer, String>>> {
        private final TupleTag<Integer> maxIntTag;
        private final TupleTag<UserString> concatStringTag;

        ExtractResultDoFn(TupleTag<Integer> maxIntTag, TupleTag<UserString> concatStringTag) {
            this.maxIntTag = maxIntTag;
            this.concatStringTag = concatStringTag;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            UserString userString = (UserString)((CombineFns.CoCombineResult)((KV)c.element()).getValue()).get(this.concatStringTag);
            KV value = KV.of((Object)((Integer)((CombineFns.CoCombineResult)((KV)c.element()).getValue()).get(this.maxIntTag)), (Object)(userString == null ? null : userString.strValue));
            c.output((Object)KV.of((Object)((String)((KV)c.element()).getKey()), (Object)value));
        }
    }

    private static class ConcatStringWithContext
    extends CombineWithContext.CombineFnWithContext<UserString, UserString, UserString> {
        private final PCollectionView<String> view;

        private ConcatStringWithContext(PCollectionView<String> view) {
            this.view = view;
        }

        public UserString createAccumulator(CombineWithContext.Context c) {
            return UserString.of((String)c.sideInput(this.view));
        }

        public UserString addInput(UserString accumulator, UserString input, CombineWithContext.Context c) {
            Assert.assertThat((Object)accumulator.strValue, (Matcher)Matchers.startsWith((String)((String)c.sideInput(this.view))));
            accumulator.strValue = accumulator.strValue + input.strValue;
            return accumulator;
        }

        public UserString mergeAccumulators(Iterable<UserString> accumulators, CombineWithContext.Context c) {
            String keyPrefix;
            String all = keyPrefix = (String)c.sideInput(this.view);
            for (UserString accumulator : accumulators) {
                Assert.assertThat((Object)accumulator.strValue, (Matcher)Matchers.startsWith((String)keyPrefix));
                all = all + accumulator.strValue.substring(keyPrefix.length());
                accumulator.strValue = "cleared in mergeAccumulators";
            }
            return UserString.of(all);
        }

        public UserString extractOutput(UserString accumulator, CombineWithContext.Context c) {
            Assert.assertThat((Object)accumulator.strValue, (Matcher)Matchers.startsWith((String)((String)c.sideInput(this.view))));
            char[] chars = accumulator.strValue.toCharArray();
            Arrays.sort(chars);
            return UserString.of(new String(chars));
        }
    }

    private static class OutputNullString
    extends Combine.BinaryCombineFn<UserString> {
        private OutputNullString() {
        }

        public UserString apply(UserString left, UserString right) {
            return null;
        }
    }

    private static class ConcatString
    extends Combine.BinaryCombineFn<UserString> {
        private ConcatString() {
        }

        public UserString apply(UserString left, UserString right) {
            String retStr = left.strValue + right.strValue;
            char[] chars = retStr.toCharArray();
            Arrays.sort(chars);
            return UserString.of(new String(chars));
        }
    }

    private static class GetUserStringFunction
    extends SimpleFunction<KV<Integer, UserString>, UserString> {
        private GetUserStringFunction() {
        }

        public UserString apply(KV<Integer, UserString> input) {
            return (UserString)input.getValue();
        }
    }

    private static class GetIntegerFunction
    extends SimpleFunction<KV<Integer, UserString>, Integer> {
        private GetIntegerFunction() {
        }

        public Integer apply(KV<Integer, UserString> input) {
            return (Integer)input.getKey();
        }
    }

    private static class UserStringCoder
    extends AtomicCoder<UserString> {
        private static final UserStringCoder INSTANCE = new UserStringCoder();

        private UserStringCoder() {
        }

        public static UserStringCoder of() {
            return INSTANCE;
        }

        public void encode(UserString value, OutputStream outStream) throws CoderException, IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        public void encode(UserString value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            StringUtf8Coder.of().encode(value.strValue, outStream, context);
        }

        public UserString decode(InputStream inStream) throws CoderException, IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        public UserString decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            return UserString.of(StringUtf8Coder.of().decode(inStream, context));
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }

    private static class UserString
    implements Serializable {
        private String strValue;

        private UserString() {
        }

        static UserString of(String strValue) {
            UserString ret = new UserString();
            ret.strValue = strValue;
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserString that = (UserString)o;
            return Objects.equal(this.strValue, that.strValue);
        }

        public int hashCode() {
            return Objects.hashCode(this.strValue);
        }
    }

    private static class DisplayDataCombineFn
    extends Combine.CombineFn<String, String, String> {
        private final String value;
        private static int i;
        private final int id = ++i;

        DisplayDataCombineFn(String value) {
            this.value = value;
        }

        public String createAccumulator() {
            return null;
        }

        public String addInput(String accumulator, String input) {
            return null;
        }

        public String mergeAccumulators(Iterable<String> accumulators) {
            return null;
        }

        public String extractOutput(String accumulator) {
            return null;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)("uniqueKey" + this.id), (String)this.value)).add(DisplayData.item((String)"sharedKey", (String)this.value));
        }
    }
}

