/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.ApproximateQuantiles;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableComparator;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

public class ApproximateQuantilesTest {

    @RunWith(value=Parameterized.class)
    public static class BufferTests {
        private final double epsilon;
        private final long maxInputSize;
        private final int expectedNumBuffers;
        private final int expectedBufferSize;
        private final ApproximateQuantiles.ApproximateQuantilesCombineFn<?, ?> combineFn;
        private static final double[] epsilons = new double[]{0.1, 0.05, 0.01, 0.005, 0.001};
        private static final int[] maxElementExponents = new int[]{5, 6, 7, 8, 9};
        private static final int[][] expectedNumBuffersValues = new int[][]{{11, 14, 17, 21, 24}, {11, 14, 17, 20, 23}, {9, 11, 14, 17, 21}, {8, 11, 14, 17, 20}, {6, 9, 11, 14, 17}};
        private static final int[][] expectedBufferSizeValues = new int[][]{{98, 123, 153, 96, 120}, {98, 123, 153, 191, 239}, {391, 977, 1221, 1526, 954}, {782, 977, 1221, 1526, 1908}, {3125, 3907, 9766, 12208, 15259}};

        @Parameterized.Parameters(name="{index}: epsilon = {0}, maxInputSize = {1}")
        public static Collection<Object[]> data() {
            ArrayList<Object[]> testData = Lists.newArrayList();
            for (int i = 0; i < epsilons.length; ++i) {
                for (int j = 0; j < maxElementExponents.length; ++j) {
                    testData.add(new Object[]{epsilons[i], (long)Math.pow(10.0, maxElementExponents[j]), expectedNumBuffersValues[i][j], expectedBufferSizeValues[i][j]});
                }
            }
            return testData;
        }

        public BufferTests(Double epsilon, Long maxInputSize, Integer expectedNumBuffers, Integer expectedBufferSize) {
            this.epsilon = epsilon;
            this.maxInputSize = maxInputSize;
            this.expectedNumBuffers = expectedNumBuffers;
            this.expectedBufferSize = expectedBufferSize;
            this.combineFn = ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)10, (Comparator)new Top.Natural(), (long)maxInputSize, (double)epsilon);
        }

        @Test
        public void testEfficiency() {
            Assert.assertEquals((String)"Number of buffers", (long)this.expectedNumBuffers, (long)this.combineFn.getNumBuffers());
            Assert.assertEquals((String)"Buffer size", (long)this.expectedBufferSize, (long)this.combineFn.getBufferSize());
        }

        @Test
        public void testCorrectness() {
            int b = this.combineFn.getNumBuffers();
            int k = this.combineFn.getBufferSize();
            long n = this.maxInputSize;
            MatcherAssert.assertThat((String)"(b-2)2^(b-2) + 1/2 <= eN", (Object)((double)((b - 2) * (1 << b - 2)) + 0.5), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(this.epsilon * (double)n)));
            MatcherAssert.assertThat((String)"k2^(b-1) >= N", (Object)Math.pow(k * 2, b - 1), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(n)));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class CombinerTests {
        static final List<KV<String, Integer>> TABLE = Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"a", (Object)2), KV.of((Object)"a", (Object)3), KV.of((Object)"b", (Object)1), KV.of((Object)"b", (Object)10), KV.of((Object)"b", (Object)10), KV.of((Object)"b", (Object)100));
        @Rule
        public TestPipeline p = TestPipeline.create();

        public PCollection<KV<String, Integer>> createInputTable(Pipeline p) {
            return (PCollection)p.apply((PTransform)Create.of(TABLE).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())));
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testQuantilesGlobally() {
            PCollection<Integer> input = this.intRangeCollection((Pipeline)this.p, 101);
            PCollection quantiles = (PCollection)input.apply(ApproximateQuantiles.globally((int)5));
            PAssert.that((PCollection)quantiles).containsInAnyOrder((Object[])new List[]{Arrays.asList(0, 25, 50, 75, 100)});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testQuantilesGobally_comparable() {
            PCollection<Integer> input = this.intRangeCollection((Pipeline)this.p, 101);
            PCollection quantiles = (PCollection)input.apply(ApproximateQuantiles.globally((int)5, (Comparator)((Object)new DescendingIntComparator())));
            PAssert.that((PCollection)quantiles).containsInAnyOrder((Object[])new List[]{Arrays.asList(100, 75, 50, 25, 0)});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testQuantilesPerKey() {
            PCollection<KV<String, Integer>> input = this.createInputTable((Pipeline)this.p);
            PCollection quantiles = (PCollection)input.apply(ApproximateQuantiles.perKey((int)2));
            PAssert.that((PCollection)quantiles).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", Arrays.asList(1, 3)), KV.of((Object)"b", Arrays.asList(1, 100))});
            this.p.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testQuantilesPerKey_reversed() {
            PCollection<KV<String, Integer>> input = this.createInputTable((Pipeline)this.p);
            PCollection quantiles = (PCollection)input.apply(ApproximateQuantiles.perKey((int)2, (Comparator)((Object)new DescendingIntComparator())));
            PAssert.that((PCollection)quantiles).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", Arrays.asList(3, 1)), KV.of((Object)"b", Arrays.asList(100, 1))});
            this.p.run();
        }

        @Test
        public void testSingleton() {
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)5), Arrays.asList(389), Arrays.asList(389, 389, 389, 389, 389));
        }

        @Test
        public void testSimpleQuantiles() {
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)5), this.intRange(101), Arrays.asList(0, 25, 50, 75, 100));
        }

        @Test
        public void testUnevenQuantiles() {
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)37), this.intRange(5000), this.quantileMatcher(5000, 37, 20));
        }

        @Test
        public void testLargerQuantiles() {
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)50), this.intRange(10001), this.quantileMatcher(10001, 50, 20));
        }

        @Test
        public void testTightEpsilon() {
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)10).withEpsilon(0.01), this.intRange(10001), this.quantileMatcher(10001, 10, 5));
        }

        @Test
        public void testDuplicates() {
            int size = 101;
            ArrayList<Integer> all = new ArrayList<Integer>();
            for (int i = 0; i < 10; ++i) {
                all.addAll(this.intRange(size));
            }
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)5), all, Arrays.asList(0, 25, 50, 75, 100));
        }

        @Test
        public void testLotsOfDuplicates() {
            int i;
            ArrayList<Integer> all = new ArrayList<Integer>();
            all.add(1);
            for (i = 1; i < 300; ++i) {
                all.add(2);
            }
            for (i = 300; i < 1000; ++i) {
                all.add(3);
            }
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)5), all, Arrays.asList(1, 2, 3, 3, 3));
        }

        @Test
        public void testLogDistribution() {
            ArrayList<Integer> all = new ArrayList<Integer>();
            for (int i = 1; i < 1000; ++i) {
                all.add((int)Math.log(i));
            }
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)5), all, Arrays.asList(0, 5, 6, 6, 6));
        }

        @Test
        public void testZipfianDistribution() {
            ArrayList<Integer> all = new ArrayList<Integer>();
            for (int i = 1; i < 1000; ++i) {
                all.add(1000 / i);
            }
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)5), all, Arrays.asList(1, 1, 2, 4, 1000));
        }

        @Test
        public void testAlternateComparator() {
            List<String> inputs = Arrays.asList("aa", "aaa", "aaaa", "b", "ccccc", "dddd", "zz");
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)3), inputs, Arrays.asList("aa", "b", "zz"));
            CombineFnTester.testCombineFn((Combine.CombineFn)ApproximateQuantiles.ApproximateQuantilesCombineFn.create((int)3, (Comparator)new OrderByLength()), inputs, Arrays.asList("b", "aaa", "ccccc"));
        }

        @Test
        public void testDisplayData() {
            Top.Natural comparer = new Top.Natural();
            PTransform approxQuanitiles = ApproximateQuantiles.globally((int)20, (Comparator)comparer);
            DisplayData displayData = DisplayData.from((HasDisplayData)approxQuanitiles);
            MatcherAssert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("numQuantiles", 20L));
            MatcherAssert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("comparer", comparer.getClass()));
        }

        private Matcher<Iterable<? extends Integer>> quantileMatcher(int size, int numQuantiles, int absoluteError) {
            ArrayList<Object> quantiles = new ArrayList<Object>();
            quantiles.add(CoreMatchers.is((Object)0));
            for (int k = 1; k < numQuantiles - 1; ++k) {
                int expected = (int)((double)(size - 1) * (double)k / (double)(numQuantiles - 1));
                quantiles.add((Object)new Between(Integer.valueOf(expected - absoluteError), Integer.valueOf(expected + absoluteError), null));
            }
            quantiles.add(CoreMatchers.is((Object)(size - 1)));
            return IsIterableContainingInOrder.contains(quantiles);
        }

        private PCollection<Integer> intRangeCollection(Pipeline p, int size) {
            return (PCollection)p.apply("CreateIntsUpTo(" + size + ")", (PTransform)Create.of(this.intRange(size)));
        }

        private List<Integer> intRange(int size) {
            ArrayList<Integer> all = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                all.add(i);
            }
            return all;
        }

        private static class OrderByLength
        implements Comparator<String>,
        Serializable {
            private OrderByLength() {
            }

            @Override
            public int compare(String a, String b) {
                if (a.length() != b.length()) {
                    return a.length() - b.length();
                }
                return a.compareTo(b);
            }
        }

        private static class DescendingIntComparator
        implements SerializableComparator<Integer> {
            private DescendingIntComparator() {
            }

            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        }

        private static class Between<T extends Comparable<T>>
        extends TypeSafeDiagnosingMatcher<T> {
            private final T min;
            private final T max;

            private Between(T min, T max) {
                this.min = min;
                this.max = max;
            }

            public void describeTo(Description description) {
                description.appendText("is between " + this.min + " and " + this.max);
            }

            protected boolean matchesSafely(T item, Description mismatchDescription) {
                return this.min.compareTo(item) <= 0 && item.compareTo(this.max) <= 0;
            }

            /* synthetic */ Between(Comparable x0, Comparable x1, 1 x2) {
                this(x0, x1);
            }
        }
    }
}

