/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.WindowSupplier;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.SerializableUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WindowSupplierTest {
    private final IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(100L));
    private final IntervalWindow otherWindow = new IntervalWindow(new Instant(-100L), new Instant(100L));
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void getReturnsProvidedWindows() {
        Assert.assertThat((Object)WindowSupplier.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.window, this.otherWindow)).get(), (Matcher)Matchers.containsInAnyOrder((Object[])new BoundedWindow[]{this.otherWindow, this.window}));
    }

    @Test
    public void getAfterSerialization() {
        WindowSupplier supplier = WindowSupplier.of((Coder)IntervalWindow.getCoder(), ImmutableList.of(this.window, this.otherWindow));
        Assert.assertThat((Object)((WindowSupplier)SerializableUtils.clone((Serializable)supplier)).get(), (Matcher)Matchers.containsInAnyOrder((Object[])new BoundedWindow[]{this.otherWindow, this.window}));
    }

    @Test
    public void unencodableWindowFails() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Could not encode");
        WindowSupplier.of((Coder)new FailingCoder(), Collections.singleton(this.window));
    }

    private static class FailingCoder
    extends AtomicCoder<BoundedWindow> {
        private FailingCoder() {
        }

        public void encode(BoundedWindow value, OutputStream outStream) throws CoderException, IOException {
            throw new CoderException("Test Encode Exception");
        }

        public BoundedWindow decode(InputStream inStream) throws CoderException, IOException {
            throw new CoderException("Test Decode Exception");
        }
    }
}

