/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ThreadLeakTracker
implements TestRule {
    private final Field groupField;

    public ThreadLeakTracker() {
        try {
            this.groupField = Thread.class.getDeclaredField("group");
            if (!this.groupField.isAccessible()) {
                this.groupField.setAccessible(true);
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Thread thread = Thread.currentThread();
                ThreadGroup threadGroup = thread.getThreadGroup();
                ThreadGroup testGroup = new ThreadGroup(threadGroup, Long.toString(thread.getId()));
                ThreadLeakTracker.this.groupField.set(thread, testGroup);
                try {
                    base.evaluate();
                }
                finally {
                    ThreadLeakTracker.this.groupField.set(thread, threadGroup);
                    Thread[] threads = ThreadLeakTracker.this.listThreads();
                    List leaked = Stream.of(threads).filter(t -> t.getThreadGroup() == testGroup).collect(Collectors.toList());
                    if (!leaked.isEmpty()) {
                        Assert.fail((String)("Some threads leaked: " + leaked.stream().map(Thread::getName).collect(Collectors.joining("\n- ", "\n- ", ""))));
                    }
                }
            }
        };
    }

    private Thread[] listThreads() {
        int count = Thread.activeCount();
        Thread[] threads = new Thread[Math.max(count * 2, 16)];
        int threadCount = Thread.enumerate(threads);
        Thread[] array = new Thread[threadCount];
        System.arraycopy(threads, 0, array, 0, threadCount);
        return array;
    }
}

