/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RestoreSystemProperties;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

public class TestPipelineTest
implements Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));

    @RunWith(value=JUnit4.class)
    public static class NewProviderTest
    implements Serializable {
        @Rule
        public transient TestPipeline pipeline = TestPipeline.create();

        @Test
        @Category(value={NeedsRunner.class})
        public void testNewProvider() {
            ValueProvider foo = this.pipeline.newProvider((Object)"foo");
            ValueProvider.NestedValueProvider foobar = ValueProvider.NestedValueProvider.of((ValueProvider)foo, (SerializableFunction & Serializable)input -> input + "bar");
            Assert.assertFalse((boolean)foo.isAccessible());
            Assert.assertFalse((boolean)foobar.isAccessible());
            PAssert.that((PCollection)((PCollection)this.pipeline.apply("create foo", (PTransform)Create.ofProvider((ValueProvider)foo, (Coder)StringUtf8Coder.of())))).containsInAnyOrder((Object[])new String[]{"foo"});
            PAssert.that((PCollection)((PCollection)this.pipeline.apply("create foobar", (PTransform)Create.ofProvider((ValueProvider)foobar, (Coder)StringUtf8Coder.of())))).containsInAnyOrder((Object[])new String[]{"foobar"});
            this.pipeline.run();
        }
    }

    public static class TestPipelineEnforcementsTest
    implements Serializable {
        private static final List<String> WORDS = Collections.singletonList("hi there");
        private static final String WHATEVER = "expected";
        private static final String P_TRANSFORM = "PTransform";
        private static final String P_ASSERT = "PAssert";

        private static PCollection<String> addTransform(PCollection<String> pCollection) {
            return (PCollection)pCollection.apply("Map2", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                public String apply(String input) {
                    return TestPipelineEnforcementsTest.WHATEVER;
                }
            }));
        }

        private static PCollection<String> pCollection(Pipeline pipeline) {
            return (PCollection)((PCollection)pipeline.apply("Create", (PTransform)Create.of(WORDS).withCoder((Coder)StringUtf8Coder.of()))).apply("Map1", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                public String apply(String input) {
                    return TestPipelineEnforcementsTest.WHATEVER;
                }
            }));
        }

        @RunWith(value=JUnit4.class)
        public static class WithCrashingPipelineRunner {
            private final transient ExpectedException exception = ExpectedException.none();
            private final transient TestPipeline pipeline = TestPipeline.create();
            @Rule
            public final transient RuleChain chain = RuleChain.outerRule((TestRule)this.exception).around((TestRule)this.pipeline);

            @Test
            public void testNoTestPipelineUsed() {
            }

            @Test
            public void testMissingRun() throws Exception {
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline));
            }

            static {
                System.setProperty("beamUseDummyRunner", Boolean.TRUE.toString());
            }
        }

        @RunWith(value=JUnit4.class)
        public static class WithRealPipelineRunner {
            private final transient ExpectedException exception = ExpectedException.none();
            private final transient TestPipeline pipeline = TestPipeline.create();
            @Rule
            public final transient RuleChain chain = RuleChain.outerRule((TestRule)this.exception).around((TestRule)this.pipeline);

            @Category(value={NeedsRunner.class})
            @Test
            public void testNormalFlow() throws Exception {
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline));
                this.pipeline.run();
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testMissingRun() throws Exception {
                this.exception.expect(TestPipeline.PipelineRunMissingException.class);
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline));
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testMissingRunWithDisabledEnforcement() throws Exception {
                this.pipeline.enableAbandonedNodeEnforcement(false);
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline));
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testMissingRunAutoAdd() throws Exception {
                this.pipeline.enableAutoRunIfMissing(true);
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline));
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testDanglingPTransformValidatesRunner() throws Exception {
                PCollection pCollection = TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline);
                PAssert.that((PCollection)pCollection).containsInAnyOrder((Object[])new String[]{TestPipelineEnforcementsTest.WHATEVER});
                this.pipeline.run().waitUntilFinish();
                this.exception.expect(TestPipeline.AbandonedNodeException.class);
                this.exception.expectMessage(TestPipelineEnforcementsTest.P_TRANSFORM);
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)pCollection);
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testDanglingPTransformNeedsRunner() throws Exception {
                PCollection pCollection = TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline);
                PAssert.that((PCollection)pCollection).containsInAnyOrder((Object[])new String[]{TestPipelineEnforcementsTest.WHATEVER});
                this.pipeline.run().waitUntilFinish();
                this.exception.expect(TestPipeline.AbandonedNodeException.class);
                this.exception.expectMessage(TestPipelineEnforcementsTest.P_TRANSFORM);
                TestPipelineEnforcementsTest.addTransform((PCollection<String>)pCollection);
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testDanglingPAssertValidatesRunner() throws Exception {
                PCollection pCollection = TestPipelineEnforcementsTest.pCollection((Pipeline)this.pipeline);
                PAssert.that((PCollection)pCollection).containsInAnyOrder((Object[])new String[]{TestPipelineEnforcementsTest.WHATEVER});
                this.pipeline.run().waitUntilFinish();
                this.exception.expect(TestPipeline.AbandonedNodeException.class);
                this.exception.expectMessage(TestPipelineEnforcementsTest.P_ASSERT);
                PAssert.that((PCollection)pCollection).containsInAnyOrder((Object[])new String[]{TestPipelineEnforcementsTest.WHATEVER});
            }

            @Category(value={NeedsRunner.class})
            @Test
            public void testNoTestPipelineUsedValidatesRunner() {
            }

            @Test
            public void testNoTestPipelineUsedNoAnnotation() {
            }
        }
    }

    @RunWith(value=JUnit4.class)
    public static class TestPipelineCreationTest {
        @Rule
        public transient TestRule restoreSystemProperties = new RestoreSystemProperties();
        @Rule
        public transient ExpectedException thrown = ExpectedException.none();
        @Rule
        public transient TestPipeline pipeline = TestPipeline.create();

        @Test
        public void testCreationUsingDefaults() {
            Assert.assertNotNull((Object)this.pipeline);
            Assert.assertNotNull((Object)TestPipeline.create());
        }

        @Test
        public void testCreationNotAsTestRule() {
            this.thrown.expect(IllegalStateException.class);
            this.thrown.expectMessage("@Rule");
            TestPipeline.create().run();
        }

        @Test
        public void testCreationOfPipelineOptions() throws Exception {
            String stringOptions = MAPPER.writeValueAsString((Object)new String[]{"--runner=org.apache.beam.sdk.testing.CrashingRunner"});
            System.getProperties().put("beamTestPipelineOptions", stringOptions);
            PipelineOptions options = TestPipeline.testingPipelineOptions();
            Assert.assertEquals(CrashingRunner.class, (Object)options.getRunner());
        }

        @Test
        public void testCreationOfPipelineOptionsFromReallyVerboselyNamedTestCase() throws Exception {
            PipelineOptions options = this.pipeline.getOptions();
            Assert.assertThat((Object)((ApplicationNameOptions)options.as(ApplicationNameOptions.class)).getAppName(), (Matcher)Matchers.startsWith((String)"TestPipelineTest$TestPipelineCreationTest-testCreationOfPipelineOptionsFromReallyVerboselyNamedTestCase"));
        }

        @Test
        public void testToString() {
            Assert.assertEquals((Object)"TestPipeline#TestPipelineTest$TestPipelineCreationTest-testToString", (Object)this.pipeline.toString());
        }

        @Test
        public void testRunWithDummyEnvironmentVariableFails() {
            System.getProperties().setProperty("beamUseDummyRunner", Boolean.toString(true));
            this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
            this.thrown.expect(IllegalArgumentException.class);
            this.thrown.expectMessage("Cannot call #run");
            this.pipeline.run();
        }

        public static class TestMatcher
        extends BaseMatcher<PipelineResult>
        implements SerializableMatcher<PipelineResult> {
            private final UUID uuid = UUID.randomUUID();

            public boolean matches(Object o) {
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("%tL", new Date()));
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof TestMatcher)) {
                    return false;
                }
                TestMatcher other = (TestMatcher)((Object)obj);
                return other.uuid.equals(this.uuid);
            }

            public int hashCode() {
                return this.uuid.hashCode();
            }
        }
    }
}

