/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import org.apache.beam.sdk.testing.SystemNanoTimeSleeper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SystemNanoTimeSleeperTest {
    @Test
    public void testSleep() throws Exception {
        long startTime = System.nanoTime();
        SystemNanoTimeSleeper.sleepMillis(100L);
        long endTime = System.nanoTime();
        Assert.assertTrue((endTime - startTime >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeSleep() throws Exception {
        SystemNanoTimeSleeper.sleepMillis(-100L);
    }

    @Test(expected=InterruptedException.class)
    public void testInterruptionInLoop() throws Exception {
        Thread.currentThread().interrupt();
        SystemNanoTimeSleeper.sleepMillis(0L);
    }

    @Test(expected=InterruptedException.class)
    public void testInterruptionOutsideOfLoop() throws Exception {
        Thread.currentThread().interrupt();
        SystemNanoTimeSleeper.sleepMillis(-100L);
    }
}

